/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.sdk;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.layout.descriptors.LayoutDescriptors;
import com.android.ide.eclipse.adt.internal.editors.manifest.descriptors.AndroidManifestDescriptors;
import com.android.ide.eclipse.adt.internal.editors.menu.descriptors.MenuDescriptors;
import com.android.ide.eclipse.adt.internal.editors.xml.descriptors.XmlDescriptors;
import com.android.ide.eclipse.adt.internal.resources.AttrsXmlParser;
import com.android.ide.eclipse.adt.internal.resources.DeclareStyleableInfo;
import com.android.ide.eclipse.adt.internal.resources.IResourceRepository;
import com.android.ide.eclipse.adt.internal.resources.ResourceItem;
import com.android.ide.eclipse.adt.internal.resources.ResourceType;
import com.android.ide.eclipse.adt.internal.resources.ViewClassInfo;
import com.android.ide.eclipse.adt.internal.resources.manager.ProjectResources;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceManager;
import com.android.ide.eclipse.adt.internal.sdk.AndroidJarLoader;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.ide.eclipse.adt.internal.sdk.DexWrapper;
import com.android.ide.eclipse.adt.internal.sdk.FrameworkResourceRepository;
import com.android.ide.eclipse.adt.internal.sdk.IAndroidClassLoader;
import com.android.ide.eclipse.adt.internal.sdk.LayoutParamsParser;
import com.android.ide.eclipse.adt.internal.sdk.LoadStatus;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.ide.eclipse.adt.internal.sdk.WidgetClassLoader;
import com.android.layoutlib.api.ILayoutBridge;
import com.android.sdklib.IAndroidTarget;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.InvalidAttributeValueException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AndroidTargetParser {
    private static final String TAG = "Framework Resource Parser";
    private final IAndroidTarget mAndroidTarget;

    public AndroidTargetParser(IAndroidTarget iAndroidTarget) {
        this.mAndroidTarget = iAndroidTarget;
    }

    public IStatus run(IProgressMonitor iProgressMonitor) {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)String.format("Parsing SDK %1$s", this.mAndroidTarget.getName()), (int)14);
            AndroidTargetData androidTargetData = new AndroidTargetData(this.mAndroidTarget);
            DexWrapper dexWrapper = new DexWrapper();
            IStatus iStatus = dexWrapper.loadDex(this.mAndroidTarget.getPath(23));
            if (iStatus != Status.OK_STATUS) {
                return new Status(4, "com.android.ide.eclipse.adt", String.format("dx.jar loading failed for target '%1$s'", this.mAndroidTarget.getFullName()));
            }
            androidTargetData.setDexWrapper(dexWrapper);
            subMonitor.worked(1);
            AndroidJarLoader androidJarLoader = new AndroidJarLoader(this.mAndroidTarget.getPath(1));
            this.preload(androidJarLoader, (IProgressMonitor)subMonitor.newChild(40, 0));
            if (subMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            subMonitor.subTask("Resource IDs");
            IResourceRepository iResourceRepository = this.collectResourceIds(androidJarLoader);
            subMonitor.worked(1);
            if (subMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            subMonitor.subTask("Permissions");
            String[] stringArray = this.collectPermissions(androidJarLoader);
            subMonitor.worked(1);
            if (subMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            subMonitor.subTask("Intents");
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ArrayList<String> arrayList4 = new ArrayList<String>();
            this.collectIntentFilterActionsAndCategories(arrayList, arrayList2, arrayList3, arrayList4);
            subMonitor.worked(1);
            if (subMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            subMonitor.subTask("Attributes definitions");
            AttrsXmlParser attrsXmlParser = new AttrsXmlParser(this.mAndroidTarget.getPath(8));
            attrsXmlParser.preload();
            subMonitor.worked(1);
            subMonitor.subTask("Manifest definitions");
            AttrsXmlParser attrsXmlParser2 = new AttrsXmlParser(this.mAndroidTarget.getPath(9), attrsXmlParser);
            attrsXmlParser2.preload();
            subMonitor.worked(1);
            ArrayList<ViewClassInfo> arrayList5 = new ArrayList<ViewClassInfo>();
            ArrayList<ViewClassInfo> arrayList6 = new ArrayList<ViewClassInfo>();
            subMonitor.subTask("Widgets and layouts");
            this.collectLayoutClasses(androidJarLoader, attrsXmlParser, arrayList5, arrayList6, (IProgressMonitor)subMonitor.newChild(1));
            if (subMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ViewClassInfo[] viewClassInfoArray = arrayList5.toArray(new ViewClassInfo[arrayList5.size()]);
            ViewClassInfo[] viewClassInfoArray2 = arrayList6.toArray(new ViewClassInfo[arrayList6.size()]);
            arrayList5.clear();
            arrayList6.clear();
            this.collectPreferenceClasses(androidJarLoader, attrsXmlParser, arrayList5, arrayList6, (IProgressMonitor)subMonitor.newChild(1));
            if (subMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ViewClassInfo[] viewClassInfoArray3 = arrayList5.toArray(new ViewClassInfo[arrayList5.size()]);
            ViewClassInfo[] viewClassInfoArray4 = arrayList6.toArray(new ViewClassInfo[arrayList6.size()]);
            Map<String, DeclareStyleableInfo> map = this.collectMenuDefinitions(attrsXmlParser);
            Map<String, DeclareStyleableInfo> map2 = this.collectSearchableDefinitions(attrsXmlParser);
            Map<String, DeclareStyleableInfo> map3 = this.collectManifestDefinitions(attrsXmlParser2);
            Map<String, Map<String, Integer>> map4 = attrsXmlParser.getEnumFlagValues();
            Map<String, DeclareStyleableInfo> map5 = null;
            if (this.mAndroidTarget.getVersion().getApiLevel() >= 3) {
                map5 = this.collectAppWidgetDefinitions(attrsXmlParser);
            }
            if (subMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            AndroidManifestDescriptors androidManifestDescriptors = new AndroidManifestDescriptors();
            androidManifestDescriptors.updateDescriptors(map3);
            subMonitor.worked(1);
            if (subMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            LayoutDescriptors layoutDescriptors = new LayoutDescriptors();
            layoutDescriptors.updateDescriptors(viewClassInfoArray, viewClassInfoArray2);
            subMonitor.worked(1);
            if (subMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            MenuDescriptors menuDescriptors = new MenuDescriptors();
            menuDescriptors.updateDescriptors(map);
            subMonitor.worked(1);
            if (subMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            XmlDescriptors xmlDescriptors = new XmlDescriptors();
            xmlDescriptors.updateDescriptors(map2, map5, viewClassInfoArray3, viewClassInfoArray4);
            subMonitor.worked(1);
            ProjectResources projectResources = ResourceManager.getInstance().loadFrameworkResources(this.mAndroidTarget);
            subMonitor.worked(1);
            AndroidTargetData.LayoutBridge layoutBridge = this.loadLayoutBridge();
            subMonitor.worked(1);
            androidTargetData.setExtraData(iResourceRepository, androidManifestDescriptors, layoutDescriptors, menuDescriptors, xmlDescriptors, map4, stringArray, arrayList.toArray(new String[arrayList.size()]), arrayList2.toArray(new String[arrayList2.size()]), arrayList3.toArray(new String[arrayList3.size()]), arrayList4.toArray(new String[arrayList4.size()]), this.mAndroidTarget.getPlatformLibraries(), this.mAndroidTarget.getOptionalLibraries(), projectResources, layoutBridge);
            Sdk.getCurrent().setTargetData(this.mAndroidTarget, androidTargetData);
            return Status.OK_STATUS;
        }
        catch (Exception exception) {
            AdtPlugin.logAndPrintError(exception, TAG, "SDK parser failed", new Object[0]);
            AdtPlugin.printToConsole("SDK parser failed", exception.getMessage());
            return new Status(4, "com.android.ide.eclipse.adt", "SDK parser failed", (Throwable)exception);
        }
    }

    private void preload(AndroidJarLoader androidJarLoader, IProgressMonitor iProgressMonitor) {
        try {
            androidJarLoader.preLoadClasses("", this.mAndroidTarget.getName(), iProgressMonitor);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            AdtPlugin.log(invalidAttributeValueException, "Problem preloading classes", new Object[0]);
        }
        catch (IOException iOException) {
            AdtPlugin.log(iOException, "Problem preloading classes", new Object[0]);
        }
    }

    private IResourceRepository collectResourceIds(AndroidJarLoader androidJarLoader) {
        try {
            Map<ResourceType, List<ResourceItem>> map;
            Class<?> clazz = androidJarLoader.loadClass("android.R");
            if (clazz != null && (map = this.parseRClass(clazz)) != null) {
                return new FrameworkResourceRepository(map);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            AdtPlugin.logAndPrintError(classNotFoundException, TAG, "Collect resource IDs failed, class %1$s not found in %2$s", "android.R", this.mAndroidTarget.getPath(1));
        }
        return null;
    }

    private Map<ResourceType, List<ResourceItem>> parseRClass(Class<?> clazz) {
        Class<?>[] classArray = clazz.getClasses();
        if (classArray.length > 0) {
            HashMap<ResourceType, List<ResourceItem>> hashMap = new HashMap<ResourceType, List<ResourceItem>>();
            int n = 0;
            while (n < classArray.length) {
                Class<?> clazz2 = classArray[n];
                String string = clazz2.getSimpleName();
                ResourceType resourceType = ResourceType.getEnum(string);
                if (resourceType != null) {
                    Field[] fieldArray;
                    ArrayList<ResourceItem> arrayList = new ArrayList<ResourceItem>();
                    hashMap.put(resourceType, arrayList);
                    Field[] fieldArray2 = fieldArray = clazz2.getFields();
                    int n2 = fieldArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        Field field = fieldArray2[n3];
                        arrayList.add(new ResourceItem(field.getName()));
                        ++n3;
                    }
                }
                ++n;
            }
            return hashMap;
        }
        return null;
    }

    private String[] collectPermissions(AndroidJarLoader androidJarLoader) {
        block10: {
            try {
                Field[] fieldArray;
                Class<?> clazz = androidJarLoader.loadClass("android.Manifest$permission");
                if (clazz == null) break block10;
                ArrayList<String> arrayList = new ArrayList<String>();
                Field[] fieldArray2 = fieldArray = clazz.getFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray2[n2];
                    int n3 = field.getModifiers();
                    if (Modifier.isStatic(n3) && Modifier.isFinal(n3) && Modifier.isPublic(n3)) {
                        try {
                            Object object = field.get(null);
                            if (object instanceof String) {
                                arrayList.add((String)object);
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {
                        }
                        catch (NullPointerException nullPointerException) {
                        }
                        catch (ExceptionInInitializerError exceptionInInitializerError) {}
                    }
                    ++n2;
                }
                return arrayList.toArray(new String[arrayList.size()]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                AdtPlugin.logAndPrintError(classNotFoundException, TAG, "Collect permissions failed, class %1$s not found in %2$s", "android.Manifest$permission", this.mAndroidTarget.getPath(1));
            }
        }
        return new String[0];
    }

    private void collectIntentFilterActionsAndCategories(ArrayList<String> arrayList, ArrayList<String> arrayList2, ArrayList<String> arrayList3, ArrayList<String> arrayList4) {
        this.collectValues(this.mAndroidTarget.getPath(14), arrayList);
        this.collectValues(this.mAndroidTarget.getPath(15), arrayList2);
        this.collectValues(this.mAndroidTarget.getPath(16), arrayList3);
        this.collectValues(this.mAndroidTarget.getPath(17), arrayList4);
    }

    private void collectValues(String string, ArrayList<String> arrayList) {
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                String string2;
                fileReader = new FileReader(string);
                bufferedReader = new BufferedReader(fileReader);
                while ((string2 = bufferedReader.readLine()) != null) {
                    if ((string2 = string2.trim()).length() <= 0 || string2.startsWith("#")) continue;
                    arrayList.add(string2);
                }
            }
            catch (IOException iOException) {
                AdtPlugin.log(iOException, "Failed to read SDK values", new Object[0]);
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException2) {
                    AdtPlugin.log(iOException2, "Failed to read SDK values", new Object[0]);
                }
                try {
                    if (fileReader != null) {
                        fileReader.close();
                    }
                }
                catch (IOException iOException3) {
                    AdtPlugin.log(iOException3, "Failed to read SDK values", new Object[0]);
                }
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                AdtPlugin.log(iOException, "Failed to read SDK values", new Object[0]);
            }
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (IOException iOException) {
                AdtPlugin.log(iOException, "Failed to read SDK values", new Object[0]);
            }
        }
    }

    private void collectLayoutClasses(AndroidJarLoader androidJarLoader, AttrsXmlParser attrsXmlParser, Collection<ViewClassInfo> collection, Collection<ViewClassInfo> collection2, IProgressMonitor iProgressMonitor) {
        Object object;
        LayoutParamsParser layoutParamsParser = null;
        try {
            object = new WidgetClassLoader(this.mAndroidTarget.getPath(13));
            if (((WidgetClassLoader)object).parseWidgetList(iProgressMonitor)) {
                layoutParamsParser = new LayoutParamsParser((IAndroidClassLoader)object, attrsXmlParser);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            AdtPlugin.log(fileNotFoundException, "Android Framework Parser", new Object[0]);
        }
        if (layoutParamsParser == null) {
            layoutParamsParser = new LayoutParamsParser(androidJarLoader, attrsXmlParser);
        }
        layoutParamsParser.parseLayoutClasses(iProgressMonitor);
        object = layoutParamsParser.getViews();
        List<ViewClassInfo> list = layoutParamsParser.getGroups();
        if (object != null && list != null) {
            collection.addAll((Collection<ViewClassInfo>)object);
            collection2.addAll(list);
        }
    }

    private void collectPreferenceClasses(AndroidJarLoader androidJarLoader, AttrsXmlParser attrsXmlParser, Collection<ViewClassInfo> collection, Collection<ViewClassInfo> collection2, IProgressMonitor iProgressMonitor) {
        LayoutParamsParser layoutParamsParser = new LayoutParamsParser(androidJarLoader, attrsXmlParser);
        try {
            layoutParamsParser.parsePreferencesClasses(iProgressMonitor);
            List<ViewClassInfo> list = layoutParamsParser.getViews();
            List<ViewClassInfo> list2 = layoutParamsParser.getGroups();
            if (list != null && list2 != null) {
                collection.addAll(list);
                collection2.addAll(list2);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            AdtPlugin.logAndPrintError(noClassDefFoundError, TAG, "Collect preferences failed, class %1$s not found in %2$s", noClassDefFoundError.getMessage(), androidJarLoader.getSource());
        }
        catch (Throwable throwable) {
            AdtPlugin.log(throwable, "Android Framework Parser: failed to collect preference classes", new Object[0]);
            AdtPlugin.printErrorToConsole("Android Framework Parser", "failed to collect preference classes");
        }
    }

    private Map<String, DeclareStyleableInfo> collectMenuDefinitions(AttrsXmlParser attrsXmlParser) {
        Map<String, DeclareStyleableInfo> map = attrsXmlParser.getDeclareStyleableList();
        HashMap<String, DeclareStyleableInfo> hashMap = new HashMap<String, DeclareStyleableInfo>();
        String[] stringArray = new String[]{"Menu", "MenuItem", "MenuGroup"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (map.containsKey(string)) {
                hashMap.put(string, map.get(string));
            } else {
                AdtPlugin.log(2, "Menu declare-styleable %1$s not found in file %2$s", string, attrsXmlParser.getOsAttrsXmlPath());
                AdtPlugin.printErrorToConsole("Android Framework Parser", String.format("Menu declare-styleable %1$s not found in file %2$s", string, attrsXmlParser.getOsAttrsXmlPath()));
            }
            ++n2;
        }
        return Collections.unmodifiableMap(hashMap);
    }

    private Map<String, DeclareStyleableInfo> collectSearchableDefinitions(AttrsXmlParser attrsXmlParser) {
        Map<String, DeclareStyleableInfo> map = attrsXmlParser.getDeclareStyleableList();
        HashMap<String, DeclareStyleableInfo> hashMap = new HashMap<String, DeclareStyleableInfo>();
        String[] stringArray = new String[]{"Searchable", "SearchableActionKey"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (map.containsKey(string)) {
                hashMap.put(string, map.get(string));
            } else {
                AdtPlugin.log(2, "Searchable declare-styleable %1$s not found in file %2$s", string, attrsXmlParser.getOsAttrsXmlPath());
                AdtPlugin.printErrorToConsole("Android Framework Parser", String.format("Searchable declare-styleable %1$s not found in file %2$s", string, attrsXmlParser.getOsAttrsXmlPath()));
            }
            ++n2;
        }
        return Collections.unmodifiableMap(hashMap);
    }

    private Map<String, DeclareStyleableInfo> collectAppWidgetDefinitions(AttrsXmlParser attrsXmlParser) {
        Map<String, DeclareStyleableInfo> map = attrsXmlParser.getDeclareStyleableList();
        HashMap<String, DeclareStyleableInfo> hashMap = new HashMap<String, DeclareStyleableInfo>();
        String[] stringArray = new String[]{"AppWidgetProviderInfo"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (map.containsKey(string)) {
                hashMap.put(string, map.get(string));
            } else {
                AdtPlugin.log(2, "AppWidget declare-styleable %1$s not found in file %2$s", string, attrsXmlParser.getOsAttrsXmlPath());
                AdtPlugin.printErrorToConsole("Android Framework Parser", String.format("AppWidget declare-styleable %1$s not found in file %2$s", string, attrsXmlParser.getOsAttrsXmlPath()));
            }
            ++n2;
        }
        return Collections.unmodifiableMap(hashMap);
    }

    private Map<String, DeclareStyleableInfo> collectManifestDefinitions(AttrsXmlParser attrsXmlParser) {
        return attrsXmlParser.getDeclareStyleableList();
    }

    private AndroidTargetData.LayoutBridge loadLayoutBridge() {
        AndroidTargetData.LayoutBridge layoutBridge;
        block7: {
            layoutBridge = new AndroidTargetData.LayoutBridge();
            try {
                Object obj;
                Constructor<?> constructor;
                File file = new File(this.mAndroidTarget.getPath(10));
                if (!file.isFile()) {
                    AdtPlugin.log(4, "layoutlib.jar is missing!", new Object[0]);
                    break block7;
                }
                URL uRL = file.toURL();
                layoutBridge.classLoader = new URLClassLoader(new URL[]{uRL}, this.getClass().getClassLoader());
                Class<?> clazz = layoutBridge.classLoader.loadClass("com.android.layoutlib.bridge.Bridge");
                if (clazz != null && (constructor = clazz.getConstructor(new Class[0])) != null && (obj = constructor.newInstance(new Object[0])) instanceof ILayoutBridge) {
                    layoutBridge.bridge = (ILayoutBridge)obj;
                }
                if (layoutBridge.bridge == null) {
                    layoutBridge.status = LoadStatus.FAILED;
                    AdtPlugin.log(4, "Failed to load com.android.layoutlib.bridge.Bridge", new Object[0]);
                    break block7;
                }
                try {
                    layoutBridge.apiLevel = layoutBridge.bridge.getApiLevel();
                }
                catch (AbstractMethodError abstractMethodError) {
                    layoutBridge.apiLevel = 1;
                }
                layoutBridge.status = LoadStatus.LOADED;
            }
            catch (Throwable throwable) {
                layoutBridge.status = LoadStatus.FAILED;
                AdtPlugin.log(throwable, "Failed to load the LayoutLib", new Object[0]);
            }
        }
        return layoutBridge;
    }
}

