/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.manager.files;

import com.android.ide.eclipse.adt.internal.resources.manager.files.IAbstractFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;

public class FileWrapper
implements IAbstractFile {
    private File mFile;

    public FileWrapper(File file) throws IOException {
        if (!file.isFile()) {
            throw new IOException("FileWrapper must wrap a File object representing an existing file!");
        }
        this.mFile = file;
    }

    public InputStream getContents() {
        try {
            return new FileInputStream(this.mFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public IFile getIFile() {
        return null;
    }

    public String getOsLocation() {
        return this.mFile.getAbsolutePath();
    }

    public String getName() {
        return this.mFile.getName();
    }

    public boolean equals(Object object) {
        if (object instanceof FileWrapper) {
            return this.mFile.equals(((FileWrapper)object).mFile);
        }
        if (object instanceof File) {
            return this.mFile.equals(object);
        }
        return super.equals(object);
    }

    public int hashCode() {
        return this.mFile.hashCode();
    }
}

