/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.manager;

import com.android.ide.eclipse.adt.internal.resources.IResourceRepository;
import com.android.ide.eclipse.adt.internal.resources.ResourceType;
import com.android.ide.eclipse.adt.internal.resources.configurations.FolderConfiguration;
import com.android.ide.eclipse.adt.internal.resources.configurations.LanguageQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.RegionQualifier;
import com.android.ide.eclipse.adt.internal.resources.manager.FolderTypeRelationship;
import com.android.ide.eclipse.adt.internal.resources.manager.IdResourceItem;
import com.android.ide.eclipse.adt.internal.resources.manager.IntArrayWrapper;
import com.android.ide.eclipse.adt.internal.resources.manager.ProjectResourceItem;
import com.android.ide.eclipse.adt.internal.resources.manager.Resource;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceFile;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceFolder;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceFolderType;
import com.android.ide.eclipse.adt.internal.resources.manager.files.IAbstractFolder;
import com.android.layoutlib.api.IResourceValue;
import com.android.layoutlib.utils.ResourceValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectResources
implements IResourceRepository {
    private final HashMap<ResourceFolderType, List<ResourceFolder>> mFolderMap = new HashMap();
    private final HashMap<ResourceType, List<ProjectResourceItem>> mResourceMap = new HashMap();
    private Map<String, Map<String, Integer>> mResourceValueMap;
    private Map<Integer, String[]> mResIdValueToNameMap;
    private Map<IntArrayWrapper, String> mStyleableValueToNameMap;
    private final ArrayList<IdResourceItem> mIdResourceList = new ArrayList();
    private final boolean mIsFrameworkRepository;
    private final IntArrayWrapper mWrapper = new IntArrayWrapper(null);

    public ProjectResources(boolean bl) {
        this.mIsFrameworkRepository = bl;
    }

    @Override
    public boolean isSystemRepository() {
        return this.mIsFrameworkRepository;
    }

    protected ResourceFolder add(ResourceFolderType resourceFolderType, FolderConfiguration folderConfiguration, IAbstractFolder iAbstractFolder) {
        ResourceFolder resourceFolder3;
        List<ResourceFolder> list = this.mFolderMap.get((Object)resourceFolderType);
        if (list == null) {
            list = new ArrayList<ResourceFolder>();
            ResourceFolder resourceFolder2 = new ResourceFolder(resourceFolderType, folderConfiguration, iAbstractFolder, this.mIsFrameworkRepository);
            list.add(resourceFolder2);
            this.mFolderMap.put(resourceFolderType, list);
            return resourceFolder2;
        }
        for (ResourceFolder resourceFolder3 : list) {
            if (!resourceFolder3.mConfiguration.equals(folderConfiguration)) continue;
            resourceFolder3.mFolder = iAbstractFolder;
            return resourceFolder3;
        }
        resourceFolder3 = new ResourceFolder(resourceFolderType, folderConfiguration, iAbstractFolder, this.mIsFrameworkRepository);
        list.add(resourceFolder3);
        return resourceFolder3;
    }

    protected void removeFolder(ResourceFolderType resourceFolderType, IFolder iFolder) {
        List<ResourceFolder> list = this.mFolderMap.get((Object)resourceFolderType);
        if (list != null) {
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                ResourceFolder resourceFolder = list.get(n2);
                if (resourceFolder.getFolder().getIFolder().equals((Object)iFolder)) {
                    ResourceType[] resourceTypeArray;
                    list.remove(n2);
                    if (list.size() > 0) {
                        list.get(0).touch();
                        break;
                    }
                    ResourceType[] resourceTypeArray2 = resourceTypeArray = FolderTypeRelationship.getRelatedResourceTypes(resourceFolderType);
                    int n3 = resourceTypeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ResourceFolderType[] resourceFolderTypeArray;
                        ResourceType resourceType = resourceTypeArray2[n4];
                        ResourceFolderType[] resourceFolderTypeArray2 = resourceFolderTypeArray = FolderTypeRelationship.getRelatedFolders(resourceType);
                        int n5 = resourceFolderTypeArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            ResourceFolderType resourceFolderType2 = resourceFolderTypeArray2[n6];
                            List<ResourceFolder> list2 = this.mFolderMap.get((Object)resourceFolderType2);
                            if (list2 != null && list2.size() > 0) {
                                list2.get(0).touch();
                                break;
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                    break;
                }
                ++n2;
            }
        }
    }

    public List<ResourceFolder> getFolders(ResourceFolderType resourceFolderType) {
        return this.mFolderMap.get((Object)resourceFolderType);
    }

    @Override
    public ResourceType[] getAvailableResourceTypes() {
        Object object2;
        ArrayList<ResourceType> arrayList = new ArrayList<ResourceType>();
        for (Object object2 : this.mFolderMap.keySet()) {
            ResourceType[] resourceTypeArray = FolderTypeRelationship.getRelatedResourceTypes(object2);
            if (resourceTypeArray.length == 1) {
                if (arrayList.indexOf((Object)resourceTypeArray[0]) != -1) continue;
                arrayList.add(resourceTypeArray[0]);
                continue;
            }
            List<ResourceFolder> list = this.mFolderMap.get(object2);
            if (list == null) continue;
            for (ResourceFolder resourceFolder : list) {
                Collection<ResourceType> collection = resourceFolder.getResourceTypes();
                for (ResourceType resourceType : collection) {
                    if (arrayList.indexOf((Object)resourceType) != -1) continue;
                    arrayList.add(resourceType);
                }
            }
        }
        if (arrayList.indexOf((Object)ResourceType.ID) == -1 && this.mResourceValueMap != null && (object2 = this.mResourceValueMap.get(ResourceType.ID.getName())) != null && object2.size() > 0) {
            arrayList.add(ResourceType.ID);
        }
        Collections.sort(arrayList);
        return arrayList.toArray(new ResourceType[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectResourceItem[] getResources(ResourceType resourceType) {
        this.checkAndUpdate(resourceType);
        if (resourceType == ResourceType.ID) {
            ArrayList<IdResourceItem> arrayList = this.mIdResourceList;
            synchronized (arrayList) {
                return this.mIdResourceList.toArray(new ProjectResourceItem[this.mIdResourceList.size()]);
            }
        }
        List<ProjectResourceItem> list = this.mResourceMap.get((Object)resourceType);
        return list.toArray(new ProjectResourceItem[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasResources(ResourceType resourceType) {
        this.checkAndUpdate(resourceType);
        if (resourceType == ResourceType.ID) {
            ArrayList<IdResourceItem> arrayList = this.mIdResourceList;
            synchronized (arrayList) {
                return this.mIdResourceList.size() > 0;
            }
        }
        List<ProjectResourceItem> list = this.mResourceMap.get((Object)resourceType);
        return list != null && list.size() > 0;
    }

    public ResourceFolder getResourceFolder(IFolder iFolder) {
        for (List<ResourceFolder> list : this.mFolderMap.values()) {
            for (ResourceFolder resourceFolder : list) {
                if (!resourceFolder.getFolder().getIFolder().equals((Object)iFolder)) continue;
                return resourceFolder;
            }
        }
        return null;
    }

    public ResourceFile getMatchingFile(String string, ResourceFolderType resourceFolderType, FolderConfiguration folderConfiguration) {
        List<ResourceFolder> list = this.mFolderMap.get((Object)resourceFolderType);
        ArrayList<ResourceFolder> arrayList = new ArrayList<ResourceFolder>();
        int n = 0;
        while (n < list.size()) {
            ResourceFolder resourceFolder = list.get(n);
            if (resourceFolder.hasFile(string)) {
                arrayList.add(resourceFolder);
            }
            ++n;
        }
        Resource resource = this.findMatchingConfiguredResource(arrayList, folderConfiguration);
        if (resource instanceof ResourceFolder) {
            return ((ResourceFolder)resource).getFile(string);
        }
        return null;
    }

    public Map<String, Map<String, IResourceValue>> getConfiguredResources(FolderConfiguration folderConfiguration) {
        Object object2;
        Object object3;
        HashMap<String, Map<String, IResourceValue>> hashMap = new HashMap<String, Map<String, IResourceValue>>();
        if (this.mIdResourceList.size() > 0) {
            object3 = new HashMap();
            object2 = ResourceType.ID.getName();
            for (IdResourceItem object4 : this.mIdResourceList) {
                object3.put(object4.getName(), new ResourceValue(object2, object4.getName(), this.mIsFrameworkRepository));
            }
            hashMap.put(ResourceType.ID.getName(), (Map<String, IResourceValue>)object3);
        }
        object3 = this.mResourceMap.keySet();
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            object2 = (ResourceType)((Object)iterator.next());
            if (object2 == ResourceType.ID) continue;
            hashMap.put(((ResourceType)((Object)object2)).getName(), this.getConfiguredResource((ResourceType)((Object)object2), folderConfiguration));
        }
        return hashMap;
    }

    public void loadAll() {
        ResourceType[] resourceTypeArray;
        ResourceType[] resourceTypeArray2 = resourceTypeArray = this.getAvailableResourceTypes();
        int n = resourceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceType resourceType = resourceTypeArray2[n2];
            this.checkAndUpdate(resourceType);
            ++n2;
        }
    }

    public String[] resolveResourceValue(int n) {
        if (this.mResIdValueToNameMap != null) {
            return this.mResIdValueToNameMap.get(n);
        }
        return null;
    }

    public String resolveResourceValue(int[] nArray) {
        if (this.mStyleableValueToNameMap != null) {
            this.mWrapper.set(nArray);
            return this.mStyleableValueToNameMap.get(this.mWrapper);
        }
        return null;
    }

    public Integer getResourceValue(String string, String string2) {
        Map<String, Integer> map;
        if (this.mResourceValueMap != null && (map = this.mResourceValueMap.get(string)) != null) {
            return map.get(string2);
        }
        return null;
    }

    public Set<String> getLanguages() {
        HashSet<String> hashSet = new HashSet<String>();
        Collection<List<ResourceFolder>> collection = this.mFolderMap.values();
        for (List<ResourceFolder> list : collection) {
            for (ResourceFolder resourceFolder : list) {
                FolderConfiguration folderConfiguration = resourceFolder.getConfiguration();
                LanguageQualifier languageQualifier = folderConfiguration.getLanguageQualifier();
                if (languageQualifier == null) continue;
                hashSet.add(languageQualifier.getStringValue());
            }
        }
        return hashSet;
    }

    public Set<String> getRegions(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        Collection<List<ResourceFolder>> collection = this.mFolderMap.values();
        for (List<ResourceFolder> list : collection) {
            for (ResourceFolder resourceFolder : list) {
                RegionQualifier regionQualifier;
                FolderConfiguration folderConfiguration = resourceFolder.getConfiguration();
                LanguageQualifier languageQualifier = folderConfiguration.getLanguageQualifier();
                if (languageQualifier == null || !languageQualifier.getStringValue().equals(string) || (regionQualifier = folderConfiguration.getRegionQualifier()) == null) continue;
                hashSet.add(regionQualifier.getStringValue());
            }
        }
        return hashSet;
    }

    private Map<String, IResourceValue> getConfiguredResource(ResourceType resourceType, FolderConfiguration folderConfiguration) {
        List<ProjectResourceItem> list = this.mResourceMap.get((Object)resourceType);
        HashMap<String, IResourceValue> hashMap = new HashMap<String, IResourceValue>();
        for (ProjectResourceItem projectResourceItem : list) {
            ResourceFile resourceFile;
            IResourceValue iResourceValue;
            List<ResourceFile> list2 = projectResourceItem.getSourceFileList();
            Resource resource = this.findMatchingConfiguredResource(list2, folderConfiguration);
            if (!(resource instanceof ResourceFile) || (iResourceValue = (resourceFile = (ResourceFile)resource).getValue(resourceType, projectResourceItem.getName())) == null) continue;
            hashMap.put(projectResourceItem.getName(), iResourceValue);
        }
        return hashMap;
    }

    private Resource findMatchingConfiguredResource(List<? extends Resource> list, FolderConfiguration folderConfiguration) {
        int n;
        Object object;
        int n2 = -1;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n3 = 0;
        while (n3 < list.size()) {
            object = list.get(n3);
            n = ((Resource)object).getConfiguration().match(folderConfiguration);
            if (n > n2) {
                arrayList.clear();
                arrayList.add(object);
                n2 = n;
            } else if (n != -1 && n == n2) {
                arrayList.add(object);
            }
            ++n3;
        }
        Resource resource = null;
        if (arrayList.size() == 1) {
            resource = (Resource)arrayList.get(0);
        } else if (arrayList.size() > 1) {
            object = new ArrayList();
            n = 0;
            while (arrayList.size() > 1) {
                int n4 = -1;
                int n5 = 0;
                while (n5 < arrayList.size()) {
                    Resource resource2 = (Resource)arrayList.get(n5);
                    int n6 = resource2.getConfiguration().getHighestPriorityQualifier(n);
                    if (n6 != -1) {
                        if (n4 == -1 || n6 == n4) {
                            ((ArrayList)object).add(resource2);
                            n4 = n6;
                        } else if (n6 < n4) {
                            ((ArrayList)object).clear();
                            ((ArrayList)object).add(resource2);
                        }
                    }
                    ++n5;
                }
                n = n4 + 1;
                if (arrayList.size() == ((ArrayList)object).size() && n4 == -1) {
                    arrayList.clear();
                    arrayList.add((Resource)((ArrayList)object).get(0));
                } else {
                    arrayList.clear();
                    arrayList.addAll((Collection<Object>)object);
                }
                ((ArrayList)object).clear();
            }
            resource = (Resource)arrayList.get(0);
        }
        return resource;
    }

    private void checkAndUpdate(ResourceType resourceType) {
        ResourceFolderType[] resourceFolderTypeArray;
        ResourceFolderType[] resourceFolderTypeArray2 = resourceFolderTypeArray = FolderTypeRelationship.getRelatedFolders(resourceType);
        int n = resourceFolderTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceFolderType resourceFolderType = resourceFolderTypeArray2[n2];
            List<ResourceFolder> list = this.mFolderMap.get((Object)resourceFolderType);
            if (list != null) {
                for (ResourceFolder resourceFolder : list) {
                    ResourceType[] resourceTypeArray;
                    if (!resourceFolder.isTouched()) continue;
                    ResourceType[] resourceTypeArray2 = resourceTypeArray = FolderTypeRelationship.getRelatedResourceTypes(resourceFolderType);
                    int n3 = resourceTypeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ResourceType resourceType2 = resourceTypeArray2[n4];
                        this.update(resourceType2);
                        ++n4;
                    }
                    return;
                }
            }
            ++n2;
        }
    }

    private void update(ResourceType resourceType) {
        ResourceFolderType[] resourceFolderTypeArray;
        List<ProjectResourceItem> list = this.mResourceMap.get((Object)resourceType);
        ArrayList<ProjectResourceItem> arrayList = new ArrayList<ProjectResourceItem>();
        if (list == null) {
            list = new ArrayList<ProjectResourceItem>();
            this.mResourceMap.put(resourceType, list);
        } else {
            arrayList.addAll(list);
            list.clear();
        }
        Object object = resourceFolderTypeArray = FolderTypeRelationship.getRelatedFolders(resourceType);
        int n = resourceFolderTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceFolderType resourceFolderType = object[n2];
            List<ResourceFolder> object2 = this.mFolderMap.get((Object)resourceFolderType);
            if (object2 != null) {
                for (Object object3 : object2) {
                    list.addAll(((ResourceFolder)object3).getResources(resourceType, this));
                    ((Resource)object3).resetTouch();
                }
            }
            ++n2;
        }
        if (arrayList.size() > 0) {
            int n3 = list.size();
            n2 = 0;
            while (n2 < n3) {
                ProjectResourceItem projectResourceItem = list.get(n2);
                object = null;
                for (ProjectResourceItem projectResourceItem2 : arrayList) {
                    if (!projectResourceItem2.getName().equals(projectResourceItem.getName())) continue;
                    object = projectResourceItem2;
                    break;
                }
                if (object != null) {
                    object.replaceWith(projectResourceItem);
                    list.remove(n2);
                    arrayList.remove(object);
                    list.add((ProjectResourceItem)object);
                    continue;
                }
                ++n2;
            }
        }
        if (resourceType == ResourceType.ID) {
            this.mergeIdResources();
        } else {
            Collections.sort(list);
        }
    }

    protected ProjectResourceItem findResourceItem(ResourceType resourceType, String string) {
        List<ProjectResourceItem> list = this.mResourceMap.get((Object)resourceType);
        for (ProjectResourceItem projectResourceItem : list) {
            if (!string.equals(projectResourceItem.getName())) continue;
            return projectResourceItem;
        }
        return null;
    }

    void setCompiledResources(Map<Integer, String[]> map, Map<IntArrayWrapper, String> map2, Map<String, Map<String, Integer>> map3) {
        this.mResourceValueMap = map3;
        this.mResIdValueToNameMap = map;
        this.mStyleableValueToNameMap = map2;
        this.mergeIdResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeIdResources() {
        List<ProjectResourceItem> list = this.mResourceMap.get((Object)ResourceType.ID);
        ArrayList<IdResourceItem> arrayList = this.mIdResourceList;
        synchronized (arrayList) {
            ArrayList<IdResourceItem> arrayList2 = new ArrayList<IdResourceItem>();
            arrayList2.addAll(this.mIdResourceList);
            this.mIdResourceList.clear();
            Map<String, Integer> map = null;
            if (this.mResourceValueMap != null) {
                map = this.mResourceValueMap.get(ResourceType.ID.getName());
            }
            if (map == null) {
                if (list != null) {
                    for (ProjectResourceItem projectResourceItem : list) {
                        if (!(projectResourceItem instanceof IdResourceItem)) continue;
                        this.mIdResourceList.add((IdResourceItem)projectResourceItem);
                    }
                }
            } else {
                Set set = map.keySet();
                block4: for (String string : set) {
                    if (list != null) {
                        for (ProjectResourceItem projectResourceItem : list) {
                            if (!(projectResourceItem instanceof IdResourceItem) || !projectResourceItem.getName().equals(string)) continue;
                            this.mIdResourceList.add((IdResourceItem)projectResourceItem);
                            continue block4;
                        }
                    }
                    int n = arrayList2.size();
                    int n2 = 0;
                    while (n2 < n) {
                        IdResourceItem idResourceItem = (IdResourceItem)arrayList2.get(n2);
                        if (idResourceItem.getName().equals(string)) {
                            arrayList2.remove(n2);
                            this.mIdResourceList.add(idResourceItem);
                            continue block4;
                        }
                        ++n2;
                    }
                    this.mIdResourceList.add(new IdResourceItem(string, true));
                }
            }
            Collections.sort(this.mIdResourceList);
        }
    }
}

