/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.manager;

import com.android.ide.eclipse.adt.internal.resources.ResourceType;
import com.android.ide.eclipse.adt.internal.resources.manager.ConfigurableResourceItem;
import com.android.ide.eclipse.adt.internal.resources.manager.IdResourceItem;
import com.android.ide.eclipse.adt.internal.resources.manager.ProjectResourceItem;
import com.android.ide.eclipse.adt.internal.resources.manager.ProjectResources;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceFile;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceFolder;
import com.android.ide.eclipse.adt.internal.resources.manager.files.IAbstractFile;
import com.android.layoutlib.api.IResourceValue;
import com.android.layoutlib.utils.ResourceValue;
import com.android.layoutlib.utils.ValueResourceParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultiResourceFile
extends ResourceFile
implements ValueResourceParser.IValueResourceRepository {
    private static final SAXParserFactory sParserFactory = SAXParserFactory.newInstance();
    private final HashMap<ResourceType, HashMap<String, ResourceValue>> mResourceItems = new HashMap();

    public MultiResourceFile(IAbstractFile iAbstractFile, ResourceFolder resourceFolder) {
        super(iAbstractFile, resourceFolder);
    }

    @Override
    public ResourceType[] getResourceTypes() {
        this.update();
        Set<ResourceType> set = this.mResourceItems.keySet();
        return set.toArray(new ResourceType[set.size()]);
    }

    @Override
    public boolean hasResources(ResourceType resourceType) {
        this.update();
        HashMap<String, ResourceValue> hashMap = this.mResourceItems.get((Object)resourceType);
        return hashMap != null && hashMap.size() > 0;
    }

    @Override
    public Collection<ProjectResourceItem> getResources(ResourceType resourceType, ProjectResources projectResources) {
        this.update();
        HashMap<String, ResourceValue> hashMap = this.mResourceItems.get((Object)resourceType);
        ArrayList<ProjectResourceItem> arrayList = new ArrayList<ProjectResourceItem>();
        if (hashMap != null) {
            Collection<ResourceValue> collection = hashMap.values();
            for (ResourceValue resourceValue : collection) {
                ProjectResourceItem projectResourceItem = projectResources.findResourceItem(resourceType, resourceValue.getName());
                if (projectResourceItem == null) {
                    projectResourceItem = resourceType == ResourceType.ID ? new IdResourceItem(resourceValue.getName(), false) : new ConfigurableResourceItem(resourceValue.getName());
                    arrayList.add(projectResourceItem);
                }
                projectResourceItem.add(this);
            }
        }
        return arrayList;
    }

    private void update() {
        if (this.isTouched()) {
            this.mResourceItems.clear();
            this.parseFile();
            this.resetTouch();
        }
    }

    private void parseFile() {
        try {
            SAXParser sAXParser = sParserFactory.newSAXParser();
            sAXParser.parse(this.getFile().getContents(), (DefaultHandler)new ValueResourceParser((ValueResourceParser.IValueResourceRepository)this, this.isFramework()));
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {}
    }

    public void addResourceValue(String string, ResourceValue resourceValue) {
        ResourceType resourceType = ResourceType.getEnum(string);
        if (resourceType != null) {
            HashMap<String, Object> hashMap = this.mResourceItems.get((Object)resourceType);
            if (hashMap == null) {
                hashMap = new HashMap();
                this.mResourceItems.put(resourceType, hashMap);
            } else {
                ResourceValue resourceValue2 = hashMap.get(resourceValue.getName());
                if (resourceValue2 != null) {
                    resourceValue2.replaceWith(resourceValue);
                    return;
                }
            }
            hashMap.put(resourceValue.getName(), resourceValue);
        }
    }

    @Override
    public IResourceValue getValue(ResourceType resourceType, String string) {
        this.update();
        HashMap<String, ResourceValue> hashMap = this.mResourceItems.get((Object)resourceType);
        if (hashMap != null) {
            return (IResourceValue)hashMap.get(string);
        }
        return null;
    }
}

