/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.configurations;

import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.resources.configurations.FolderConfiguration;
import com.android.ide.eclipse.adt.internal.resources.configurations.ResourceQualifier;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.Image;

public final class VersionQualifier
extends ResourceQualifier {
    private static final int DEFAULT_VERSION = -1;
    private static final Pattern sCountryCodePattern = Pattern.compile("^v(\\d+)$");
    private int mVersion = -1;
    public static final String NAME = "Platform Version";

    public static VersionQualifier getQualifier(String string) {
        Matcher matcher = sCountryCodePattern.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            int n = -1;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            VersionQualifier versionQualifier = new VersionQualifier();
            versionQualifier.mVersion = n;
            return versionQualifier;
        }
        return null;
    }

    public static String getFolderSegment(int n) {
        if (n != -1) {
            return String.format("v%1$d", n);
        }
        return "";
    }

    public int getVersion() {
        return this.mVersion;
    }

    public String getName() {
        return NAME;
    }

    public String getShortName() {
        return "Version";
    }

    public Image getIcon() {
        return IconFactory.getInstance().getIcon("version");
    }

    public boolean isValid() {
        return this.mVersion != -1;
    }

    public boolean checkAndSet(String string, FolderConfiguration folderConfiguration) {
        VersionQualifier versionQualifier = VersionQualifier.getQualifier(string);
        if (versionQualifier != null) {
            folderConfiguration.setVersionQualifier(versionQualifier);
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof VersionQualifier) {
            return this.mVersion == ((VersionQualifier)object).mVersion;
        }
        return false;
    }

    public int hashCode() {
        return this.mVersion;
    }

    public String getFolderSegment(IAndroidTarget iAndroidTarget) {
        if (iAndroidTarget == null) {
            return VersionQualifier.getFolderSegment(this.mVersion);
        }
        AndroidVersion androidVersion = iAndroidTarget.getVersion();
        if (androidVersion.getApiLevel() >= 3) {
            return VersionQualifier.getFolderSegment(this.mVersion);
        }
        return "";
    }

    public String getStringValue() {
        if (this.mVersion != -1) {
            return String.format("API %1$d", this.mVersion);
        }
        return "";
    }
}

