/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.configurations;

import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.resources.configurations.FolderConfiguration;
import com.android.ide.eclipse.adt.internal.resources.configurations.ResourceQualifier;
import com.android.sdklib.IAndroidTarget;
import org.eclipse.swt.graphics.Image;

public final class TouchScreenQualifier
extends ResourceQualifier {
    public static final String NAME = "Touch Screen";
    private TouchScreenType mValue;

    public TouchScreenQualifier() {
    }

    public TouchScreenQualifier(TouchScreenType touchScreenType) {
        this.mValue = touchScreenType;
    }

    public TouchScreenType getValue() {
        return this.mValue;
    }

    public String getName() {
        return NAME;
    }

    public String getShortName() {
        return NAME;
    }

    public Image getIcon() {
        return IconFactory.getInstance().getIcon("touch");
    }

    public boolean isValid() {
        return this.mValue != null;
    }

    public boolean checkAndSet(String string, FolderConfiguration folderConfiguration) {
        TouchScreenType touchScreenType = TouchScreenType.getEnum(string);
        if (touchScreenType != null) {
            TouchScreenQualifier touchScreenQualifier = new TouchScreenQualifier();
            touchScreenQualifier.mValue = touchScreenType;
            folderConfiguration.setTouchTypeQualifier(touchScreenQualifier);
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof TouchScreenQualifier) {
            return this.mValue == ((TouchScreenQualifier)object).mValue;
        }
        return false;
    }

    public int hashCode() {
        if (this.mValue != null) {
            return this.mValue.hashCode();
        }
        return 0;
    }

    public String getFolderSegment(IAndroidTarget iAndroidTarget) {
        if (this.mValue != null) {
            return this.mValue.getValue();
        }
        return "";
    }

    public String getStringValue() {
        if (this.mValue != null) {
            return this.mValue.getDisplayValue();
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TouchScreenType {
        NOTOUCH("notouch", "No Touch"),
        STYLUS("stylus", "Stylus"),
        FINGER("finger", "Finger");

        private String mValue;
        private String mDisplayValue;

        private TouchScreenType(String string2, String string3) {
            this.mValue = string2;
            this.mDisplayValue = string3;
        }

        static TouchScreenType getEnum(String string) {
            TouchScreenType[] touchScreenTypeArray = TouchScreenType.values();
            int n = touchScreenTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TouchScreenType touchScreenType = touchScreenTypeArray[n2];
                if (touchScreenType.mValue.equals(string)) {
                    return touchScreenType;
                }
                ++n2;
            }
            return null;
        }

        public String getValue() {
            return this.mValue;
        }

        public String getDisplayValue() {
            return this.mDisplayValue;
        }

        public static int getIndex(TouchScreenType touchScreenType) {
            int n = 0;
            TouchScreenType[] touchScreenTypeArray = TouchScreenType.values();
            int n2 = touchScreenTypeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                TouchScreenType touchScreenType2 = touchScreenTypeArray[n3];
                if (touchScreenType2 == touchScreenType) {
                    return n;
                }
                ++n;
                ++n3;
            }
            return -1;
        }

        public static TouchScreenType getByIndex(int n) {
            int n2 = 0;
            TouchScreenType[] touchScreenTypeArray = TouchScreenType.values();
            int n3 = touchScreenTypeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                TouchScreenType touchScreenType = touchScreenTypeArray[n4];
                if (n2 == n) {
                    return touchScreenType;
                }
                ++n2;
                ++n4;
            }
            return null;
        }
    }
}

