/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.configurations;

import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.resources.configurations.FolderConfiguration;
import com.android.ide.eclipse.adt.internal.resources.configurations.ResourceQualifier;
import com.android.sdklib.IAndroidTarget;
import org.eclipse.swt.graphics.Image;

public final class ScreenOrientationQualifier
extends ResourceQualifier {
    public static final String NAME = "Screen Orientation";
    private ScreenOrientation mValue = null;

    public ScreenOrientationQualifier() {
    }

    public ScreenOrientationQualifier(ScreenOrientation screenOrientation) {
        this.mValue = screenOrientation;
    }

    public ScreenOrientation getValue() {
        return this.mValue;
    }

    public String getName() {
        return NAME;
    }

    public String getShortName() {
        return "Orientation";
    }

    public Image getIcon() {
        return IconFactory.getInstance().getIcon("orientation");
    }

    public boolean isValid() {
        return this.mValue != null;
    }

    public boolean checkAndSet(String string, FolderConfiguration folderConfiguration) {
        ScreenOrientation screenOrientation = ScreenOrientation.getEnum(string);
        if (screenOrientation != null) {
            ScreenOrientationQualifier screenOrientationQualifier = new ScreenOrientationQualifier(screenOrientation);
            folderConfiguration.setScreenOrientationQualifier(screenOrientationQualifier);
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof ScreenOrientationQualifier) {
            return this.mValue == ((ScreenOrientationQualifier)object).mValue;
        }
        return false;
    }

    public int hashCode() {
        if (this.mValue != null) {
            return this.mValue.hashCode();
        }
        return 0;
    }

    public String getFolderSegment(IAndroidTarget iAndroidTarget) {
        if (this.mValue != null) {
            return this.mValue.getValue();
        }
        return "";
    }

    public String getStringValue() {
        if (this.mValue != null) {
            return this.mValue.getDisplayValue();
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScreenOrientation {
        PORTRAIT("port", "Portrait"),
        LANDSCAPE("land", "Landscape"),
        SQUARE("square", "Square");

        private String mValue;
        private String mDisplayValue;

        private ScreenOrientation(String string2, String string3) {
            this.mValue = string2;
            this.mDisplayValue = string3;
        }

        static ScreenOrientation getEnum(String string) {
            ScreenOrientation[] screenOrientationArray = ScreenOrientation.values();
            int n = screenOrientationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ScreenOrientation screenOrientation = screenOrientationArray[n2];
                if (screenOrientation.mValue.equals(string)) {
                    return screenOrientation;
                }
                ++n2;
            }
            return null;
        }

        public String getValue() {
            return this.mValue;
        }

        public String getDisplayValue() {
            return this.mDisplayValue;
        }

        public static int getIndex(ScreenOrientation screenOrientation) {
            int n = 0;
            ScreenOrientation[] screenOrientationArray = ScreenOrientation.values();
            int n2 = screenOrientationArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ScreenOrientation screenOrientation2 = screenOrientationArray[n3];
                if (screenOrientation2 == screenOrientation) {
                    return n;
                }
                ++n;
                ++n3;
            }
            return -1;
        }

        public static ScreenOrientation getByIndex(int n) {
            int n2 = 0;
            ScreenOrientation[] screenOrientationArray = ScreenOrientation.values();
            int n3 = screenOrientationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ScreenOrientation screenOrientation = screenOrientationArray[n4];
                if (n2 == n) {
                    return screenOrientation;
                }
                ++n2;
                ++n4;
            }
            return null;
        }
    }
}

