/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.configurations;

import com.android.ide.eclipse.adt.internal.resources.configurations.CountryCodeQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.KeyboardStateQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.LanguageQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.NavigationMethodQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.NetworkCodeQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.PixelDensityQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.RegionQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.ResourceQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.ScreenDimensionQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.ScreenOrientationQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.ScreenRatioQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.ScreenSizeQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.TextInputMethodQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.TouchScreenQualifier;
import com.android.ide.eclipse.adt.internal.resources.configurations.VersionQualifier;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceFolderType;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.sdklib.IAndroidTarget;
import org.eclipse.core.resources.IProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FolderConfiguration
implements Comparable<FolderConfiguration> {
    public static final String QUALIFIER_SEP = "-";
    private final ResourceQualifier[] mQualifiers = new ResourceQualifier[14];
    private static final int INDEX_COUNTRY_CODE = 0;
    private static final int INDEX_NETWORK_CODE = 1;
    private static final int INDEX_LANGUAGE = 2;
    private static final int INDEX_REGION = 3;
    private static final int INDEX_SCREEN_SIZE = 4;
    private static final int INDEX_SCREEN_RATIO = 5;
    private static final int INDEX_SCREEN_ORIENTATION = 6;
    private static final int INDEX_PIXEL_DENSITY = 7;
    private static final int INDEX_TOUCH_TYPE = 8;
    private static final int INDEX_KEYBOARD_STATE = 9;
    private static final int INDEX_TEXT_INPUT_METHOD = 10;
    private static final int INDEX_NAVIGATION_METHOD = 11;
    private static final int INDEX_SCREEN_DIMENSION = 12;
    private static final int INDEX_VERSION = 13;
    private static final int INDEX_COUNT = 14;

    public void set(FolderConfiguration folderConfiguration) {
        int n = 0;
        while (n < 14) {
            this.mQualifiers[n] = folderConfiguration.mQualifiers[n];
            ++n;
        }
    }

    public void substract(FolderConfiguration folderConfiguration) {
        int n = 0;
        while (n < 14) {
            if (folderConfiguration.mQualifiers[n] != null && folderConfiguration.mQualifiers[n].isValid()) {
                this.mQualifiers[n] = null;
            }
            ++n;
        }
    }

    public ResourceQualifier getInvalidQualifier() {
        int n = 0;
        while (n < 14) {
            if (this.mQualifiers[n] != null && !this.mQualifiers[n].isValid()) {
                return this.mQualifiers[n];
            }
            ++n;
        }
        return null;
    }

    public boolean checkRegion() {
        return this.mQualifiers[2] != null || this.mQualifiers[3] == null;
    }

    public void addQualifier(ResourceQualifier resourceQualifier) {
        if (resourceQualifier instanceof CountryCodeQualifier) {
            this.mQualifiers[0] = resourceQualifier;
        } else if (resourceQualifier instanceof NetworkCodeQualifier) {
            this.mQualifiers[1] = resourceQualifier;
        } else if (resourceQualifier instanceof LanguageQualifier) {
            this.mQualifiers[2] = resourceQualifier;
        } else if (resourceQualifier instanceof RegionQualifier) {
            this.mQualifiers[3] = resourceQualifier;
        } else if (resourceQualifier instanceof ScreenSizeQualifier) {
            this.mQualifiers[4] = resourceQualifier;
        } else if (resourceQualifier instanceof ScreenRatioQualifier) {
            this.mQualifiers[5] = resourceQualifier;
        } else if (resourceQualifier instanceof ScreenOrientationQualifier) {
            this.mQualifiers[6] = resourceQualifier;
        } else if (resourceQualifier instanceof PixelDensityQualifier) {
            this.mQualifiers[7] = resourceQualifier;
        } else if (resourceQualifier instanceof TouchScreenQualifier) {
            this.mQualifiers[8] = resourceQualifier;
        } else if (resourceQualifier instanceof KeyboardStateQualifier) {
            this.mQualifiers[9] = resourceQualifier;
        } else if (resourceQualifier instanceof TextInputMethodQualifier) {
            this.mQualifiers[10] = resourceQualifier;
        } else if (resourceQualifier instanceof NavigationMethodQualifier) {
            this.mQualifiers[11] = resourceQualifier;
        } else if (resourceQualifier instanceof ScreenDimensionQualifier) {
            this.mQualifiers[12] = resourceQualifier;
        } else if (resourceQualifier instanceof VersionQualifier) {
            this.mQualifiers[13] = resourceQualifier;
        }
    }

    public void removeQualifier(ResourceQualifier resourceQualifier) {
        int n = 0;
        while (n < 14) {
            if (this.mQualifiers[n] == resourceQualifier) {
                this.mQualifiers[n] = null;
                return;
            }
            ++n;
        }
    }

    public void setCountryCodeQualifier(CountryCodeQualifier countryCodeQualifier) {
        this.mQualifiers[0] = countryCodeQualifier;
    }

    public CountryCodeQualifier getCountryCodeQualifier() {
        return (CountryCodeQualifier)this.mQualifiers[0];
    }

    public void setNetworkCodeQualifier(NetworkCodeQualifier networkCodeQualifier) {
        this.mQualifiers[1] = networkCodeQualifier;
    }

    public NetworkCodeQualifier getNetworkCodeQualifier() {
        return (NetworkCodeQualifier)this.mQualifiers[1];
    }

    public void setLanguageQualifier(LanguageQualifier languageQualifier) {
        this.mQualifiers[2] = languageQualifier;
    }

    public LanguageQualifier getLanguageQualifier() {
        return (LanguageQualifier)this.mQualifiers[2];
    }

    public void setRegionQualifier(RegionQualifier regionQualifier) {
        this.mQualifiers[3] = regionQualifier;
    }

    public RegionQualifier getRegionQualifier() {
        return (RegionQualifier)this.mQualifiers[3];
    }

    public void setScreenSizeQualifier(ScreenSizeQualifier screenSizeQualifier) {
        this.mQualifiers[4] = screenSizeQualifier;
    }

    public ScreenSizeQualifier getScreenSizeQualifier() {
        return (ScreenSizeQualifier)this.mQualifiers[4];
    }

    public void setScreenRatioQualifier(ScreenRatioQualifier screenRatioQualifier) {
        this.mQualifiers[5] = screenRatioQualifier;
    }

    public ScreenRatioQualifier getScreenRatioQualifier() {
        return (ScreenRatioQualifier)this.mQualifiers[5];
    }

    public void setScreenOrientationQualifier(ScreenOrientationQualifier screenOrientationQualifier) {
        this.mQualifiers[6] = screenOrientationQualifier;
    }

    public ScreenOrientationQualifier getScreenOrientationQualifier() {
        return (ScreenOrientationQualifier)this.mQualifiers[6];
    }

    public void setPixelDensityQualifier(PixelDensityQualifier pixelDensityQualifier) {
        this.mQualifiers[7] = pixelDensityQualifier;
    }

    public PixelDensityQualifier getPixelDensityQualifier() {
        return (PixelDensityQualifier)this.mQualifiers[7];
    }

    public void setTouchTypeQualifier(TouchScreenQualifier touchScreenQualifier) {
        this.mQualifiers[8] = touchScreenQualifier;
    }

    public TouchScreenQualifier getTouchTypeQualifier() {
        return (TouchScreenQualifier)this.mQualifiers[8];
    }

    public void setKeyboardStateQualifier(KeyboardStateQualifier keyboardStateQualifier) {
        this.mQualifiers[9] = keyboardStateQualifier;
    }

    public KeyboardStateQualifier getKeyboardStateQualifier() {
        return (KeyboardStateQualifier)this.mQualifiers[9];
    }

    public void setTextInputMethodQualifier(TextInputMethodQualifier textInputMethodQualifier) {
        this.mQualifiers[10] = textInputMethodQualifier;
    }

    public TextInputMethodQualifier getTextInputMethodQualifier() {
        return (TextInputMethodQualifier)this.mQualifiers[10];
    }

    public void setNavigationMethodQualifier(NavigationMethodQualifier navigationMethodQualifier) {
        this.mQualifiers[11] = navigationMethodQualifier;
    }

    public NavigationMethodQualifier getNavigationMethodQualifier() {
        return (NavigationMethodQualifier)this.mQualifiers[11];
    }

    public void setScreenDimensionQualifier(ScreenDimensionQualifier screenDimensionQualifier) {
        this.mQualifiers[12] = screenDimensionQualifier;
    }

    public ScreenDimensionQualifier getScreenDimensionQualifier() {
        return (ScreenDimensionQualifier)this.mQualifiers[12];
    }

    public void setVersionQualifier(VersionQualifier versionQualifier) {
        this.mQualifiers[13] = versionQualifier;
    }

    public VersionQualifier getVersionQualifier() {
        return (VersionQualifier)this.mQualifiers[13];
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FolderConfiguration) {
            FolderConfiguration folderConfiguration = (FolderConfiguration)object;
            int n = 0;
            while (n < 14) {
                ResourceQualifier resourceQualifier = this.mQualifiers[n];
                ResourceQualifier resourceQualifier2 = folderConfiguration.mQualifiers[n];
                if (resourceQualifier != null ? !resourceQualifier.equals(resourceQualifier2) : resourceQualifier2 != null) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isDefault() {
        ResourceQualifier[] resourceQualifierArray = this.mQualifiers;
        int n = this.mQualifiers.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceQualifier resourceQualifier = resourceQualifierArray[n2];
            if (resourceQualifier != null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String getFolderName(ResourceFolderType resourceFolderType, IAndroidTarget iAndroidTarget) {
        StringBuilder stringBuilder = new StringBuilder(resourceFolderType.getName());
        ResourceQualifier[] resourceQualifierArray = this.mQualifiers;
        int n = this.mQualifiers.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceQualifier resourceQualifier = resourceQualifierArray[n2];
            if (resourceQualifier != null) {
                stringBuilder.append(QUALIFIER_SEP);
                stringBuilder.append(resourceQualifier.getFolderSegment(iAndroidTarget));
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    public String getFolderName(ResourceFolderType resourceFolderType, IProject iProject) {
        Sdk sdk;
        IAndroidTarget iAndroidTarget = null;
        if (iProject != null && (sdk = Sdk.getCurrent()) != null) {
            iAndroidTarget = sdk.getTarget(iProject);
        }
        return this.getFolderName(resourceFolderType, iAndroidTarget);
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        if (this.isDefault()) {
            return "default";
        }
        StringBuilder stringBuilder = null;
        int n = 0;
        ResourceQualifier resourceQualifier = null;
        while (n < 2) {
            if ((resourceQualifier = this.mQualifiers[n++]) == null) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(resourceQualifier.getStringValue());
        }
        if (this.mQualifiers[2] != null && this.mQualifiers[3] != null) {
            String string = this.mQualifiers[2].getStringValue();
            String string2 = this.mQualifiers[3].getStringValue();
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(String.format("%s_%s", string, string2));
            n += 2;
        }
        while (n < 14) {
            if ((resourceQualifier = this.mQualifiers[n++]) == null) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(resourceQualifier.getStringValue());
        }
        return stringBuilder == null ? null : stringBuilder.toString();
    }

    @Override
    public int compareTo(FolderConfiguration folderConfiguration) {
        if (this.isDefault()) {
            if (folderConfiguration.isDefault()) {
                return 0;
            }
            return -1;
        }
        int n = 0;
        while (n < 14) {
            ResourceQualifier resourceQualifier = this.mQualifiers[n];
            ResourceQualifier resourceQualifier2 = folderConfiguration.mQualifiers[n];
            if (resourceQualifier == null) {
                if (resourceQualifier2 != null) {
                    return -1;
                }
            } else {
                if (resourceQualifier2 == null) {
                    return 1;
                }
                int n2 = resourceQualifier.compareTo(resourceQualifier2);
                if (n2 != 0) {
                    return n2;
                }
            }
            ++n;
        }
        return 0;
    }

    public int match(FolderConfiguration folderConfiguration) {
        int n = 0;
        int n2 = 0;
        while (n2 < 14) {
            ResourceQualifier resourceQualifier = this.mQualifiers[n2];
            ResourceQualifier resourceQualifier2 = folderConfiguration.mQualifiers[n2];
            if (resourceQualifier != null) {
                if (resourceQualifier2 == null) {
                    return -1;
                }
                if (!resourceQualifier.equals(resourceQualifier2)) {
                    return -1;
                }
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public int getHighestPriorityQualifier(int n) {
        int n2 = n;
        while (n2 < 14) {
            if (this.mQualifiers[n2] != null) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void createDefault() {
        this.mQualifiers[0] = new CountryCodeQualifier();
        this.mQualifiers[1] = new NetworkCodeQualifier();
        this.mQualifiers[2] = new LanguageQualifier();
        this.mQualifiers[3] = new RegionQualifier();
        this.mQualifiers[4] = new ScreenSizeQualifier();
        this.mQualifiers[5] = new ScreenRatioQualifier();
        this.mQualifiers[6] = new ScreenOrientationQualifier();
        this.mQualifiers[7] = new PixelDensityQualifier();
        this.mQualifiers[8] = new TouchScreenQualifier();
        this.mQualifiers[9] = new KeyboardStateQualifier();
        this.mQualifiers[10] = new TextInputMethodQualifier();
        this.mQualifiers[11] = new NavigationMethodQualifier();
        this.mQualifiers[12] = new ScreenDimensionQualifier();
        this.mQualifiers[13] = new VersionQualifier();
    }

    public ResourceQualifier[] getQualifiers() {
        int n = 0;
        int n2 = 0;
        while (n2 < 14) {
            if (this.mQualifiers[n2] != null) {
                ++n;
            }
            ++n2;
        }
        ResourceQualifier[] resourceQualifierArray = new ResourceQualifier[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < 14) {
            if (this.mQualifiers[n4] != null) {
                resourceQualifierArray[n3++] = this.mQualifiers[n4];
            }
            ++n4;
        }
        return resourceQualifierArray;
    }
}

