/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.project;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.project.XmlErrorHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class AndroidManifestParser {
    private static final int LEVEL_MANIFEST = 0;
    private static final int LEVEL_APPLICATION = 1;
    private static final int LEVEL_ACTIVITY = 2;
    private static final int LEVEL_INTENT_FILTER = 3;
    private static final int LEVEL_CATEGORY = 4;
    private static final String ACTION_MAIN = "android.intent.action.MAIN";
    private static final String CATEGORY_LAUNCHER = "android.intent.category.LAUNCHER";
    private static SAXParserFactory sParserFactory = SAXParserFactory.newInstance();
    private final String mJavaPackage;
    private final Activity[] mActivities;
    private final Activity mLauncherActivity;
    private final String[] mProcesses;
    private final Boolean mDebuggable;
    private final String mApiLevelRequirement;
    private final Instrumentation[] mInstrumentations;
    private final String[] mLibraries;

    static {
        sParserFactory.setNamespaceAware(true);
    }

    public static AndroidManifestParser parse(IJavaProject iJavaProject, IFile iFile, XmlErrorHandler.XmlErrorListener xmlErrorListener, boolean bl, boolean bl2) throws CoreException {
        block5: {
            try {
                if (iFile != null) {
                    SAXParser sAXParser = sParserFactory.newSAXParser();
                    ManifestHandler manifestHandler = new ManifestHandler(iFile, xmlErrorListener, bl, iJavaProject, bl2);
                    sAXParser.parse(new InputSource(iFile.getContents()), (DefaultHandler)manifestHandler);
                    return new AndroidManifestParser(manifestHandler.getPackage(), manifestHandler.getActivities(), manifestHandler.getLauncherActivity(), manifestHandler.getProcesses(), manifestHandler.getDebuggable(), manifestHandler.getApiLevelRequirement(), manifestHandler.getInstrumentations(), manifestHandler.getUsesLibraries());
                }
            }
            catch (ParserConfigurationException parserConfigurationException) {
                AdtPlugin.logAndPrintError(parserConfigurationException, AndroidManifestParser.class.getCanonicalName(), "Bad parser configuration for %s: %s", iFile.getFullPath(), parserConfigurationException.getMessage());
            }
            catch (SAXException sAXException) {
                AdtPlugin.logAndPrintError(sAXException, AndroidManifestParser.class.getCanonicalName(), "Parser exception for %s: %s", iFile.getFullPath(), sAXException.getMessage());
            }
            catch (IOException iOException) {
                if (iOException instanceof FileNotFoundException) break block5;
                AdtPlugin.logAndPrintError(iOException, AndroidManifestParser.class.getCanonicalName(), "I/O error for %s: %s", iFile.getFullPath(), iOException.getMessage());
            }
        }
        return null;
    }

    private static AndroidManifestParser parse(File file) throws CoreException {
        block4: {
            try {
                SAXParser sAXParser = sParserFactory.newSAXParser();
                ManifestHandler manifestHandler = new ManifestHandler(null, null, true, null, false);
                sAXParser.parse(new InputSource(new FileReader(file)), (DefaultHandler)manifestHandler);
                return new AndroidManifestParser(manifestHandler.getPackage(), manifestHandler.getActivities(), manifestHandler.getLauncherActivity(), manifestHandler.getProcesses(), manifestHandler.getDebuggable(), manifestHandler.getApiLevelRequirement(), manifestHandler.getInstrumentations(), manifestHandler.getUsesLibraries());
            }
            catch (ParserConfigurationException parserConfigurationException) {
                AdtPlugin.logAndPrintError(parserConfigurationException, AndroidManifestParser.class.getCanonicalName(), "Bad parser configuration for %s: %s", file.getAbsolutePath(), parserConfigurationException.getMessage());
            }
            catch (SAXException sAXException) {
                AdtPlugin.logAndPrintError(sAXException, AndroidManifestParser.class.getCanonicalName(), "Parser exception for %s: %s", file.getAbsolutePath(), sAXException.getMessage());
            }
            catch (IOException iOException) {
                if (iOException instanceof FileNotFoundException) break block4;
                AdtPlugin.logAndPrintError(iOException, AndroidManifestParser.class.getCanonicalName(), "I/O error for %s: %s", file.getAbsolutePath(), iOException.getMessage());
            }
        }
        return null;
    }

    public static AndroidManifestParser parse(IJavaProject iJavaProject, XmlErrorHandler.XmlErrorListener xmlErrorListener, boolean bl, boolean bl2) throws CoreException {
        IFile iFile = AndroidManifestParser.getManifest(iJavaProject.getProject());
        try {
            SAXParser sAXParser = sParserFactory.newSAXParser();
            if (iFile != null) {
                ManifestHandler manifestHandler = new ManifestHandler(iFile, xmlErrorListener, bl, iJavaProject, bl2);
                sAXParser.parse(new InputSource(iFile.getContents()), (DefaultHandler)manifestHandler);
                return new AndroidManifestParser(manifestHandler.getPackage(), manifestHandler.getActivities(), manifestHandler.getLauncherActivity(), manifestHandler.getProcesses(), manifestHandler.getDebuggable(), manifestHandler.getApiLevelRequirement(), manifestHandler.getInstrumentations(), manifestHandler.getUsesLibraries());
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            AdtPlugin.logAndPrintError(parserConfigurationException, AndroidManifestParser.class.getCanonicalName(), "Bad parser configuration for %s", iFile.getFullPath());
        }
        catch (SAXException sAXException) {
            AdtPlugin.logAndPrintError(sAXException, AndroidManifestParser.class.getCanonicalName(), "Parser exception for %s", iFile.getFullPath());
        }
        catch (IOException iOException) {
            AdtPlugin.logAndPrintError(iOException, AndroidManifestParser.class.getCanonicalName(), "I/O error for %s", iFile.getFullPath());
        }
        return null;
    }

    public static AndroidManifestParser parseForError(IJavaProject iJavaProject, IFile iFile, XmlErrorHandler.XmlErrorListener xmlErrorListener) throws CoreException {
        return AndroidManifestParser.parse(iJavaProject, iFile, xmlErrorListener, true, true);
    }

    public static AndroidManifestParser parseForData(IFile iFile) throws CoreException {
        return AndroidManifestParser.parse(null, iFile, null, true, false);
    }

    public static AndroidManifestParser parseForData(String string) {
        try {
            return AndroidManifestParser.parse(new File(string));
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public String getPackage() {
        return this.mJavaPackage;
    }

    public Activity[] getActivities() {
        return this.mActivities;
    }

    public Activity getLauncherActivity() {
        return this.mLauncherActivity;
    }

    public String[] getProcesses() {
        return this.mProcesses;
    }

    public Boolean getDebuggable() {
        return this.mDebuggable;
    }

    public String getApiLevelRequirement() {
        return this.mApiLevelRequirement;
    }

    public Instrumentation[] getInstrumentations() {
        return this.mInstrumentations;
    }

    public String[] getUsesLibraries() {
        return this.mLibraries;
    }

    private AndroidManifestParser(String string, Activity[] activityArray, Activity activity, String[] stringArray, Boolean bl, String string2, Instrumentation[] instrumentationArray, String[] stringArray2) {
        this.mJavaPackage = string;
        this.mActivities = activityArray;
        this.mLauncherActivity = activity;
        this.mProcesses = stringArray;
        this.mDebuggable = bl;
        this.mApiLevelRequirement = string2;
        this.mInstrumentations = instrumentationArray;
        this.mLibraries = stringArray2;
    }

    public static IFile getManifest(IProject iProject) {
        IResource iResource = iProject.findMember("/AndroidManifest.xml");
        if (iResource == null || !iResource.exists() || !(iResource instanceof IFile)) {
            return null;
        }
        return (IFile)iResource;
    }

    public static String combinePackageAndClassName(String string, String string2) {
        boolean bl;
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        if (string == null || string.length() == 0) {
            return string2;
        }
        boolean bl2 = string2.charAt(0) == '.';
        boolean bl3 = bl = string2.indexOf(46) != -1;
        if (bl2 || !bl) {
            if (bl2) {
                return String.valueOf(string) + string2;
            }
            return String.valueOf(string) + '.' + string2;
        }
        return string2;
    }

    public static String extractActivityName(String string, String string2) {
        String string3;
        if (string2 != null && string != null && string2.length() > 0 && string.startsWith(string2) && (string3 = string.substring(string2.length())).length() > 0 && string3.charAt(0) == '.') {
            return string3;
        }
        return string;
    }

    public static class Activity {
        private final String mName;
        private final boolean mIsExported;
        private boolean mHasAction = false;
        private boolean mHasMainAction = false;
        private boolean mHasLauncherCategory = false;

        public Activity(String string, boolean bl) {
            this.mName = string;
            this.mIsExported = bl;
        }

        public String getName() {
            return this.mName;
        }

        public boolean isExported() {
            return this.mIsExported;
        }

        public boolean hasAction() {
            return this.mHasAction;
        }

        public boolean isHomeActivity() {
            return this.mHasMainAction && this.mHasLauncherCategory;
        }

        void setHasAction(boolean bl) {
            this.mHasAction = bl;
        }

        void resetIntentFilter() {
            if (!this.isHomeActivity()) {
                this.mHasLauncherCategory = false;
                this.mHasMainAction = false;
            }
        }

        void setHasMainAction(boolean bl) {
            this.mHasMainAction = bl;
        }

        void setHasLauncherCategory(boolean bl) {
            this.mHasLauncherCategory = bl;
        }
    }

    public static class Instrumentation {
        private final String mName;
        private final String mTargetPackage;

        Instrumentation(String string, String string2) {
            this.mName = string;
            this.mTargetPackage = string2;
        }

        public String getName() {
            return this.mName;
        }

        public String getTargetPackage() {
            return this.mTargetPackage;
        }
    }

    private static class ManifestHandler
    extends XmlErrorHandler {
        private String mPackage;
        private final ArrayList<Activity> mActivities = new ArrayList();
        private Activity mLauncherActivity = null;
        private Set<String> mProcesses = null;
        private Boolean mDebuggable = null;
        private String mApiLevelRequirement = null;
        private final ArrayList<Instrumentation> mInstrumentations = new ArrayList();
        private final ArrayList<String> mLibraries = new ArrayList();
        private IJavaProject mJavaProject;
        private boolean mGatherData = false;
        private boolean mMarkErrors = false;
        private int mCurrentLevel = 0;
        private int mValidLevel = 0;
        private Activity mCurrentActivity = null;
        private Locator mLocator;

        ManifestHandler(IFile iFile, XmlErrorHandler.XmlErrorListener xmlErrorListener, boolean bl, IJavaProject iJavaProject, boolean bl2) {
            super(iFile, xmlErrorListener);
            this.mGatherData = bl;
            this.mJavaProject = iJavaProject;
            this.mMarkErrors = bl2;
        }

        String getPackage() {
            return this.mPackage;
        }

        Activity[] getActivities() {
            return this.mActivities.toArray(new Activity[this.mActivities.size()]);
        }

        Activity getLauncherActivity() {
            return this.mLauncherActivity;
        }

        String[] getProcesses() {
            if (this.mProcesses != null) {
                return this.mProcesses.toArray(new String[this.mProcesses.size()]);
            }
            return new String[0];
        }

        Boolean getDebuggable() {
            return this.mDebuggable;
        }

        String getApiLevelRequirement() {
            return this.mApiLevelRequirement;
        }

        Instrumentation[] getInstrumentations() {
            return this.mInstrumentations.toArray(new Instrumentation[this.mInstrumentations.size()]);
        }

        String[] getUsesLibraries() {
            return this.mLibraries.toArray(new String[this.mLibraries.size()]);
        }

        public void setDocumentLocator(Locator locator) {
            this.mLocator = locator;
            super.setDocumentLocator(locator);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            try {
                if (!this.mGatherData) {
                    return;
                }
                if (this.mValidLevel == this.mCurrentLevel) {
                    switch (this.mValidLevel) {
                        case 0: {
                            if (!"manifest".equals(string2)) break;
                            this.mPackage = this.getAttributeValue(attributes, "package", false);
                            ++this.mValidLevel;
                            break;
                        }
                        case 1: {
                            if ("application".equals(string2)) {
                                String string4 = this.getAttributeValue(attributes, "process", true);
                                if (string4 != null) {
                                    this.addProcessName(string4);
                                }
                                if ((string4 = this.getAttributeValue(attributes, "debuggable", true)) != null) {
                                    this.mDebuggable = Boolean.parseBoolean(string4);
                                }
                                ++this.mValidLevel;
                                break;
                            }
                            if ("uses-sdk".equals(string2)) {
                                this.mApiLevelRequirement = this.getAttributeValue(attributes, "minSdkVersion", true);
                                break;
                            }
                            if (!"instrumentation".equals(string2)) break;
                            this.processInstrumentationNode(attributes);
                            break;
                        }
                        case 2: {
                            String string5;
                            if ("activity".equals(string2)) {
                                this.processActivityNode(attributes);
                                ++this.mValidLevel;
                                break;
                            }
                            if ("service".equals(string2)) {
                                this.processNode(attributes, "android.app.Service");
                                ++this.mValidLevel;
                                break;
                            }
                            if ("receiver".equals(string2)) {
                                this.processNode(attributes, "android.content.BroadcastReceiver");
                                ++this.mValidLevel;
                                break;
                            }
                            if ("provider".equals(string2)) {
                                this.processNode(attributes, "android.content.ContentProvider");
                                ++this.mValidLevel;
                                break;
                            }
                            if (!"uses-library".equals(string2) || (string5 = this.getAttributeValue(attributes, "name", true)) == null) break;
                            this.mLibraries.add(string5);
                            break;
                        }
                        case 3: {
                            if (this.mCurrentActivity == null || !"intent-filter".equals(string2)) break;
                            this.mCurrentActivity.resetIntentFilter();
                            ++this.mValidLevel;
                            break;
                        }
                        case 4: {
                            String string6;
                            if (this.mCurrentActivity == null) break;
                            if ("action".equals(string2)) {
                                String string7 = this.getAttributeValue(attributes, "name", true);
                                if (string7 == null) break;
                                this.mCurrentActivity.setHasAction(true);
                                this.mCurrentActivity.setHasMainAction(AndroidManifestParser.ACTION_MAIN.equals(string7));
                                break;
                            }
                            if (!"category".equals(string2) || !AndroidManifestParser.CATEGORY_LAUNCHER.equals(string6 = this.getAttributeValue(attributes, "name", true))) break;
                            this.mCurrentActivity.setHasLauncherCategory(true);
                        }
                    }
                }
                ++this.mCurrentLevel;
            }
            finally {
                super.startElement(string, string2, string3, attributes);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            block11: {
                try {
                    if (!this.mGatherData) {
                        return;
                    }
                    if (this.mValidLevel == this.mCurrentLevel) {
                        --this.mValidLevel;
                    }
                    --this.mCurrentLevel;
                    if (this.mValidLevel != this.mCurrentLevel) break block11;
                    switch (this.mValidLevel) {
                        case 2: {
                            this.mCurrentActivity = null;
                            break;
                        }
                        case 3: {
                            if (this.mLauncherActivity == null && this.mCurrentActivity != null && this.mCurrentActivity.isHomeActivity() && this.mCurrentActivity.isExported()) {
                                this.mLauncherActivity = this.mCurrentActivity;
                            }
                            break;
                        }
                        default: {
                            break;
                        }
                    }
                }
                finally {
                    super.endElement(string, string2, string3);
                }
            }
        }

        public void error(SAXParseException sAXParseException) {
            if (this.mMarkErrors) {
                this.handleError(sAXParseException, sAXParseException.getLineNumber());
            }
        }

        public void fatalError(SAXParseException sAXParseException) {
            if (this.mMarkErrors) {
                this.handleError(sAXParseException, sAXParseException.getLineNumber());
            }
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            if (this.mMarkErrors) {
                super.warning(sAXParseException);
            }
        }

        private void processActivityNode(Attributes attributes) {
            String string;
            String string2 = this.getAttributeValue(attributes, "name", true);
            if (string2 != null) {
                string2 = AndroidManifestParser.combinePackageAndClassName(this.mPackage, string2);
                string = this.getAttributeValue(attributes, "exported", true);
                boolean bl = string == null || string.toLowerCase().equals("true");
                this.mCurrentActivity = new Activity(string2, bl);
                this.mActivities.add(this.mCurrentActivity);
                if (this.mMarkErrors) {
                    this.checkClass(string2, "android.app.Activity", true);
                }
            } else {
                this.mCurrentActivity = null;
            }
            if ((string = this.getAttributeValue(attributes, "process", true)) != null) {
                this.addProcessName(string);
            }
        }

        private void processNode(Attributes attributes, String string) {
            String string2;
            String string3 = this.getAttributeValue(attributes, "name", true);
            if (string3 != null) {
                string3 = AndroidManifestParser.combinePackageAndClassName(this.mPackage, string3);
                if (this.mMarkErrors) {
                    this.checkClass(string3, string, false);
                }
            }
            if ((string2 = this.getAttributeValue(attributes, "process", true)) != null) {
                this.addProcessName(string2);
            }
        }

        private void processInstrumentationNode(Attributes attributes) {
            String string = this.getAttributeValue(attributes, "name", true);
            if (string != null) {
                String string2 = AndroidManifestParser.combinePackageAndClassName(this.mPackage, string);
                String string3 = this.getAttributeValue(attributes, "targetPackage", true);
                this.mInstrumentations.add(new Instrumentation(string2, string3));
                if (this.mMarkErrors) {
                    this.checkClass(string2, "android.app.Instrumentation", true);
                }
            }
        }

        private void checkClass(String string, String string2, boolean bl) {
            if (this.mJavaProject == null) {
                return;
            }
            String string3 = BaseProjectHelper.testClassForManifest(this.mJavaProject, string, string2, bl);
            if (string3 != BaseProjectHelper.TEST_CLASS_OK) {
                int n = this.mLocator.getLineNumber();
                IMarker iMarker = BaseProjectHelper.addMarker((IResource)this.getFile(), "com.android.ide.eclipse.common.androidProblem", string3, n, 2);
                if (iMarker != null) {
                    try {
                        iMarker.setAttribute("android.type", (Object)"activity");
                        iMarker.setAttribute("android.class", (Object)string);
                    }
                    catch (CoreException coreException) {}
                }
            }
        }

        private String getAttributeValue(Attributes attributes, String string, boolean bl) {
            int n = attributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                if (string.equals(attributes.getLocalName(n2)) && (bl && "http://schemas.android.com/apk/res/android".equals(attributes.getURI(n2)) || !bl && attributes.getURI(n2).length() == 0)) {
                    return attributes.getValue(n2);
                }
                ++n2;
            }
            return null;
        }

        private void addProcessName(String string) {
            if (this.mProcesses == null) {
                this.mProcesses = new TreeSet<String>();
            }
            this.mProcesses.add(string);
        }
    }
}

