/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.preferences;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.preferences.Messages;
import com.android.jarutils.DebugKeyProvider;
import com.android.prefs.AndroidLocation;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class BuildPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    static final String BUILD_STR_SILENT = "silent";
    static final String BUILD_STR_NORMAL = "normal";
    static final String BUILD_STR_VERBOSE = "verbose";

    public BuildPreferencePage() {
        super(1);
        this.setPreferenceStore(AdtPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.BuildPreferencePage_Title);
    }

    public static int getBuildLevel(String string) {
        if (BUILD_STR_SILENT.equals(string)) {
            return 0;
        }
        if (BUILD_STR_VERBOSE.equals(string)) {
            return 2;
        }
        return 1;
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new BooleanFieldEditor("com.android.ide.eclipse.adt.resAutoRefresh", Messages.BuildPreferencePage_Auto_Refresh_Resources_on_Build, this.getFieldEditorParent()));
        RadioGroupFieldEditor radioGroupFieldEditor = new RadioGroupFieldEditor("com.android.ide.eclipse.adt.buildVerbosity", Messages.BuildPreferencePage_Build_Output, 1, (String[][])new String[][]{{Messages.BuildPreferencePage_Silent, BUILD_STR_SILENT}, {Messages.BuildPreferencePage_Normal, BUILD_STR_NORMAL}, {Messages.BuildPreferencePage_Verbose, BUILD_STR_VERBOSE}}, this.getFieldEditorParent(), true);
        this.addField((FieldEditor)radioGroupFieldEditor);
        this.addField((FieldEditor)new ReadOnlyFieldEditor("com.android.ide.eclipse.adt.defaultDebugKeyStore", Messages.BuildPreferencePage_Default_KeyStore, this.getFieldEditorParent()));
        this.addField((FieldEditor)new KeystoreFieldEditor("com.android.ide.eclipse.adt.customDebugKeyStore", Messages.BuildPreferencePage_Custom_Keystore, this.getFieldEditorParent()));
    }

    public void init(IWorkbench iWorkbench) {
    }

    private static class KeystoreFieldEditor
    extends FileFieldEditor {
        public KeystoreFieldEditor(String string, String string2, Composite composite) {
            super(string, string2, composite);
            this.setValidateStrategy(0);
        }

        protected boolean checkState() {
            String string = this.getTextControl().getText();
            if ((string = string.trim()).length() > 0) {
                File file = new File(string);
                if (file.isFile()) {
                    block12: {
                        Date date;
                        X509Certificate x509Certificate;
                        block11: {
                            block10: {
                                DebugKeyProvider debugKeyProvider = new DebugKeyProvider(string, null, null);
                                PrivateKey privateKey = debugKeyProvider.getDebugKey();
                                x509Certificate = (X509Certificate)debugKeyProvider.getCertificate();
                                if (privateKey != null && x509Certificate != null) break block10;
                                this.showErrorMessage("Unable to find debug key in keystore!");
                                return false;
                            }
                            date = new Date();
                            if (x509Certificate.getNotAfter().compareTo(date) >= 0) break block11;
                            this.showErrorMessage("Certificate is expired!");
                            return false;
                        }
                        if (x509Certificate.getNotBefore().compareTo(date) <= 0) break block12;
                        this.showErrorMessage("Certificate validity is in the future!");
                        return false;
                    }
                    try {
                        this.clearErrorMessage();
                        return true;
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        this.handleException(generalSecurityException);
                        return false;
                    }
                    catch (IOException iOException) {
                        this.handleException(iOException);
                        return false;
                    }
                    catch (DebugKeyProvider.KeytoolException keytoolException) {
                        this.handleException(keytoolException);
                        return false;
                    }
                    catch (AndroidLocation.AndroidLocationException androidLocationException) {
                        this.handleException(androidLocationException);
                        return false;
                    }
                }
                this.showErrorMessage("Not a valid keystore path.");
                return false;
            }
            this.clearErrorMessage();
            return true;
        }

        public Text getTextControl(Composite composite) {
            this.setValidateStrategy(0);
            return super.getTextControl(composite);
        }

        private void handleException(Throwable throwable) {
            String string = throwable.getMessage();
            if (string == null) {
                Throwable throwable2 = throwable.getCause();
                if (throwable2 != null) {
                    this.handleException(throwable2);
                } else {
                    this.setErrorMessage("Uknown error when getting the debug key!");
                }
                return;
            }
            this.showErrorMessage(string);
        }
    }

    private static class ReadOnlyFieldEditor
    extends StringFieldEditor {
        public ReadOnlyFieldEditor(String string, String string2, Composite composite) {
            super(string, string2, composite);
        }

        protected void createControl(Composite composite) {
            super.createControl(composite);
            Text text = this.getTextControl();
            text.setEditable(false);
        }
    }
}

