/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.launch.junit;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.launch.AndroidLaunch;
import com.android.ide.eclipse.adt.internal.launch.AndroidLaunchConfiguration;
import com.android.ide.eclipse.adt.internal.launch.AndroidLaunchController;
import com.android.ide.eclipse.adt.internal.launch.LaunchConfigDelegate;
import com.android.ide.eclipse.adt.internal.launch.junit.AndroidJUnitLaunchAction;
import com.android.ide.eclipse.adt.internal.launch.junit.InstrumentationRunnerValidator;
import com.android.ide.eclipse.adt.internal.launch.junit.runtime.AndroidJUnitLaunchInfo;
import com.android.ide.eclipse.adt.internal.project.AndroidManifestParser;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

public class AndroidJUnitLaunchConfigDelegate
extends LaunchConfigDelegate {
    static final String ATTR_INSTR_NAME = "com.android.ide.eclipse.adt.instrumentation";
    private static final String EMPTY_STRING = "";

    protected void doLaunch(ILaunchConfiguration iLaunchConfiguration, String string, IProgressMonitor iProgressMonitor, IProject iProject, AndroidLaunch androidLaunch, AndroidLaunchConfiguration androidLaunchConfiguration, AndroidLaunchController androidLaunchController, IFile iFile, AndroidManifestParser androidManifestParser) {
        String string2 = this.getRunner(iProject, iLaunchConfiguration, androidManifestParser);
        if (string2 == null) {
            AdtPlugin.displayError("Android Launch", "An instrumention test runner is not specified!");
            androidLaunch.stopLaunch();
            return;
        }
        String string3 = this.getTargetPackage(androidManifestParser, string2);
        if (string3 == null) {
            AdtPlugin.displayError("Android Launch", String.format("A target package for instrumention test runner %1$s could not be found!", string2));
            androidLaunch.stopLaunch();
            return;
        }
        String string4 = androidManifestParser.getPackage();
        AndroidJUnitLaunchInfo androidJUnitLaunchInfo = new AndroidJUnitLaunchInfo(iProject, string4, string2);
        androidJUnitLaunchInfo.setTestClass(this.getTestClass(iLaunchConfiguration));
        androidJUnitLaunchInfo.setTestPackage(this.getTestPackage(iLaunchConfiguration));
        androidJUnitLaunchInfo.setTestMethod(this.getTestMethod(iLaunchConfiguration));
        androidJUnitLaunchInfo.setLaunch((ILaunch)androidLaunch);
        AndroidJUnitLaunchAction androidJUnitLaunchAction = new AndroidJUnitLaunchAction(androidJUnitLaunchInfo);
        androidLaunchController.launch(iProject, string, iFile, string4, string3, androidManifestParser.getDebuggable(), androidManifestParser.getApiLevelRequirement(), androidJUnitLaunchAction, androidLaunchConfiguration, androidLaunch, iProgressMonitor);
    }

    private String getTargetPackage(AndroidManifestParser androidManifestParser, String string) {
        AndroidManifestParser.Instrumentation[] instrumentationArray = androidManifestParser.getInstrumentations();
        int n = instrumentationArray.length;
        int n2 = 0;
        while (n2 < n) {
            AndroidManifestParser.Instrumentation instrumentation = instrumentationArray[n2];
            if (instrumentation.getName().equals(string)) {
                return instrumentation.getTargetPackage();
            }
            ++n2;
        }
        return null;
    }

    private String getTestPackage(ILaunchConfiguration iLaunchConfiguration) {
        IJavaElement iJavaElement;
        String string = this.getStringLaunchAttribute("org.eclipse.jdt.junit.CONTAINER", iLaunchConfiguration);
        if (string != null && string.length() > 0 && (iJavaElement = JavaCore.create((String)string)).getElementType() == 4) {
            return iJavaElement.getElementName();
        }
        return null;
    }

    private String getTestClass(ILaunchConfiguration iLaunchConfiguration) {
        return this.getStringLaunchAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, iLaunchConfiguration);
    }

    private String getTestMethod(ILaunchConfiguration iLaunchConfiguration) {
        return this.getStringLaunchAttribute("org.eclipse.jdt.junit.TESTNAME", iLaunchConfiguration);
    }

    private String getRunner(IProject iProject, ILaunchConfiguration iLaunchConfiguration, AndroidManifestParser androidManifestParser) {
        try {
            String string = this.getRunnerFromConfig(iLaunchConfiguration);
            if (string != null) {
                return string;
            }
            InstrumentationRunnerValidator instrumentationRunnerValidator = new InstrumentationRunnerValidator(BaseProjectHelper.getJavaProject(iProject), androidManifestParser);
            string = instrumentationRunnerValidator.getValidInstrumentationTestRunner();
            if (string != null) {
                AdtPlugin.printErrorToConsole(iProject, new Object[]{String.format("Warning: No instrumentation runner found for the launch, using %1$s", string)});
                return string;
            }
            AdtPlugin.printErrorToConsole(iProject, new Object[]{String.format("ERROR: Application does not specify a %1$s instrumentation or does not declare uses-library %2$s", "android.test.InstrumentationTestRunner", "android.test.runner")});
            return null;
        }
        catch (CoreException coreException) {
            AdtPlugin.log(coreException, "Error when retrieving instrumentation info", new Object[0]);
            return null;
        }
    }

    private String getRunnerFromConfig(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        return this.getStringLaunchAttribute(ATTR_INSTR_NAME, iLaunchConfiguration);
    }

    private String getStringLaunchAttribute(String string, ILaunchConfiguration iLaunchConfiguration) {
        String string2;
        block3: {
            try {
                string2 = iLaunchConfiguration.getAttribute(string, EMPTY_STRING);
                if (string2.length() >= 1) break block3;
                return null;
            }
            catch (CoreException coreException) {
                AdtPlugin.log(coreException, String.format("Error when retrieving launch info %1$s", string), new Object[0]);
                return null;
            }
        }
        return string2;
    }

    static void setJUnitDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.jdt.junit.TEST_KIND", "org.eclipse.jdt.junit.loader.junit3");
    }
}

