/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.launch;

import com.android.ide.eclipse.adt.AdtPlugin;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.junit.launcher.JUnitLaunchConfigurationDelegate;
import org.osgi.framework.Bundle;

public class JUnitLaunchConfigDelegate
extends JUnitLaunchConfigurationDelegate {
    private static final String JUNIT_JAR = "junit.jar";

    public String[][] getBootpathExt(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String[][] stringArray = super.getBootpathExt(iLaunchConfiguration);
        return JUnitLaunchConfigDelegate.fixBootpathExt(stringArray);
    }

    public String[] getClasspath(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String[] stringArray = super.getClasspath(iLaunchConfiguration);
        return JUnitLaunchConfigDelegate.fixClasspath(stringArray, this.getJavaProjectName(iLaunchConfiguration));
    }

    public static String[][] fixBootpathExt(String[][] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null && stringArray[n][0].endsWith("android.jar")) {
                stringArray[n] = null;
            }
            ++n;
        }
        return stringArray;
    }

    public static String[] fixClasspath(String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].endsWith(JUNIT_JAR)) {
                return stringArray;
            }
            ++n;
        }
        try {
            String string2 = JUnitLaunchConfigDelegate.getJunitJarLocation();
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray2.length - 1] = string2;
            stringArray = stringArray2;
        }
        catch (IOException iOException) {
            AdtPlugin.log(iOException, "Could not find a valid junit.jar", new Object[0]);
            AdtPlugin.printErrorToConsole(string, "Could not find a valid junit.jar");
        }
        return stringArray;
    }

    public static String getJunitJarLocation() throws IOException {
        Bundle bundle = Platform.getBundle((String)"org.junit");
        if (bundle == null) {
            throw new IOException("Cannot find org.junit bundle");
        }
        URL uRL = bundle.getEntry("/junit.jar");
        return FileLocator.resolve((URL)uRL).getFile();
    }
}

