/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.launch;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.launch.DelayedLaunchInfo;
import com.android.ide.eclipse.adt.internal.launch.ILaunchController;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AMReceiver
extends MultiLineReceiver {
    private static final int MAX_ATTEMPT_COUNT = 5;
    private static final Pattern sAmErrorType = Pattern.compile("Error type (\\d+)");
    private final DelayedLaunchInfo mLaunchInfo;
    private final IDevice mDevice;
    private final ILaunchController mLaunchController;

    public AMReceiver(DelayedLaunchInfo delayedLaunchInfo, IDevice iDevice, ILaunchController iLaunchController) {
        this.mLaunchInfo = delayedLaunchInfo;
        this.mDevice = iDevice;
        this.mLaunchController = iLaunchController;
    }

    public void processNewLines(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        boolean bl2 = false;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            if (string.length() != 0) {
                Matcher matcher;
                if (this.mLaunchInfo.getAttemptCount() < 5 && !this.mLaunchInfo.isCancelled() && (matcher = sAmErrorType.matcher(string)).matches()) {
                    String string2;
                    int n3 = Integer.parseInt(matcher.group(1));
                    switch (n3) {
                        case 1: 
                        case 2: {
                            string2 = String.format("Device not ready. Waiting %1$d seconds before next attempt.", 3);
                            break;
                        }
                        case 3: {
                            string2 = String.format("New package not yet registered with the system. Waiting %1$d seconds before next attempt.", 3);
                            break;
                        }
                        default: {
                            string2 = String.format("Device not ready (%2$d). Waiting %1$d seconds before next attempt.", 3, n3);
                        }
                    }
                    AdtPlugin.printToConsole(this.mLaunchInfo.getProject(), string2);
                    new Thread("Delayed Launch attempt"){

                        public void run() {
                            try {
                                1.sleep(3000L);
                            }
                            catch (InterruptedException interruptedException) {}
                            AMReceiver.this.mLaunchController.launchApp(AMReceiver.this.mLaunchInfo, AMReceiver.this.mDevice);
                        }
                    }.start();
                    return;
                }
                if (!bl && string.startsWith("Error:")) {
                    bl = true;
                }
                if (!bl2 && string.startsWith("Warning:")) {
                    bl2 = true;
                }
                arrayList.add("ActivityManager: " + string);
            }
            ++n2;
        }
        if (bl2 || bl) {
            AdtPlugin.printErrorToConsole(this.mLaunchInfo.getProject(), arrayList.toArray());
        } else {
            AdtPlugin.printToConsole(this.mLaunchInfo.getProject(), arrayList.toArray());
        }
        if (bl) {
            this.mLaunchController.stopLaunch(this.mLaunchInfo);
        }
    }

    public boolean isCancelled() {
        return this.mLaunchInfo.isCancelled();
    }
}

