/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.xml;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.AndroidEditor;
import com.android.ide.eclipse.adt.internal.editors.FirstElementParser;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DocumentDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiDocumentNode;
import com.android.ide.eclipse.adt.internal.editors.xml.XmlTreePage;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.sdklib.IAndroidTarget;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.w3c.dom.Document;

public class XmlEditor
extends AndroidEditor {
    public static final String ID = "com.android.ide.eclipse.editors.xml.XmlEditor";
    private UiDocumentNode mUiRootNode;

    public UiDocumentNode getUiRootNode() {
        return this.mUiRootNode;
    }

    public static boolean canHandleFile(IFile iFile) {
        IProject iProject = iFile.getProject();
        IAndroidTarget iAndroidTarget = Sdk.getCurrent().getTarget(iProject);
        if (iAndroidTarget != null) {
            String string;
            AndroidTargetData androidTargetData = Sdk.getCurrent().getTargetData(iAndroidTarget);
            FirstElementParser.Result result = FirstElementParser.parse(iFile.getLocation().toOSString(), "http://schemas.android.com/apk/res/android");
            if (result != null && (string = result.getElement()) != null && result.getXmlnsPrefix() != null) {
                DocumentDescriptor documentDescriptor = androidTargetData.getXmlDescriptors().getDescriptor();
                ElementDescriptor[] elementDescriptorArray = documentDescriptor.getChildren();
                int n = elementDescriptorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ElementDescriptor elementDescriptor = elementDescriptorArray[n2];
                    if (elementDescriptor.getXmlName().equals(string)) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void createFormPages() {
        try {
            this.addPage((IFormPage)new XmlTreePage(this));
        }
        catch (PartInitException partInitException) {
            AdtPlugin.log(partInitException, "Error creating nested page", new Object[0]);
        }
    }

    protected void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        if (iEditorInput instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)iEditorInput;
            IFile iFile = fileEditorInput.getFile();
            this.setPartName(String.format("%1$s", iFile.getName()));
        }
    }

    protected void xmlModelChanged(Document document) {
        this.initUiRootNode(false);
        this.mUiRootNode.loadFromXmlNode(document);
        super.xmlModelChanged(document);
    }

    protected void initUiRootNode(boolean bl) {
        if (this.mUiRootNode == null || bl) {
            AndroidTargetData androidTargetData;
            Document document = null;
            if (this.mUiRootNode != null) {
                document = this.mUiRootNode.getXmlDocument();
            }
            DocumentDescriptor documentDescriptor = (androidTargetData = this.getTargetData()) == null ? new DocumentDescriptor("temp", null) : androidTargetData.getXmlDescriptors().getDescriptor();
            this.mUiRootNode = (UiDocumentNode)documentDescriptor.createUiNode();
            this.mUiRootNode.setEditor(this);
            this.onDescriptorsChanged(document);
        }
    }

    private void onDescriptorsChanged(Document document) {
        if (document != null) {
            this.mUiRootNode.loadFromXmlNode(document);
        } else {
            this.mUiRootNode.reloadFromXmlNode(this.mUiRootNode.getXmlNode());
        }
    }
}

