/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.uimodel;

import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DescriptorsUtils;
import com.android.ide.eclipse.adt.internal.editors.descriptors.TextAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.ui.SectionHelper;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiAbstractTextAttributeNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class UiTextAttributeNode
extends UiAbstractTextAttributeNode {
    private Text mText;
    private IManagedForm mManagedForm;

    public UiTextAttributeNode(AttributeDescriptor attributeDescriptor, UiElementNode uiElementNode) {
        super(attributeDescriptor, uiElementNode);
    }

    public void createUiControl(Composite composite, IManagedForm iManagedForm) {
        this.setManagedForm(iManagedForm);
        TextAttributeDescriptor textAttributeDescriptor = (TextAttributeDescriptor)this.getDescriptor();
        Text text = SectionHelper.createLabelAndText(composite, iManagedForm.getToolkit(), textAttributeDescriptor.getUiName(), this.getCurrentValue(), DescriptorsUtils.formatTooltip(textAttributeDescriptor.getTooltip()));
        this.setTextWidget(text);
    }

    public String[] getPossibleValues(String string) {
        return null;
    }

    protected void setManagedForm(IManagedForm iManagedForm) {
        this.mManagedForm = iManagedForm;
    }

    protected IManagedForm getManagedForm() {
        return this.mManagedForm;
    }

    public boolean isValid() {
        return this.mText != null;
    }

    public String getTextWidgetValue() {
        if (this.mText != null) {
            return this.mText.getText();
        }
        return null;
    }

    public void setTextWidgetValue(String string) {
        if (this.mText != null) {
            this.mText.setText(string);
        }
    }

    protected final void setTextWidget(Text text) {
        this.mText = text;
        if (text != null) {
            Object object = text.getLayoutData();
            if (object != null) {
                if (object instanceof GridData) {
                    ((GridData)object).widthHint = 50;
                } else if (object instanceof TableWrapData) {
                    ((TableWrapData)object).maxWidth = 100;
                }
            }
            this.mText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    if (!(UiTextAttributeNode.this.isInInternalTextModification() || UiTextAttributeNode.this.isDirty() || UiTextAttributeNode.this.mText == null || UiTextAttributeNode.this.getCurrentValue() == null || UiTextAttributeNode.this.mText.getText().equals(UiTextAttributeNode.this.getCurrentValue()))) {
                        UiTextAttributeNode.this.setDirty(true);
                    }
                }
            });
            this.mText.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    UiTextAttributeNode.this.mText = null;
                }
            });
        }
        this.onAddValidators(this.mText);
    }

    protected void onAddValidators(Text text) {
    }

    protected final Text getTextWidget() {
        return this.mText;
    }
}

