/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.uimodel;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.AndroidEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DescriptorsUtils;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ListAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.TextAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.ui.SectionHelper;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiAbstractTextAttributeNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class UiListAttributeNode
extends UiAbstractTextAttributeNode {
    protected Combo mCombo;

    public UiListAttributeNode(ListAttributeDescriptor listAttributeDescriptor, UiElementNode uiElementNode) {
        super(listAttributeDescriptor, uiElementNode);
    }

    public final void createUiControl(Composite composite, IManagedForm iManagedForm) {
        FormToolkit formToolkit = iManagedForm.getToolkit();
        TextAttributeDescriptor textAttributeDescriptor = (TextAttributeDescriptor)this.getDescriptor();
        Label label = formToolkit.createLabel(composite, textAttributeDescriptor.getUiName());
        label.setLayoutData((Object)new TableWrapData(2, 32));
        SectionHelper.addControlTooltip((Control)label, DescriptorsUtils.formatTooltip(textAttributeDescriptor.getTooltip()));
        int n = 4;
        this.mCombo = new Combo(composite, n);
        TableWrapData tableWrapData = new TableWrapData(256, 32);
        tableWrapData.maxWidth = 100;
        this.mCombo.setLayoutData((Object)tableWrapData);
        this.fillCombo();
        this.setTextWidgetValue(this.getCurrentValue());
        this.mCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (!(UiListAttributeNode.this.isInInternalTextModification() || UiListAttributeNode.this.isDirty() || UiListAttributeNode.this.mCombo == null || UiListAttributeNode.this.getCurrentValue() == null || UiListAttributeNode.this.mCombo.getText().equals(UiListAttributeNode.this.getCurrentValue()))) {
                    UiListAttributeNode.this.setDirty(true);
                }
            }
        });
        this.mCombo.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                UiListAttributeNode.this.mCombo = null;
            }
        });
    }

    protected void fillCombo() {
        String[] stringArray = this.getPossibleValues(null);
        if (stringArray == null) {
            AdtPlugin.log(4, "FrameworkResourceManager did not provide values yet for %1$s", this.getDescriptor().getXmlLocalName());
        } else {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                this.mCombo.add(string);
                ++n2;
            }
        }
    }

    public String[] getPossibleValues(String string) {
        UiElementNode uiElementNode;
        AndroidEditor androidEditor;
        AndroidTargetData androidTargetData;
        AttributeDescriptor attributeDescriptor = this.getDescriptor();
        UiElementNode uiElementNode2 = this.getUiParent();
        String string2 = attributeDescriptor.getXmlLocalName();
        String string3 = uiElementNode2.getDescriptor().getXmlName();
        String string4 = "";
        if ("http://schemas.android.com/apk/res/android".equals(attributeDescriptor.getNamespaceUri())) {
            string4 = "android:";
        } else if ("http://www.w3.org/2000/xmlns/".equals(attributeDescriptor.getNamespaceUri())) {
            string4 = "xmlns:";
        }
        string2 = String.valueOf(string4) + string2;
        String[] stringArray = null;
        if (attributeDescriptor instanceof ListAttributeDescriptor && ((ListAttributeDescriptor)attributeDescriptor).getValues() != null) {
            stringArray = ((ListAttributeDescriptor)attributeDescriptor).getValues();
        }
        if (stringArray == null && (androidTargetData = (androidEditor = (uiElementNode = this.getUiParent()).getEditor()).getTargetData()) != null) {
            UiElementNode uiElementNode3;
            UiElementNode uiElementNode4 = uiElementNode2.getUiParent();
            String string5 = null;
            if (uiElementNode4 != null && (uiElementNode3 = uiElementNode4.getUiParent()) != null) {
                string5 = uiElementNode3.getDescriptor().getXmlName();
            }
            stringArray = androidTargetData.getAttributeValues(string3, string2, string5);
        }
        return stringArray;
    }

    public String getTextWidgetValue() {
        if (this.mCombo != null) {
            return this.mCombo.getText();
        }
        return null;
    }

    public final boolean isValid() {
        return this.mCombo != null;
    }

    public void setTextWidgetValue(String string) {
        if (this.mCombo != null) {
            this.mCombo.setText(string);
        }
    }
}

