/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.ui.tree;

import com.android.ide.eclipse.adt.internal.editors.descriptors.DescriptorsUtils;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.ICommitXml;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.NewItemSelectionDialog;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.UiModelTreeLabelProvider;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiDocumentNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UiActions
implements ICommitXml {
    protected abstract UiElementNode getRootNode();

    @Override
    public abstract void commitPendingXmlChanges();

    protected abstract void selectUiNode(UiElementNode var1);

    public void doAdd(UiElementNode uiElementNode, Shell shell) {
        this.doAdd(uiElementNode, null, shell, new UiModelTreeLabelProvider());
    }

    public void doAdd(UiElementNode uiElementNode, ElementDescriptor[] elementDescriptorArray, Shell shell, ILabelProvider iLabelProvider) {
        UiElementNode uiElementNode2 = this.getRootNode();
        if (uiElementNode2 instanceof UiDocumentNode && uiElementNode2.getUiChildren().size() > 0) {
            uiElementNode2 = uiElementNode2.getUiChildren().get(0);
        }
        NewItemSelectionDialog newItemSelectionDialog = new NewItemSelectionDialog(shell, iLabelProvider, elementDescriptorArray, uiElementNode, uiElementNode2);
        newItemSelectionDialog.open();
        Object[] objectArray = newItemSelectionDialog.getResult();
        if (objectArray != null && objectArray.length > 0) {
            this.addElement(newItemSelectionDialog.getChosenRootNode(), null, (ElementDescriptor)objectArray[0], true);
        }
    }

    public UiElementNode addElement(UiElementNode uiElementNode, UiElementNode uiElementNode2, ElementDescriptor elementDescriptor, boolean bl) {
        if (uiElementNode instanceof UiDocumentNode && uiElementNode.getUiChildren().size() > 0) {
            uiElementNode = uiElementNode.getUiChildren().get(0);
        }
        if (uiElementNode2 != null && uiElementNode2.getUiParent() != uiElementNode) {
            uiElementNode2 = null;
        }
        UiElementNode uiElementNode3 = this.addNewTreeElement(uiElementNode, uiElementNode2, elementDescriptor, bl);
        this.selectUiNode(uiElementNode3);
        return uiElementNode3;
    }

    public void doRemove(final List<UiElementNode> list, Shell shell) {
        if (list == null || list.size() == 0) {
            return;
        }
        final int n = list.size();
        StringBuilder stringBuilder = new StringBuilder();
        for (UiElementNode uiElementNode : list) {
            stringBuilder.append("\n- ");
            stringBuilder.append(uiElementNode.getBreadcrumbTrailDescription(false));
        }
        if (MessageDialog.openQuestion((Shell)shell, (String)(n > 1 ? "Remove elements from Android XML" : "Remove element from Android XML"), (String)String.format("Do you really want to remove %1$s?", stringBuilder.toString()))) {
            this.commitPendingXmlChanges();
            this.getRootNode().getEditor().editXmlModel(new Runnable(){

                public void run() {
                    UiElementNode uiElementNode = null;
                    UiElementNode uiElementNode2 = null;
                    int n2 = n - 1;
                    while (n2 >= 0) {
                        UiElementNode uiElementNode3 = (UiElementNode)list.get(n2);
                        uiElementNode = uiElementNode3.getUiPreviousSibling();
                        uiElementNode2 = uiElementNode3.getUiParent();
                        uiElementNode3.deleteXmlNode();
                        --n2;
                    }
                    if (uiElementNode != null) {
                        UiActions.this.selectUiNode(uiElementNode);
                    } else if (uiElementNode2 != null) {
                        UiActions.this.selectUiNode(uiElementNode2);
                    }
                }
            });
        }
    }

    public void doUp(List<UiElementNode> list) {
        if (list == null || list.size() < 1) {
            return;
        }
        final Node[] nodeArray = new Node[1];
        UiElementNode uiElementNode = null;
        UiElementNode uiElementNode2 = null;
        int n = 0;
        while (n < list.size()) {
            uiElementNode = list.get(n);
            final UiElementNode uiElementNode3 = uiElementNode;
            uiElementNode2 = uiElementNode3.getUiParent();
            if (uiElementNode2 != null && uiElementNode2.getUiParent() != null) {
                uiElementNode2 = uiElementNode2.getUiParent();
            }
            this.commitPendingXmlChanges();
            this.getRootNode().getEditor().editXmlModel(new Runnable(){

                public void run() {
                    Node node;
                    Node node2 = uiElementNode3.getXmlNode();
                    if (node2 != null && (node = node2.getParentNode()) != null) {
                        UiElementNode uiElementNode = uiElementNode3.getUiPreviousSibling();
                        if (uiElementNode != null && uiElementNode.getXmlNode() != null) {
                            Node node3 = uiElementNode.getXmlNode();
                            if (uiElementNode.getDescriptor().hasChildren()) {
                                node3.appendChild(node.removeChild(node2));
                                nodeArray[0] = node2;
                            } else {
                                node.insertBefore(node.removeChild(node2), node3);
                                nodeArray[0] = node2;
                            }
                        } else if (!(node instanceof Document) && node.getParentNode() != null && !(node.getParentNode() instanceof Document)) {
                            Node node4 = node.getParentNode();
                            node4.insertBefore(node.removeChild(node2), node);
                            nodeArray[0] = node2;
                        }
                    }
                }
            });
            ++n;
        }
        if (nodeArray[0] == null) {
            this.selectUiNode(uiElementNode);
        } else {
            if (uiElementNode2 == null) {
                uiElementNode2 = uiElementNode.getUiRoot();
            }
            if (uiElementNode2 != null) {
                this.selectUiNode(uiElementNode2.findXmlNode(nodeArray[0]));
            }
        }
    }

    public void doDown(List<UiElementNode> list) {
        if (list == null || list.size() < 1) {
            return;
        }
        final Node[] nodeArray = new Node[1];
        UiElementNode uiElementNode = null;
        UiElementNode uiElementNode2 = null;
        int n = list.size() - 1;
        while (n >= 0) {
            uiElementNode = list.get(n);
            final UiElementNode uiElementNode3 = uiElementNode;
            uiElementNode2 = uiElementNode3.getUiParent();
            if (uiElementNode2 != null && uiElementNode2.getUiParent() != null) {
                uiElementNode2 = uiElementNode2.getUiParent();
            }
            this.commitPendingXmlChanges();
            this.getRootNode().getEditor().editXmlModel(new Runnable(){

                public void run() {
                    Node node;
                    Node node2 = uiElementNode3.getXmlNode();
                    if (node2 != null && (node = node2.getParentNode()) != null) {
                        UiElementNode uiElementNode = uiElementNode3.getUiNextSibling();
                        if (uiElementNode != null && uiElementNode.getXmlNode() != null) {
                            Node node3 = uiElementNode.getXmlNode();
                            if (uiElementNode.getDescriptor().hasChildren()) {
                                node3.insertBefore(node.removeChild(node2), node3.getFirstChild());
                                nodeArray[0] = node2;
                            } else {
                                node.insertBefore(node.removeChild(node2), node3.getNextSibling());
                                nodeArray[0] = node2;
                            }
                        } else if (!(node instanceof Document) && node.getParentNode() != null && !(node.getParentNode() instanceof Document)) {
                            Node node4 = node.getParentNode();
                            node4.insertBefore(node.removeChild(node2), node.getNextSibling());
                            nodeArray[0] = node2;
                        }
                    }
                }
            });
            --n;
        }
        if (nodeArray[0] == null) {
            this.selectUiNode(uiElementNode);
        } else {
            if (uiElementNode2 == null) {
                uiElementNode2 = uiElementNode.getUiRoot();
            }
            if (uiElementNode2 != null) {
                this.selectUiNode(uiElementNode2.findXmlNode(nodeArray[0]));
            }
        }
    }

    private UiElementNode addNewTreeElement(UiElementNode uiElementNode, UiElementNode uiElementNode2, ElementDescriptor elementDescriptor, final boolean bl) {
        UiElementNode uiElementNode32;
        this.commitPendingXmlChanges();
        int n = 0;
        for (final UiElementNode uiElementNode32 : uiElementNode.getUiChildren()) {
            if (uiElementNode32 == uiElementNode2) break;
            ++n;
        }
        uiElementNode32 = uiElementNode.insertNewUiChild(n, elementDescriptor);
        UiElementNode uiElementNode4 = this.getRootNode();
        uiElementNode4.getEditor().editXmlModel(new Runnable(){

            public void run() {
                DescriptorsUtils.setDefaultLayoutAttributes(uiElementNode32, bl);
                uiElementNode32.createXmlNode();
            }
        });
        return uiElementNode32;
    }
}

