/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.ui;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.XmlnsAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.manifest.ManifestEditor;
import com.android.ide.eclipse.adt.internal.editors.ui.SectionHelper;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiAttributeNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class UiElementPart
extends SectionHelper.ManifestSectionPart {
    private ManifestEditor mEditor;
    private UiElementNode mUiElementNode;
    private Composite mTable;

    public UiElementPart(Composite composite, FormToolkit formToolkit, ManifestEditor manifestEditor, UiElementNode uiElementNode, String string, String string2, int n) {
        super(composite, formToolkit, n, string2 != null);
        this.mEditor = manifestEditor;
        this.mUiElementNode = uiElementNode;
        this.setupSection(string, string2);
        if (uiElementNode == null) {
            AdtPlugin.log(4, "Missing node to edit!", new Object[0]);
            return;
        }
    }

    public ManifestEditor getEditor() {
        return this.mEditor;
    }

    public UiElementNode getUiElementNode() {
        return this.mUiElementNode;
    }

    public void setUiElementNode(UiElementNode uiElementNode) {
        this.mUiElementNode = uiElementNode;
    }

    public void initialize(IManagedForm iManagedForm) {
        super.initialize(iManagedForm);
        this.createFormControls(iManagedForm);
    }

    protected void setupSection(String string, String string2) {
        Section section = this.getSection();
        section.setText(string);
        section.setDescription(string2);
    }

    protected void createFormControls(IManagedForm iManagedForm) {
        this.setTable(this.createTableLayout(iManagedForm.getToolkit(), 2));
        this.createUiAttributes(iManagedForm);
    }

    protected void setTable(Composite composite) {
        this.mTable = composite;
    }

    protected Composite getTable() {
        return this.mTable;
    }

    protected void createUiAttributes(IManagedForm iManagedForm) {
        Composite composite = this.getTable();
        if (composite == null || iManagedForm == null) {
            return;
        }
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        this.fillTable(composite, iManagedForm);
        this.layoutChanged();
    }

    protected void fillTable(Composite composite, IManagedForm iManagedForm) {
        int n = this.insertUiAttributes(this.mUiElementNode, composite, iManagedForm);
        if (n == 0) {
            this.createLabel(composite, iManagedForm.getToolkit(), "No attributes to display, waiting for SDK to finish loading...", null);
        }
    }

    protected int insertUiAttributes(UiElementNode uiElementNode, Composite composite, IManagedForm iManagedForm) {
        AttributeDescriptor[] attributeDescriptorArray;
        if (uiElementNode == null || composite == null || iManagedForm == null) {
            return 0;
        }
        AttributeDescriptor[] attributeDescriptorArray2 = attributeDescriptorArray = uiElementNode.getAttributeDescriptors();
        int n = attributeDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeDescriptor attributeDescriptor = attributeDescriptorArray2[n2];
            if (!(attributeDescriptor instanceof XmlnsAttributeDescriptor)) {
                UiAttributeNode uiAttributeNode = uiElementNode.findUiAttribute(attributeDescriptor);
                if (uiAttributeNode != null) {
                    uiAttributeNode.createUiControl(composite, iManagedForm);
                } else {
                    AdtPlugin.log(2, "Attribute %1$s not declared in node %2$s, ignored.", attributeDescriptor.getXmlLocalName(), uiElementNode.getDescriptor().getXmlName());
                }
            }
            ++n2;
        }
        return attributeDescriptorArray.length;
    }

    public boolean isDirty() {
        if (this.mUiElementNode != null && !super.isDirty()) {
            for (UiAttributeNode uiAttributeNode : this.mUiElementNode.getUiAttributes()) {
                if (!uiAttributeNode.isDirty()) continue;
                this.markDirty();
                break;
            }
        }
        return super.isDirty();
    }

    public void commit(boolean bl) {
        if (this.mUiElementNode != null) {
            this.mEditor.editXmlModel(new Runnable(){

                public void run() {
                    for (UiAttributeNode uiAttributeNode : UiElementPart.this.mUiElementNode.getUiAttributes()) {
                        uiAttributeNode.commit();
                    }
                }
            });
        }
        super.commit(bl);
    }
}

