/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.ui;

import com.android.ide.eclipse.adt.AdtPlugin;
import java.lang.reflect.Method;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public final class SectionHelper {
    public static Composite createTableLayout(Composite composite, FormToolkit formToolkit, int n) {
        Composite composite2 = formToolkit.createComposite(composite);
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.numColumns = n;
        composite2.setLayout((Layout)tableWrapLayout);
        formToolkit.paintBordersFor(composite2);
        if (composite instanceof Section) {
            ((Section)composite).setClient((Control)composite2);
        }
        return composite2;
    }

    public static Composite createGridLayout(Composite composite, FormToolkit formToolkit, int n) {
        Composite composite2 = formToolkit.createComposite(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        composite2.setLayout((Layout)gridLayout);
        formToolkit.paintBordersFor(composite2);
        if (composite instanceof Section) {
            ((Section)composite).setClient((Control)composite2);
        }
        return composite2;
    }

    public static Text createLabelAndText(Composite composite, FormToolkit formToolkit, String string, String string2, String string3) {
        Label label = formToolkit.createLabel(composite, string);
        label.setLayoutData((Object)new TableWrapData(2, 32));
        Text text = formToolkit.createText(composite, string2);
        text.setLayoutData((Object)new TableWrapData(256, 32));
        SectionHelper.addControlTooltip((Control)label, string3);
        return text;
    }

    public static Label createLabel(Composite composite, FormToolkit formToolkit, String string, String string2) {
        Label label = formToolkit.createLabel(composite, string);
        TableWrapData tableWrapData = new TableWrapData(256);
        if (composite.getLayout() instanceof TableWrapLayout) {
            tableWrapData.colspan = ((TableWrapLayout)composite.getLayout()).numColumns;
        }
        label.setLayoutData((Object)tableWrapData);
        SectionHelper.addControlTooltip((Control)label, string2);
        return label;
    }

    public static void addControlTooltip(final Control control, String string) {
        if (control == null || string == null || string.length() == 0) {
            return;
        }
        if (control instanceof Button) {
            control.setToolTipText(string);
            return;
        }
        control.setToolTipText(null);
        final DefaultInformationControl defaultInformationControl = new DefaultInformationControl(control.getShell());
        defaultInformationControl.setInformation(string);
        Point point = defaultInformationControl.computeSizeHint();
        defaultInformationControl.setSize(point.x, point.y);
        defaultInformationControl.setVisible(false);
        control.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent mouseEvent) {
            }

            public void mouseExit(MouseEvent mouseEvent) {
                defaultInformationControl.setVisible(false);
            }

            public void mouseHover(MouseEvent mouseEvent) {
                defaultInformationControl.setLocation(control.toDisplay(10, 25));
                defaultInformationControl.setVisible(true);
            }
        });
    }

    public static FormText createFormText(Composite composite, FormToolkit formToolkit, boolean bl, String string, boolean bl2) {
        FormText formText = formToolkit.createFormText(composite, true);
        if (bl2) {
            TableWrapData tableWrapData = new TableWrapData(256);
            tableWrapData.maxWidth = 50;
            if (composite.getLayout() instanceof TableWrapLayout) {
                tableWrapData.colspan = ((TableWrapLayout)composite.getLayout()).numColumns;
            }
            formText.setLayoutData((Object)tableWrapData);
        }
        formText.setWhitespaceNormalized(true);
        formText.setText(string, bl, bl);
        return formText;
    }

    public static class ManifestSectionPart
    extends SectionPart {
        public ManifestSectionPart(Composite composite, FormToolkit formToolkit) {
            this(composite, formToolkit, 0, false);
        }

        public ManifestSectionPart(Composite composite, FormToolkit formToolkit, int n, boolean bl) {
            super(composite, formToolkit, n | 0x100 | (bl ? 128 : 0));
        }

        public Composite createTableLayout(FormToolkit formToolkit, int n) {
            return SectionHelper.createTableLayout((Composite)this.getSection(), formToolkit, n);
        }

        public Label createLabel(Composite composite, FormToolkit formToolkit, String string, String string2) {
            return SectionHelper.createLabel(composite, formToolkit, string, string2);
        }

        public Text createLabelAndText(Composite composite, FormToolkit formToolkit, String string, String string2, String string3) {
            return SectionHelper.createLabelAndText(composite, formToolkit, string, string2, string3);
        }

        public FormText createFormText(Composite composite, FormToolkit formToolkit, boolean bl, String string, boolean bl2) {
            return SectionHelper.createFormText(composite, formToolkit, bl, string, bl2);
        }

        public void layoutChanged() {
            Section section = this.getSection();
            try {
                Method method = section.getClass().getDeclaredMethod("reflow", null);
                method.setAccessible(true);
                method.invoke((Object)section, new Object[0]);
            }
            catch (Exception exception) {
                AdtPlugin.log(exception, "Error when invoking Section.reflow", new Object[0]);
            }
            section.layout(true, true);
        }
    }
}

