/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.ui;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public abstract class EditableDialogCellEditor
extends DialogCellEditor {
    private Text text;
    private ModifyListener modifyListener;
    private boolean isSelection = false;
    private boolean isDeleteable = false;
    private boolean isSelectable = false;

    EditableDialogCellEditor(Composite composite) {
        super(composite);
    }

    protected Button createButton(Composite composite) {
        Button button = new Button(composite, 0x800400);
        button.setText("...");
        return button;
    }

    protected Control createContents(Composite composite) {
        this.text = new Text(composite, 4);
        this.text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                EditableDialogCellEditor.this.handleDefaultSelection(selectionEvent);
            }
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                EditableDialogCellEditor.this.keyReleaseOccured(keyEvent);
                if (EditableDialogCellEditor.this.getControl() == null || EditableDialogCellEditor.this.getControl().isDisposed()) {
                    return;
                }
                EditableDialogCellEditor.this.checkSelection();
                EditableDialogCellEditor.this.checkDeleteable();
                EditableDialogCellEditor.this.checkSelectable();
            }
        });
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 2 || traverseEvent.detail == 4) {
                    traverseEvent.doit = false;
                }
            }
        });
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                EditableDialogCellEditor.this.checkSelection();
                EditableDialogCellEditor.this.checkDeleteable();
                EditableDialogCellEditor.this.checkSelectable();
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                EditableDialogCellEditor.this.focusLost();
            }
        });
        this.text.setFont(composite.getFont());
        this.text.setBackground(composite.getBackground());
        this.text.setText("");
        this.text.addModifyListener(this.getModifyListener());
        return this.text;
    }

    private void checkDeleteable() {
        boolean bl = this.isDeleteable;
        this.isDeleteable = this.isDeleteEnabled();
        if (bl != this.isDeleteable) {
            this.fireEnablementChanged("delete");
        }
    }

    private void checkSelectable() {
        boolean bl = this.isSelectable;
        this.isSelectable = this.isSelectAllEnabled();
        if (bl != this.isSelectable) {
            this.fireEnablementChanged("selectall");
        }
    }

    private void checkSelection() {
        boolean bl = this.isSelection;
        boolean bl2 = this.isSelection = this.text.getSelectionCount() > 0;
        if (bl != this.isSelection) {
            this.fireEnablementChanged("copy");
            this.fireEnablementChanged("cut");
        }
    }

    protected void doSetFocus() {
        if (this.text != null) {
            this.text.selectAll();
            this.text.setFocus();
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }
    }

    protected void updateContents(Object object) {
        Assert.isTrue((this.text != null && (object == null || object instanceof String) ? 1 : 0) != 0);
        if (object != null) {
            this.text.removeModifyListener(this.getModifyListener());
            this.text.setText((String)object);
            this.text.addModifyListener(this.getModifyListener());
        }
    }

    protected Object doGetValue() {
        return this.text.getText();
    }

    protected void editOccured(ModifyEvent modifyEvent) {
        String string = this.text.getText();
        if (string == null) {
            string = "";
        }
        String string2 = string;
        boolean bl = this.isValueValid();
        boolean bl2 = this.isCorrect(string2);
        if (!bl2) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), string));
        }
        this.valueChanged(bl, bl2);
    }

    private ModifyListener getModifyListener() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    EditableDialogCellEditor.this.editOccured(modifyEvent);
                }
            };
        }
        return this.modifyListener;
    }

    protected void handleDefaultSelection(SelectionEvent selectionEvent) {
        this.fireApplyEditorValue();
        this.deactivate();
    }

    public boolean isCopyEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getSelectionCount() > 0;
    }

    public boolean isCutEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getSelectionCount() > 0;
    }

    public boolean isDeleteEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getSelectionCount() > 0 || this.text.getCaretPosition() < this.text.getCharCount();
    }

    public boolean isPasteEnabled() {
        return this.text != null && !this.text.isDisposed();
    }

    public boolean isSaveAllEnabled() {
        return this.text != null && !this.text.isDisposed();
    }

    public boolean isSelectAllEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getCharCount() > 0;
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\r') {
            if (this.text != null && !this.text.isDisposed() && (this.text.getStyle() & 2) != 0 && (keyEvent.stateMask & 0x40000) != 0) {
                super.keyReleaseOccured(keyEvent);
            }
            return;
        }
        super.keyReleaseOccured(keyEvent);
    }

    public void performCopy() {
        this.text.copy();
    }

    public void performCut() {
        this.text.cut();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performDelete() {
        if (this.text.getSelectionCount() > 0) {
            this.text.insert("");
        } else {
            int n = this.text.getCaretPosition();
            if (n < this.text.getCharCount()) {
                this.text.setSelection(n, n + 1);
                this.text.insert("");
            }
        }
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performPaste() {
        this.text.paste();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performSelectAll() {
        this.text.selectAll();
        this.checkSelection();
        this.checkDeleteable();
    }
}

