/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.manifest.pages;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.manifest.ManifestEditor;
import com.android.ide.eclipse.adt.internal.editors.manifest.descriptors.AndroidManifestDescriptors;
import com.android.ide.eclipse.adt.internal.editors.manifest.pages.OverviewExportPart;
import com.android.ide.eclipse.adt.internal.editors.manifest.pages.OverviewInfoPart;
import com.android.ide.eclipse.adt.internal.editors.manifest.pages.OverviewLinksPart;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.UiTreeBlock;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public final class OverviewPage
extends FormPage {
    static final String PAGE_ID = "overview_page";
    ManifestEditor mEditor;
    private OverviewInfoPart mOverviewPart;
    private OverviewLinksPart mOverviewLinkPart;
    private UiTreeBlock mTreeBlock;

    public OverviewPage(ManifestEditor manifestEditor) {
        super((FormEditor)manifestEditor, PAGE_ID, "Manifest");
        this.mEditor = manifestEditor;
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        super.createFormContent(iManagedForm);
        ScrolledForm scrolledForm = iManagedForm.getForm();
        scrolledForm.setText("Android Manifest");
        scrolledForm.setImage(AdtPlugin.getAndroidLogo());
        Composite composite = scrolledForm.getBody();
        FormToolkit formToolkit = iManagedForm.getToolkit();
        this.mOverviewPart = new OverviewInfoPart(composite, formToolkit, this.mEditor);
        this.mOverviewPart.getSection().setLayoutData((Object)new GridData(4, 128, true, false));
        iManagedForm.addPart((IFormPart)this.mOverviewPart);
        this.newManifestExtrasPart(iManagedForm);
        OverviewExportPart overviewExportPart = new OverviewExportPart(this, composite, formToolkit, this.mEditor);
        overviewExportPart.getSection().setLayoutData((Object)new GridData(4, 128, true, false));
        iManagedForm.addPart((IFormPart)overviewExportPart);
        this.mOverviewLinkPart = new OverviewLinksPart(composite, formToolkit, this.mEditor);
        this.mOverviewLinkPart.getSection().setLayoutData((Object)new GridData(4, 128, true, false));
        iManagedForm.addPart((IFormPart)this.mOverviewLinkPart);
    }

    private void newManifestExtrasPart(IManagedForm iManagedForm) {
        UiElementNode uiElementNode = this.mEditor.getUiRootNode();
        this.mTreeBlock = new UiTreeBlock(this.mEditor, uiElementNode, true, this.computeManifestExtraFilters(), "Manifest Extras", "Extra manifest elements");
        this.mTreeBlock.createContent(iManagedForm);
    }

    public void refreshUiApplicationNode() {
        if (this.mOverviewPart != null) {
            this.mOverviewPart.onSdkChanged();
        }
        if (this.mOverviewLinkPart != null) {
            this.mOverviewLinkPart.onSdkChanged();
        }
        if (this.mTreeBlock != null) {
            UiElementNode uiElementNode = this.mEditor.getUiRootNode();
            this.mTreeBlock.changeRootAndDescriptors(uiElementNode, this.computeManifestExtraFilters(), true);
        }
    }

    private ElementDescriptor[] computeManifestExtraFilters() {
        UiElementNode uiElementNode = this.mEditor.getUiRootNode();
        AndroidManifestDescriptors androidManifestDescriptors = this.mEditor.getManifestDescriptors();
        if (androidManifestDescriptors == null) {
            return null;
        }
        HashSet<ElementDescriptor> hashSet = new HashSet<ElementDescriptor>();
        hashSet.add(androidManifestDescriptors.getApplicationElement());
        hashSet.add(androidManifestDescriptors.getInstrumentationElement());
        hashSet.add(androidManifestDescriptors.getPermissionElement());
        hashSet.add(androidManifestDescriptors.getPermissionGroupElement());
        hashSet.add(androidManifestDescriptors.getPermissionTreeElement());
        hashSet.add(androidManifestDescriptors.getUsesPermissionElement());
        ArrayList<ElementDescriptor> arrayList = new ArrayList<ElementDescriptor>();
        ElementDescriptor[] elementDescriptorArray = uiElementNode.getDescriptor().getChildren();
        int n = elementDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ElementDescriptor elementDescriptor = elementDescriptorArray[n2];
            if (!hashSet.contains(elementDescriptor)) {
                arrayList.add(elementDescriptor);
            }
            ++n2;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new ElementDescriptor[arrayList.size()]);
    }
}

