/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.manifest.pages;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.manifest.ManifestEditor;
import com.android.ide.eclipse.adt.internal.editors.manifest.descriptors.AndroidManifestDescriptors;
import com.android.ide.eclipse.adt.internal.editors.ui.SectionHelper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

final class OverviewLinksPart
extends SectionHelper.ManifestSectionPart {
    private final ManifestEditor mEditor;
    private FormText mFormText;

    public OverviewLinksPart(Composite composite, FormToolkit formToolkit, ManifestEditor manifestEditor) {
        super(composite, formToolkit, 66, true);
        this.mEditor = manifestEditor;
        Section section = this.getSection();
        section.setText("Links");
        section.setDescription("The content of the Android Manifest is made up of three sections. You can also edit the XML directly.");
        Composite composite2 = this.createTableLayout(formToolkit, 2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("<form><li style=\"image\" value=\"app_img\"><a href=\"page:%1$s\">", "application_page"));
        stringBuffer.append("Application");
        stringBuffer.append("</a>");
        stringBuffer.append(": Activities, intent filters, providers, services and receivers.");
        stringBuffer.append("</li>");
        stringBuffer.append(String.format("<li style=\"image\" value=\"perm_img\"><a href=\"page:%1$s\">", "permission_page"));
        stringBuffer.append("Permission");
        stringBuffer.append("</a>");
        stringBuffer.append(": Permissions defined and permissions used.");
        stringBuffer.append("</li>");
        stringBuffer.append(String.format("<li style=\"image\" value=\"inst_img\"><a href=\"page:%1$s\">", "instrumentation_page"));
        stringBuffer.append("Instrumentation");
        stringBuffer.append("</a>");
        stringBuffer.append(": Instrumentation defined.");
        stringBuffer.append("</li>");
        stringBuffer.append(String.format("<li style=\"image\" value=\"android_img\"><a href=\"page:%1$s\">", "editor_part"));
        stringBuffer.append("XML Source");
        stringBuffer.append("</a>");
        stringBuffer.append(": Directly edit the AndroidManifest.xml file.");
        stringBuffer.append("</li>");
        stringBuffer.append("<li style=\"image\" value=\"android_img\">");
        stringBuffer.append("<a href=\"http://code.google.com/android/devel/bblocks-manifest.html\">Documentation</a>: Documentation from the Android SDK for AndroidManifest.xml.");
        stringBuffer.append("</li>");
        stringBuffer.append("</form>");
        this.mFormText = this.createFormText(composite2, formToolkit, true, stringBuffer.toString(), false);
        AndroidManifestDescriptors androidManifestDescriptors = manifestEditor.getManifestDescriptors();
        Image image = AdtPlugin.getAndroidLogo();
        this.mFormText.setImage("android_img", image);
        if (androidManifestDescriptors != null) {
            this.mFormText.setImage("app_img", this.getIcon(androidManifestDescriptors.getApplicationElement()));
            this.mFormText.setImage("perm_img", this.getIcon(androidManifestDescriptors.getPermissionElement()));
            this.mFormText.setImage("inst_img", this.getIcon(androidManifestDescriptors.getInstrumentationElement()));
        } else {
            this.mFormText.setImage("app_img", image);
            this.mFormText.setImage("perm_img", image);
            this.mFormText.setImage("inst_img", image);
        }
        this.mFormText.addHyperlinkListener(manifestEditor.createHyperlinkListener());
    }

    public void onSdkChanged() {
        AndroidManifestDescriptors androidManifestDescriptors = this.mEditor.getManifestDescriptors();
        if (androidManifestDescriptors != null) {
            this.mFormText.setImage("app_img", this.getIcon(androidManifestDescriptors.getApplicationElement()));
            this.mFormText.setImage("perm_img", this.getIcon(androidManifestDescriptors.getPermissionElement()));
            this.mFormText.setImage("inst_img", this.getIcon(androidManifestDescriptors.getInstrumentationElement()));
        }
    }

    private Image getIcon(ElementDescriptor elementDescriptor) {
        if (elementDescriptor != null && elementDescriptor.getIcon() != null) {
            return elementDescriptor.getIcon();
        }
        return AdtPlugin.getAndroidLogo();
    }
}

