/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.manifest.pages;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.manifest.ManifestEditor;
import com.android.ide.eclipse.adt.internal.editors.manifest.descriptors.AndroidManifestDescriptors;
import com.android.ide.eclipse.adt.internal.editors.manifest.pages.ApplicationAttributesPart;
import com.android.ide.eclipse.adt.internal.editors.manifest.pages.ApplicationToggle;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.UiTreeBlock;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public final class ApplicationPage
extends FormPage {
    public static final String PAGE_ID = "application_page";
    ManifestEditor mEditor;
    private ApplicationToggle mTooglePart;
    private ApplicationAttributesPart mAttrPart;
    private UiTreeBlock mTreeBlock;

    public ApplicationPage(ManifestEditor manifestEditor) {
        super((FormEditor)manifestEditor, PAGE_ID, "Application");
        this.mEditor = manifestEditor;
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        super.createFormContent(iManagedForm);
        ScrolledForm scrolledForm = iManagedForm.getForm();
        scrolledForm.setText("Android Manifest Application");
        scrolledForm.setImage(AdtPlugin.getAndroidLogo());
        UiElementNode uiElementNode = this.getUiApplicationNode();
        Composite composite = scrolledForm.getBody();
        FormToolkit formToolkit = iManagedForm.getToolkit();
        this.mTooglePart = new ApplicationToggle(composite, formToolkit, this.mEditor, uiElementNode);
        this.mTooglePart.getSection().setLayoutData((Object)new GridData(4, 128, true, false));
        iManagedForm.addPart((IFormPart)this.mTooglePart);
        this.mAttrPart = new ApplicationAttributesPart(composite, formToolkit, this.mEditor, uiElementNode);
        this.mAttrPart.getSection().setLayoutData((Object)new GridData(4, 128, true, false));
        iManagedForm.addPart((IFormPart)this.mAttrPart);
        this.mTreeBlock = new UiTreeBlock(this.mEditor, uiElementNode, false, null, "Application Nodes", "List of all elements in the application");
        this.mTreeBlock.createContent(iManagedForm);
    }

    private UiElementNode getUiApplicationNode() {
        AndroidManifestDescriptors androidManifestDescriptors = this.mEditor.getManifestDescriptors();
        if (androidManifestDescriptors != null) {
            ElementDescriptor elementDescriptor = androidManifestDescriptors.getApplicationElement();
            return this.mEditor.getUiRootNode().findUiChildNode(elementDescriptor.getXmlName());
        }
        return this.mEditor.getUiRootNode();
    }

    public void refreshUiApplicationNode() {
        UiElementNode uiElementNode = this.getUiApplicationNode();
        if (this.mTooglePart != null) {
            this.mTooglePart.setUiElementNode(uiElementNode);
        }
        if (this.mAttrPart != null) {
            this.mAttrPart.setUiElementNode(uiElementNode);
        }
        if (this.mTreeBlock != null) {
            this.mTreeBlock.changeRootAndDescriptors(uiElementNode, null, true);
        }
    }
}

