/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.parts;

import com.android.ide.eclipse.adt.internal.editors.layout.parts.UiElementEditPart;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiDocumentNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import org.eclipse.draw2d.AbstractBackground;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;

public class UiDocumentEditPart
extends UiElementEditPart {
    private Display mDisplay;
    private FreeformLayer mLayer;
    private ImageBackground mImage;
    private Label mChild = null;

    public UiDocumentEditPart(UiDocumentNode uiDocumentNode, Display display) {
        super(uiDocumentNode);
        this.mDisplay = display;
    }

    protected IFigure createFigure() {
        this.mLayer = new FreeformLayer();
        this.mLayer.setLayoutManager((LayoutManager)new FreeformLayout());
        this.mLayer.setOpaque(true);
        this.mLayer.setBackgroundColor(ColorConstants.lightGray);
        return this.mLayer;
    }

    protected void refreshVisuals() {
        UiElementNode uiElementNode = (UiElementNode)this.getModel();
        Object object = uiElementNode.getEditData();
        if (object instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)object;
            if (this.mImage == null || bufferedImage != this.mImage.getBufferedImage()) {
                this.mImage = new ImageBackground(bufferedImage, this.mDisplay);
            }
            this.mLayer.setBorder((Border)this.mImage);
            if (this.mChild != null && this.mChild.getParent() == this.mLayer) {
                this.mLayer.remove((IFigure)this.mChild);
            }
        } else if (object instanceof String) {
            this.mLayer.setBorder(null);
            if (this.mChild == null) {
                this.mChild = new Label();
            }
            this.mChild.setText((String)object);
            if (this.mChild != null && this.mChild.getParent() != this.mLayer) {
                this.mLayer.add((IFigure)this.mChild);
            }
            Rectangle rectangle = this.mChild.getTextBounds();
            rectangle.y = 0;
            rectangle.x = 0;
            this.mLayer.setConstraint((IFigure)this.mChild, (Object)rectangle);
        }
        this.refreshChildrenVisuals();
    }

    protected void hideSelection() {
    }

    protected void showSelection() {
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installLayoutEditPolicy(this);
    }

    public EditPart getTargetEditPart(Request request) {
        if (request != null && request.getType() == "create child") {
            Object object;
            if (request instanceof DropRequest) {
                Object object2;
                object = ((DropRequest)request).getLocation().getCopy();
                UiElementNode uiElementNode = this.getUiNode();
                if (uiElementNode instanceof UiDocumentNode && (object2 = uiElementNode.getEditData()) instanceof BufferedImage) {
                    BufferedImage bufferedImage = (BufferedImage)object2;
                    int n = bufferedImage.getWidth();
                    int n2 = bufferedImage.getHeight();
                    if (object.x > n || object.y > n2) {
                        return null;
                    }
                }
            }
            if (this.getChildren().size() > 0 && (object = this.getChildren().get(0)) instanceof EditPart) {
                return ((EditPart)object).getTargetEditPart(request);
            }
        }
        return super.getTargetEditPart(request);
    }

    static final class ImageBackground
    extends AbstractBackground {
        private BufferedImage mBufferedImage;
        private Image mImage;

        ImageBackground() {
        }

        ImageBackground(BufferedImage bufferedImage, Display display) {
            this.setImage(bufferedImage, display);
        }

        public void paintBackground(IFigure iFigure, Graphics graphics, Insets insets) {
            if (this.mImage != null) {
                Rectangle rectangle = ImageBackground.getPaintRectangle((IFigure)iFigure, (Insets)insets);
                graphics.drawImage(this.mImage, rectangle.x, rectangle.y);
            }
        }

        void setImage(BufferedImage bufferedImage, Display display) {
            if (bufferedImage != null) {
                int[] nArray = ((DataBufferInt)bufferedImage.getData().getDataBuffer()).getData();
                ImageData imageData = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), 32, new PaletteData(0xFF0000, 65280, 255));
                imageData.setPixels(0, 0, nArray.length, nArray, 0);
                this.mImage = new Image((Device)display, imageData);
            } else {
                this.mImage = null;
            }
        }

        BufferedImage getBufferedImage() {
            return this.mBufferedImage;
        }
    }
}

