/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout;

import com.android.ide.eclipse.adt.internal.editors.AndroidEditor;
import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.editors.layout.AbstractGraphicalLayoutEditor;
import com.android.ide.eclipse.adt.internal.editors.layout.GraphicalLayoutEditor;
import com.android.ide.eclipse.adt.internal.editors.layout.parts.UiDocumentTreeEditPart;
import com.android.ide.eclipse.adt.internal.editors.layout.parts.UiElementTreeEditPart;
import com.android.ide.eclipse.adt.internal.editors.layout.parts.UiElementTreeEditPartFactory;
import com.android.ide.eclipse.adt.internal.editors.layout.parts.UiLayoutTreeEditPart;
import com.android.ide.eclipse.adt.internal.editors.layout.parts.UiViewTreeEditPart;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.CopyCutAction;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.PasteAction;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.UiActions;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiDocumentNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.ui.EclipseUiHelper;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UiContentOutlinePage
extends ContentOutlinePage {
    private AbstractGraphicalLayoutEditor mEditor;
    private Action mAddAction;
    private Action mDeleteAction;
    private Action mUpAction;
    private Action mDownAction;
    private UiOutlineActions mUiActions = new UiOutlineActions();

    public UiContentOutlinePage(AbstractGraphicalLayoutEditor abstractGraphicalLayoutEditor, final EditPartViewer editPartViewer) {
        super(editPartViewer);
        this.mEditor = abstractGraphicalLayoutEditor;
        IconFactory iconFactory = IconFactory.getInstance();
        this.mAddAction = new Action("Add..."){

            public void run() {
                List list = UiContentOutlinePage.this.getModelSelections();
                UiElementNode uiElementNode = list != null && list.size() > 0 ? (UiElementNode)list.get(0) : null;
                UiContentOutlinePage.this.mUiActions.doAdd(uiElementNode, editPartViewer.getControl().getShell());
            }
        };
        this.mAddAction.setToolTipText("Adds a new element.");
        this.mAddAction.setImageDescriptor(iconFactory.getImageDescriptor("add"));
        this.mDeleteAction = new Action("Remove..."){

            public void run() {
                List list = UiContentOutlinePage.this.getModelSelections();
                UiContentOutlinePage.this.mUiActions.doRemove(list, editPartViewer.getControl().getShell());
            }
        };
        this.mDeleteAction.setToolTipText("Removes an existing selected element.");
        this.mDeleteAction.setImageDescriptor(iconFactory.getImageDescriptor("delete"));
        this.mUpAction = new Action("Up"){

            public void run() {
                List list = UiContentOutlinePage.this.getModelSelections();
                UiContentOutlinePage.this.mUiActions.doUp(list);
            }
        };
        this.mUpAction.setToolTipText("Moves the selected element up");
        this.mUpAction.setImageDescriptor(iconFactory.getImageDescriptor("up"));
        this.mDownAction = new Action("Down"){

            public void run() {
                List list = UiContentOutlinePage.this.getModelSelections();
                UiContentOutlinePage.this.mUiActions.doDown(list);
            }
        };
        this.mDownAction.setToolTipText("Moves the selected element down");
        this.mDownAction.setImageDescriptor(iconFactory.getImageDescriptor("down"));
        this.mAddAction.setEnabled(false);
        this.mDeleteAction.setEnabled(false);
        this.mUpAction.setEnabled(false);
        this.mDownAction.setEnabled(false);
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ISelection iSelection = selectionChangedEvent.getSelection();
                if (iSelection instanceof StructuredSelection) {
                    StructuredSelection structuredSelection = (StructuredSelection)iSelection;
                    if (structuredSelection.size() == 1 && structuredSelection.getFirstElement() instanceof UiDocumentTreeEditPart) {
                        UiContentOutlinePage.this.mDeleteAction.setEnabled(false);
                        UiContentOutlinePage.this.mUpAction.setEnabled(false);
                        UiContentOutlinePage.this.mDownAction.setEnabled(false);
                    } else {
                        UiContentOutlinePage.this.mDeleteAction.setEnabled(true);
                        UiContentOutlinePage.this.mUpAction.setEnabled(true);
                        UiContentOutlinePage.this.mDownAction.setEnabled(true);
                    }
                    UiContentOutlinePage.this.mAddAction.setEnabled(true);
                }
            }
        });
    }

    public void createControl(Composite composite) {
        this.getViewer().createControl(composite);
        this.getViewer().setEditPartFactory((EditPartFactory)new UiElementTreeEditPartFactory());
        this.setupOutline();
        this.setupContextMenu();
        this.setupTooltip();
        this.setupDoubleClick();
    }

    public void setActionBars(IActionBars iActionBars) {
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        iToolBarManager.add((IAction)this.mAddAction);
        iToolBarManager.add((IAction)this.mDeleteAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.mUpAction);
        iToolBarManager.add((IAction)this.mDownAction);
        IMenuManager iMenuManager = iActionBars.getMenuManager();
        iMenuManager.add((IAction)this.mAddAction);
        iMenuManager.add((IAction)this.mDeleteAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.mUpAction);
        iMenuManager.add((IAction)this.mDownAction);
    }

    public void dispose() {
        this.breakConnectionWithEditor();
        super.dispose();
    }

    public Control getControl() {
        return this.getViewer().getControl();
    }

    void setNewEditor(GraphicalLayoutEditor graphicalLayoutEditor) {
        this.mEditor = graphicalLayoutEditor;
        this.setupOutline();
    }

    void breakConnectionWithEditor() {
        this.mEditor.getSelectionSynchronizer().removeViewer(this.getViewer());
    }

    private void setupOutline() {
        this.getViewer().setEditDomain((EditDomain)this.mEditor.getEditDomain());
        this.mEditor.getSelectionSynchronizer().addViewer(this.getViewer());
        this.getViewer().setContents((Object)this.mEditor.getModel());
    }

    private void setupContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                List list = UiContentOutlinePage.this.getModelSelections();
                if (list != null) {
                    UiContentOutlinePage.this.doCreateMenuAction(iMenuManager, list);
                    return;
                }
                UiContentOutlinePage.this.doCreateMenuAction(iMenuManager, null);
            }
        });
        Control control = this.getControl();
        Menu menu = menuManager.createContextMenu(control);
        control.setMenu(menu);
    }

    private void doCreateMenuAction(IMenuManager iMenuManager, List<UiElementNode> list) {
        if (list != null) {
            boolean bl = false;
            for (UiElementNode uiElementNode : list) {
                if (uiElementNode.getXmlNode() == null) continue;
                bl = true;
                break;
            }
            if (bl) {
                UiElementNode uiElementNode;
                iMenuManager.add((IAction)new CopyCutAction((AndroidEditor)this.mEditor.getLayoutEditor(), this.mEditor.getClipboard(), null, list, true));
                iMenuManager.add((IAction)new CopyCutAction((AndroidEditor)this.mEditor.getLayoutEditor(), this.mEditor.getClipboard(), null, list, false));
                if (list.size() <= 1 && ((uiElementNode = list.get(0).getUiRoot()).getDescriptor().hasChildren() || !(uiElementNode.getUiParent() instanceof UiDocumentNode))) {
                    iMenuManager.add((IAction)new PasteAction(this.mEditor.getLayoutEditor(), this.mEditor.getClipboard(), list.get(0)));
                }
                iMenuManager.add((IContributionItem)new Separator());
            }
        }
        if (list == null || list.size() <= 1) {
            iMenuManager.add((IAction)this.mAddAction);
        }
        if (list != null) {
            iMenuManager.add((IAction)this.mDeleteAction);
            iMenuManager.add((IContributionItem)new Separator());
            iMenuManager.add((IAction)this.mUpAction);
            iMenuManager.add((IAction)this.mDownAction);
        }
        if (list != null && list.size() == 1) {
            iMenuManager.add((IContributionItem)new Separator());
            Action action = new Action("Properties"){

                public void run() {
                    EclipseUiHelper.showView("org.eclipse.ui.views.PropertySheet", true);
                }
            };
            action.setToolTipText("Displays properties of the selected element.");
            iMenuManager.add((IAction)action);
        }
    }

    public void reloadModel() {
        List<UiElementNode> list = null;
        try {
            list = this.getModelSelections();
            this.getViewer().setContents((Object)this.mEditor.getModel());
        }
        finally {
            if (list != null) {
                this.setModelSelection(list.get(0));
            }
        }
    }

    private List<UiElementTreeEditPart> getViewerSelections() {
        StructuredSelection structuredSelection;
        ISelection iSelection = this.getSelection();
        if (iSelection instanceof StructuredSelection && (structuredSelection = (StructuredSelection)iSelection).size() > 0) {
            ArrayList<UiElementTreeEditPart> arrayList = new ArrayList<UiElementTreeEditPart>();
            for (Object e : structuredSelection) {
                if (!(e instanceof UiElementTreeEditPart)) continue;
                arrayList.add((UiElementTreeEditPart)((Object)e));
            }
            return arrayList.size() > 0 ? arrayList : null;
        }
        return null;
    }

    private List<UiElementNode> getModelSelections() {
        List<UiElementTreeEditPart> list = this.getViewerSelections();
        if (list != null) {
            ArrayList<UiElementNode> arrayList = new ArrayList<UiElementNode>();
            for (UiElementTreeEditPart uiElementTreeEditPart : list) {
                if (!(uiElementTreeEditPart instanceof UiViewTreeEditPart) && !(uiElementTreeEditPart instanceof UiLayoutTreeEditPart)) continue;
                arrayList.add((UiElementNode)uiElementTreeEditPart.getModel());
            }
            return arrayList.size() > 0 ? arrayList : null;
        }
        return null;
    }

    private void setViewerSelection(UiElementTreeEditPart uiElementTreeEditPart) {
        if (uiElementTreeEditPart != null && !(uiElementTreeEditPart instanceof UiDocumentTreeEditPart)) {
            LinkedList<UiElementTreeEditPart> linkedList = new LinkedList<UiElementTreeEditPart>();
            UiElementTreeEditPart uiElementTreeEditPart2 = uiElementTreeEditPart;
            while (!(uiElementTreeEditPart2 instanceof UiDocumentTreeEditPart)) {
                linkedList.add(0, uiElementTreeEditPart2);
                uiElementTreeEditPart2 = (UiElementTreeEditPart)uiElementTreeEditPart2.getParent();
            }
            this.setSelection((ISelection)new TreeSelection(new TreePath(linkedList.toArray())));
        }
    }

    private void setModelSelection(UiElementNode uiElementNode) {
        UiElementTreeEditPart uiElementTreeEditPart;
        if (uiElementNode != null && (uiElementTreeEditPart = this.findPartForModel((UiElementTreeEditPart)this.getViewer().getContents(), uiElementNode)) != null) {
            this.setViewerSelection(uiElementTreeEditPart);
            this.getViewer().reveal((EditPart)uiElementTreeEditPart);
        }
    }

    private UiElementTreeEditPart findPartForModel(UiElementTreeEditPart uiElementTreeEditPart, UiElementNode uiElementNode) {
        if (uiElementTreeEditPart.getModel() == uiElementNode) {
            return uiElementTreeEditPart;
        }
        for (Object e : uiElementTreeEditPart.getChildren()) {
            UiElementTreeEditPart uiElementTreeEditPart2;
            if (!(e instanceof UiElementTreeEditPart) || (uiElementTreeEditPart2 = this.findPartForModel((UiElementTreeEditPart)((Object)e), uiElementNode)) == null) continue;
            return uiElementTreeEditPart2;
        }
        return null;
    }

    private void setupTooltip() {
        final Tree tree = (Tree)this.getControl();
        Listener listener = new Listener(){
            Shell tip = null;
            Label label = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 12: {
                        if (this.tip == null) break;
                        this.tip.dispose();
                        this.tip = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        Object object;
                        Object object2;
                        if (this.tip != null) {
                            this.tip.dispose();
                            this.tip = null;
                            this.label = null;
                        }
                        String string = null;
                        TreeItem treeItem = tree.getItem(new Point(event.x, event.y));
                        if (treeItem != null) {
                            object2 = treeItem.getData();
                            if (object2 instanceof UiElementTreeEditPart && (object = ((UiElementTreeEditPart)((Object)object2)).getModel()) instanceof UiElementNode) {
                                string = ((UiElementNode)object).getDescriptor().getTooltip();
                            }
                            string = string == null ? treeItem.getText() : String.valueOf(treeItem.getText()) + ":\r" + string;
                        }
                        if (string == null) break;
                        object2 = tree.getShell();
                        object = tree.getDisplay();
                        this.tip = new Shell((Shell)object2, 540676);
                        this.tip.setBackground(object.getSystemColor(29));
                        FillLayout fillLayout = new FillLayout();
                        fillLayout.marginWidth = 2;
                        this.tip.setLayout((Layout)fillLayout);
                        this.label = new Label((Composite)this.tip, 0);
                        this.label.setForeground(object.getSystemColor(28));
                        this.label.setBackground(object.getSystemColor(29));
                        this.label.setData("_TABLEITEM", (Object)treeItem);
                        this.label.setText(string);
                        this.label.addListener(7, (Listener)this);
                        this.label.addListener(3, (Listener)this);
                        Point point = this.tip.computeSize(-1, -1);
                        Rectangle rectangle = treeItem.getBounds(0);
                        Point point2 = tree.toDisplay(rectangle.x, rectangle.y);
                        this.tip.setBounds(point2.x, point2.y, point.x, point.y);
                        this.tip.setVisible(true);
                    }
                }
            }
        };
        tree.addListener(12, listener);
        tree.addListener(1, listener);
        tree.addListener(5, listener);
        tree.addListener(32, listener);
    }

    private void setupDoubleClick() {
        Tree tree = (Tree)this.getControl();
        tree.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                EclipseUiHelper.showView("org.eclipse.ui.views.PropertySheet", true);
            }
        });
    }

    private class UiOutlineActions
    extends UiActions {
        private UiOutlineActions() {
        }

        protected UiDocumentNode getRootNode() {
            return UiContentOutlinePage.this.mEditor.getModel();
        }

        protected void selectUiNode(UiElementNode uiElementNode) {
            UiContentOutlinePage.this.setModelSelection(uiElementNode);
        }

        public void commitPendingXmlChanges() {
        }
    }
}

