/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.AndroidEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DocumentDescriptor;
import com.android.ide.eclipse.adt.internal.editors.layout.AbstractGraphicalLayoutEditor;
import com.android.ide.eclipse.adt.internal.editors.layout.GraphicalLayoutEditor;
import com.android.ide.eclipse.adt.internal.editors.layout.UiContentOutlinePage;
import com.android.ide.eclipse.adt.internal.editors.layout.UiPropertySheetPage;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.UiActions;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiDocumentNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceFolder;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceManager;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.ide.eclipse.adt.internal.ui.EclipseUiHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IShowEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.w3c.dom.Document;

public class LayoutEditor
extends AndroidEditor
implements IShowEditorInput,
IPartListener {
    public static final String ID = "com.android.ide.eclipse.editors.layout.LayoutEditor";
    private UiDocumentNode mUiRootNode;
    private AbstractGraphicalLayoutEditor mGraphicalEditor;
    private int mGraphicalEditorIndex;
    private UiContentOutlinePage mOutline;
    private UiPropertySheetPage mPropertyPage;
    private UiEditorActions mUiEditorActions;

    public UiDocumentNode getUiRootNode() {
        return this.mUiRootNode;
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        super.doSave(iProgressMonitor);
        if (this.mGraphicalEditor != null) {
            this.mGraphicalEditor.doSave(iProgressMonitor);
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void createFormPages() {
        try {
            if (System.getenv("ANDROID_DISABLE_LAYOUT") == null) {
                if (this.mGraphicalEditor == null) {
                    this.mGraphicalEditor = new GraphicalLayoutEditor(this);
                    this.mGraphicalEditorIndex = this.addPage((IEditorPart)this.mGraphicalEditor, this.getEditorInput());
                    this.setPageText(this.mGraphicalEditorIndex, this.mGraphicalEditor.getTitle());
                } else {
                    this.mGraphicalEditor.reloadEditor();
                }
                IEditorInput iEditorInput = this.getEditorInput();
                if (iEditorInput instanceof FileEditorInput) {
                    FileEditorInput fileEditorInput = (FileEditorInput)iEditorInput;
                    ResourceFolder resourceFolder = ResourceManager.getInstance().getResourceFolder(fileEditorInput.getFile());
                    if (resourceFolder != null) {
                        this.mGraphicalEditor.editNewFile(resourceFolder.getConfiguration());
                    }
                }
                this.getSite().getPage().addPartListener((IPartListener)this);
            }
        }
        catch (PartInitException partInitException) {
            AdtPlugin.log(partInitException, "Error creating nested page", new Object[0]);
        }
    }

    protected void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        this.handleNewInput(iEditorInput);
    }

    protected void setInputWithNotify(IEditorInput iEditorInput) {
        super.setInputWithNotify(iEditorInput);
        this.handleNewInput(iEditorInput);
    }

    public void showEditorInput(IEditorInput iEditorInput) {
        this.doSave((IProgressMonitor)new NullProgressMonitor());
        int n = this.getActivePage();
        int n2 = this.getPageCount();
        int n3 = n2 - 1;
        while (n3 > this.mGraphicalEditorIndex) {
            this.removePage(n3);
            --n3;
        }
        n3 = this.mGraphicalEditorIndex - 1;
        while (n3 >= 0) {
            this.removePage(n3);
            --n3;
        }
        this.setInputWithNotify(iEditorInput);
        this.createAndroidPages();
        this.selectDefaultPage(Integer.toString(n));
        if (this.mOutline != null && this.mGraphicalEditor != null) {
            this.mOutline.reloadModel();
        }
    }

    protected void xmlModelChanged(Document document) {
        this.initUiRootNode(false);
        this.mUiRootNode.loadFromXmlNode(document);
        super.xmlModelChanged(document);
        if (this.mGraphicalEditor != null) {
            this.mGraphicalEditor.onXmlModelChanged();
        }
        if (this.mOutline != null) {
            this.mOutline.reloadModel();
        }
    }

    public Object getAdapter(Class clazz) {
        if (IContentOutlinePage.class == clazz && this.mGraphicalEditor != null) {
            if (this.mOutline == null) {
                this.mOutline = new UiContentOutlinePage(this.mGraphicalEditor, (EditPartViewer)new TreeViewer());
            }
            return this.mOutline;
        }
        if (IPropertySheetPage.class == clazz && this.mGraphicalEditor != null) {
            if (this.mPropertyPage == null) {
                this.mPropertyPage = new UiPropertySheetPage();
            }
            return this.mPropertyPage;
        }
        return super.getAdapter(clazz);
    }

    protected void pageChange(int n) {
        super.pageChange(n);
        if (this.mGraphicalEditor != null) {
            if (n == this.mGraphicalEditorIndex) {
                this.mGraphicalEditor.activated();
            } else {
                this.mGraphicalEditor.deactivated();
            }
        }
    }

    public void partActivated(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart == this && this.mGraphicalEditor != null) {
            if (this.getActivePage() == this.mGraphicalEditorIndex) {
                this.mGraphicalEditor.activated();
            } else {
                this.mGraphicalEditor.deactivated();
            }
        }
    }

    public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
        this.partActivated(iWorkbenchPart);
    }

    public void partClosed(IWorkbenchPart iWorkbenchPart) {
    }

    public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart == this && this.mGraphicalEditor != null && this.getActivePage() == this.mGraphicalEditorIndex) {
            this.mGraphicalEditor.deactivated();
        }
    }

    public void partOpened(IWorkbenchPart iWorkbenchPart) {
        EclipseUiHelper.showView("org.eclipse.ui.views.ContentOutline", false);
        EclipseUiHelper.showView("org.eclipse.ui.views.PropertySheet", false);
    }

    public UiEditorActions getUiEditorActions() {
        if (this.mUiEditorActions == null) {
            this.mUiEditorActions = new UiEditorActions();
        }
        return this.mUiEditorActions;
    }

    boolean isGraphicalEditorActive() {
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        IWorkbenchPage iWorkbenchPage = iWorkbenchPartSite.getPage();
        if (iWorkbenchPage.isPartVisible((IWorkbenchPart)this) && iWorkbenchPage.getActiveEditor() == this) {
            return this.mGraphicalEditorIndex == this.getActivePage();
        }
        return false;
    }

    protected void initUiRootNode(boolean bl) {
        if (this.mUiRootNode == null || bl) {
            AndroidTargetData androidTargetData = this.getTargetData();
            Document document = null;
            if (this.mUiRootNode != null) {
                document = this.mUiRootNode.getXmlDocument();
            }
            DocumentDescriptor documentDescriptor = androidTargetData == null ? new DocumentDescriptor("temp", null) : androidTargetData.getLayoutDescriptors().getDescriptor();
            this.mUiRootNode = (UiDocumentNode)documentDescriptor.createUiNode();
            this.mUiRootNode.setEditor(this);
            this.onDescriptorsChanged(document);
        }
    }

    private void onDescriptorsChanged(Document document) {
        if (document != null) {
            this.mUiRootNode.loadFromXmlNode(document);
        } else {
            this.mUiRootNode.reloadFromXmlNode(this.mUiRootNode.getXmlDocument());
        }
        if (this.mOutline != null) {
            this.mOutline.reloadModel();
        }
        if (this.mGraphicalEditor != null) {
            this.mGraphicalEditor.reloadEditor();
            this.mGraphicalEditor.reloadPalette();
            this.mGraphicalEditor.recomputeLayout();
        }
    }

    private void handleNewInput(IEditorInput iEditorInput) {
        if (iEditorInput instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)iEditorInput;
            IFile iFile = fileEditorInput.getFile();
            this.setPartName(String.format("%1$s", iFile.getName()));
        }
    }

    public class UiEditorActions
    extends UiActions {
        protected UiDocumentNode getRootNode() {
            return LayoutEditor.this.mUiRootNode;
        }

        protected void selectUiNode(UiElementNode uiElementNode) {
            LayoutEditor.this.mGraphicalEditor.selectModel(uiElementNode);
        }

        public void commitPendingXmlChanges() {
        }
    }
}

