/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.sdklib.SdkConstants;
import java.util.HashMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class IconFactory {
    public static final int COLOR_RED = 4;
    public static final int COLOR_GREEN = 6;
    public static final int COLOR_BLUE = 10;
    public static final int COLOR_DEFAULT = 2;
    public static final int SHAPE_CIRCLE = 67;
    public static final int SHAPE_RECT = 82;
    public static final int SHAPE_DEFAULT = 67;
    private static IconFactory sInstance;
    private HashMap<String, Image> mIconMap = new HashMap();
    private HashMap<String, ImageDescriptor> mImageDescMap = new HashMap();

    private IconFactory() {
    }

    public static synchronized IconFactory getInstance() {
        if (sInstance == null) {
            sInstance = new IconFactory();
        }
        return sInstance;
    }

    public void Dispose() {
        for (Image image : this.mIconMap.values()) {
            if (image == null) continue;
            image.dispose();
        }
        this.mIconMap.clear();
    }

    public Image getIcon(String string) {
        return this.getIcon(string, 2, 67);
    }

    public Image getIcon(String string, int n, int n2) {
        String string2 = String.valueOf(Character.toString((char)n2)) + Integer.toString(n) + string;
        Image image = this.mIconMap.get(string2);
        if (image == null && !this.mIconMap.containsKey(string2)) {
            ImageDescriptor imageDescriptor = this.getImageDescriptor(string, n, n2);
            if (imageDescriptor != null) {
                image = imageDescriptor.createImage();
            }
            this.mIconMap.put(string2, image);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String string) {
        return this.getImageDescriptor(string, 2, 67);
    }

    public ImageDescriptor getImageDescriptor(String string, int n, int n2) {
        String string2 = String.valueOf(Character.toString((char)n2)) + Integer.toString(n) + string;
        ImageDescriptor imageDescriptor = this.mImageDescMap.get(string2);
        if (imageDescriptor == null && !this.mImageDescMap.containsKey(string2)) {
            imageDescriptor = AdtPlugin.imageDescriptorFromPlugin((String)"com.android.ide.eclipse.adt", (String)String.format("/icons/%1$s.png", string));
            if (imageDescriptor == null) {
                imageDescriptor = new LetterImageDescriptor(string.charAt(0), n, n2);
            }
            this.mImageDescMap.put(string2, imageDescriptor);
        }
        return imageDescriptor;
    }

    private static class LetterImageDescriptor
    extends ImageDescriptor {
        private final char mLetter;
        private final int mColor;
        private final int mShape;

        public LetterImageDescriptor(char c, int n, int n2) {
            this.mLetter = c;
            this.mColor = n;
            this.mShape = n2;
        }

        public ImageData getImageData() {
            Display display = Display.getCurrent();
            if (display == null) {
                return null;
            }
            Image image = new Image((Device)display, 15, 15);
            image.setBackground(display.getSystemColor(1));
            GC gC = new GC((Drawable)image);
            gC.setAdvanced(true);
            gC.setAntialias(1);
            gC.setTextAntialias(1);
            gC.setBackground(display.getSystemColor(1));
            if (this.mShape == 67) {
                gC.fillOval(0, 0, 14, 14);
            } else if (this.mShape == 82) {
                gC.fillRoundRectangle(0, 0, 14, 14, 4, 4);
            }
            gC.setForeground(display.getSystemColor(2));
            gC.setLineWidth(1);
            if (this.mShape == 67) {
                gC.drawOval(0, 0, 14, 14);
            } else if (this.mShape == 82) {
                gC.drawRoundRectangle(0, 0, 14, 14, 4, 4);
            }
            Font font = display.getSystemFont();
            FontData[] fontDataArray = font.getFontData();
            fontDataArray[0].setStyle(1);
            fontDataArray[0].setHeight((int)(864.0 / (double)display.getDPI().y));
            font = new Font((Device)display, fontDataArray);
            gC.setFont(font);
            gC.setForeground(display.getSystemColor(this.mColor));
            int n = 0;
            int n2 = 0;
            if (SdkConstants.CURRENT_PLATFORM == 2) {
                n = 1;
                n2 = -1;
            }
            String string = Character.toString(this.mLetter).toUpperCase();
            Point point = gC.textExtent(string);
            int n3 = (15 + n - point.x) / 2;
            int n4 = (15 + n2 - point.y) / 2;
            gC.drawText(string, n3, n4, true);
            font.dispose();
            gC.dispose();
            ImageData imageData = image.getImageData();
            image.dispose();
            return imageData;
        }
    }
}

