/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.build;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.build.BaseBuilder;
import com.android.ide.eclipse.adt.internal.build.Messages;
import com.android.ide.eclipse.adt.internal.build.PreCompilerBuilder;
import com.android.ide.eclipse.adt.internal.project.AndroidManifestParser;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PreCompilerDeltaVisitor
extends BaseBuilder.BaseDeltaVisitor
implements IResourceDeltaVisitor {
    private boolean mCompileResources = false;
    private boolean mForceAidlCompile = false;
    private final ArrayList<PreCompilerBuilder.AidlData> mAidlToCompile = new ArrayList();
    private final ArrayList<PreCompilerBuilder.AidlData> mAidlToRemove = new ArrayList();
    private boolean mCheckedManifestXml = false;
    private String mJavaPackage = null;
    private String mMinSdkVersion = null;
    private boolean mInRes = false;
    private IFolder mSourceFolder = null;
    private ArrayList<IPath> mSourceFolders;
    private boolean mIsGenSourceFolder = false;
    private IWorkspaceRoot mRoot;

    public PreCompilerDeltaVisitor(BaseBuilder baseBuilder, ArrayList<IPath> arrayList) {
        super(baseBuilder);
        this.mSourceFolders = arrayList;
        this.mRoot = ResourcesPlugin.getWorkspace().getRoot();
    }

    public boolean getCompileResources() {
        return this.mCompileResources;
    }

    public boolean getForceAidlCompile() {
        return this.mForceAidlCompile;
    }

    public ArrayList<PreCompilerBuilder.AidlData> getAidlToCompile() {
        return this.mAidlToCompile;
    }

    public ArrayList<PreCompilerBuilder.AidlData> getAidlToRemove() {
        return this.mAidlToRemove;
    }

    public boolean getCheckedManifestXml() {
        return this.mCheckedManifestXml;
    }

    public String getManifestPackage() {
        return this.mJavaPackage;
    }

    public String getMinSdkVersion() {
        return this.mMinSdkVersion;
    }

    public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
        IResource iResource = iResourceDelta.getResource();
        IPath iPath = iResource.getFullPath();
        String[] stringArray = iPath.segments();
        if (stringArray.length == 1) {
            return true;
        }
        if (stringArray.length == 2) {
            this.mInRes = false;
            this.mSourceFolder = null;
            if ("res".equalsIgnoreCase(stringArray[1])) {
                this.mInRes = true;
                this.mSourceFolder = null;
                return true;
            }
            if ("AndroidManifest.xml".equalsIgnoreCase(stringArray[1])) {
                if (iResourceDelta.getKind() != 2) {
                    AndroidManifestParser androidManifestParser = BaseProjectHelper.parseManifestForError((IFile)iResource, this);
                    if (androidManifestParser != null) {
                        this.mJavaPackage = androidManifestParser.getPackage();
                        this.mMinSdkVersion = androidManifestParser.getApiLevelRequirement();
                    }
                    this.mCheckedManifestXml = true;
                }
                this.mCompileResources = true;
                return false;
            }
        }
        if (this.mSourceFolder != null) {
            if (iResource.getType() == 2) {
                return true;
            }
            if (iResource.getType() != 1) {
                return false;
            }
            IFile iFile = (IFile)iResource;
            int n = iResourceDelta.getKind();
            if (this.mIsGenSourceFolder) {
                String string;
                boolean bl = false;
                String string2 = iResource.getName();
                if ("R.java".equals(string2) || "Manifest.java".equals(string2)) {
                    this.mCompileResources = true;
                    bl = true;
                } else {
                    string = string2.replaceAll("\\.java$", ".aidl");
                    for (IPath iPath2 : this.mSourceFolders) {
                        IFile iFile2;
                        IFolder iFolder;
                        if (iPath2.equals((Object)this.mSourceFolder.getFullPath()) || (iFolder = this.getFolder(iPath2)) == null || (iFile2 = this.findFile(iFolder, stringArray, 2, string)) == null) continue;
                        this.mAidlToCompile.add(new PreCompilerBuilder.AidlData(iFolder, iFile2));
                        bl = true;
                        break;
                    }
                }
                if (bl) {
                    if (n == 2) {
                        string = String.format(Messages.s_Removed_Recreating_s, string2);
                        AdtPlugin.printErrorToConsole(this.mBuilder.getProject(), new Object[]{string});
                    } else if (n == 4) {
                        string = String.format(Messages.s_Modified_Manually_Recreating_s, string2);
                        AdtPlugin.printErrorToConsole(this.mBuilder.getProject(), new Object[]{string});
                    }
                }
            } else {
                String string = iResource.getFileExtension();
                if ("aidl".equalsIgnoreCase(string)) {
                    AidlType aidlType = this.getAidlType(iFile);
                    if (aidlType == AidlType.INTERFACE) {
                        if (n == 2) {
                            this.mAidlToRemove.add(new PreCompilerBuilder.AidlData(this.mSourceFolder, iFile));
                        } else if (!this.mForceAidlCompile) {
                            this.mAidlToCompile.add(new PreCompilerBuilder.AidlData(this.mSourceFolder, iFile));
                        }
                    } else {
                        this.mForceAidlCompile = true;
                        this.mAidlToCompile.clear();
                    }
                }
            }
            return false;
        }
        if (this.mInRes) {
            if (iResource.getType() == 2) {
                return true;
            }
            String string = iResource.getFileExtension();
            int n = iResourceDelta.getKind();
            String string3 = iResource.getProjectRelativePath().toString();
            String string4 = null;
            switch (n) {
                case 4: {
                    string4 = String.format(Messages.s_Modified_Recreating_s, string3, "R.java");
                    break;
                }
                case 1: {
                    string4 = String.format(Messages.Added_s_s_Needs_Updating, string3, "R.java");
                    break;
                }
                case 2: {
                    string4 = String.format(Messages.s_Removed_s_Needs_Updating, string3, "R.java");
                }
            }
            if (string4 != null) {
                AdtPlugin.printBuildToConsole(2, this.mBuilder.getProject(), string4);
            }
            if ("xml".equalsIgnoreCase(string)) {
                if (n != 2) {
                    this.mBuilder.checkXML(iResource, this);
                }
                this.mCompileResources = true;
                return false;
            }
            if (n == 1 || n == 2) {
                this.mCompileResources = true;
                return false;
            }
        } else if (iResource instanceof IFolder) {
            for (IPath iPath3 : this.mSourceFolders) {
                if (iPath3.equals((Object)iPath)) {
                    this.mInRes = false;
                    this.mSourceFolder = this.getFolder(iPath3);
                    this.mIsGenSourceFolder = iPath.segmentCount() == 2 && iPath.segment(1).equals("gen");
                    return true;
                }
                int n = iPath3.matchingFirstSegments(iPath);
                if (n != iPath.segmentCount()) continue;
                this.mInRes = false;
                return true;
            }
            return false;
        }
        return false;
    }

    private IFile findFile(IFolder iFolder, String[] stringArray, int n, String string) {
        boolean bl = n == stringArray.length - 1;
        IResource iResource = iFolder.findMember(bl ? string : stringArray[n]);
        if (iResource != null && iResource.exists()) {
            if (bl) {
                if (iResource.getType() == 1) {
                    return (IFile)iResource;
                }
            } else if (iResource.getType() == 2) {
                return this.findFile((IFolder)iResource, stringArray, n + 1, string);
            }
        }
        return null;
    }

    private IFolder getFolder(IPath iPath) {
        IResource iResource = this.mRoot.findMember(iPath);
        if (iResource != null && iResource.exists() && iResource.getType() == 2) {
            return (IFolder)iResource;
        }
        return null;
    }

    private AidlType getAidlType(IFile iFile) throws CoreException {
        return AidlType.UNKNOWN;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AidlType {
        UNKNOWN,
        INTERFACE,
        PARCELABLE;

    }
}

