/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.actions;

import com.android.ide.eclipse.adt.internal.project.AndroidNature;
import com.android.ide.eclipse.adt.internal.project.ProjectHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class FixProjectAction
implements IObjectActionDelegate {
    private ISelection mSelection;

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
    }

    public void run(IAction iAction) {
        if (this.mSelection instanceof IStructuredSelection) {
            for (Object e : (IStructuredSelection)this.mSelection) {
                IProject iProject = null;
                if (e instanceof IProject) {
                    iProject = (IProject)e;
                } else if (e instanceof IAdaptable) {
                    iProject = (IProject)((IAdaptable)e).getAdapter(IProject.class);
                }
                if (iProject == null) continue;
                this.fixProject(iProject);
            }
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.mSelection = iSelection;
    }

    private void fixProject(final IProject iProject) {
        new Job("Fix Project Properties"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                try {
                    if (iProgressMonitor != null) {
                        iProgressMonitor.beginTask("Fix Project Properties", 6);
                    }
                    ProjectHelper.fixProject(iProject);
                    if (iProgressMonitor != null) {
                        iProgressMonitor.worked(1);
                    }
                    ProjectHelper.fixProjectNatureOrder(iProject);
                    if (iProgressMonitor != null) {
                        iProgressMonitor.worked(1);
                    }
                    AndroidNature.configureResourceManagerBuilder(iProject);
                    if (iProgressMonitor != null) {
                        iProgressMonitor.worked(1);
                    }
                    AndroidNature.configurePreBuilder(iProject);
                    if (iProgressMonitor != null) {
                        iProgressMonitor.worked(1);
                    }
                    AndroidNature.configureApkBuilder(iProject);
                    if (iProgressMonitor != null) {
                        iProgressMonitor.worked(1);
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (JavaModelException javaModelException) {
                    IJavaModelStatus iJavaModelStatus = javaModelException.getJavaModelStatus();
                    return iJavaModelStatus;
                }
                catch (CoreException coreException) {
                    IStatus iStatus = coreException.getStatus();
                    return iStatus;
                }
                finally {
                    if (iProgressMonitor != null) {
                        iProgressMonitor.done();
                    }
                }
            }
        }.schedule();
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
    }
}

