/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.Messages;
import com.android.sdklib.SdkConstants;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Version;

public final class VersionCheck {
    private static final Pattern sPluginVersionPattern = Pattern.compile("^plugin.version=(\\d+)\\.(\\d+)\\.(\\d+).*$");

    public static boolean checkVersion(String string, AdtPlugin.CheckSdkErrorHandler checkSdkErrorHandler) {
        BufferedReader bufferedReader;
        Object object;
        AdtPlugin adtPlugin = AdtPlugin.getDefault();
        String string2 = String.valueOf(string) + SdkConstants.OS_SDK_TOOLS_LIB_FOLDER;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        try {
            String string3;
            object = new FileReader(String.valueOf(string2) + "plugin.prop");
            bufferedReader = new BufferedReader((Reader)object);
            while ((string3 = bufferedReader.readLine()) != null) {
                Matcher matcher = sPluginVersionPattern.matcher(string3);
                if (!matcher.matches()) continue;
                n = Integer.parseInt(matcher.group(1));
                n2 = Integer.parseInt(matcher.group(2));
                n3 = Integer.parseInt(matcher.group(3));
                break;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {}
        if (n == -1 || n2 == -1 || n3 == -1) {
            return checkSdkErrorHandler.handleWarning(Messages.VersionCheck_Plugin_Version_Failed);
        }
        object = (String)adtPlugin.getBundle().getHeaders().get("Bundle-Version");
        bufferedReader = new Version((String)object);
        boolean bl = true;
        if (bufferedReader.getMajor() < n) {
            bl = false;
        } else if (bufferedReader.getMajor() == n) {
            if (bufferedReader.getMinor() < n2) {
                bl = false;
            } else if (bufferedReader.getMinor() == n2 && bufferedReader.getMicro() < n3) {
                bl = false;
            }
        }
        if (!bl) {
            return checkSdkErrorHandler.handleWarning(String.format(Messages.VersionCheck_Plugin_Too_Old, n, n2, n3, object));
        }
        return true;
    }
}

