/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt;

import com.android.ddmuilib.StackTracePanel;
import com.android.ddmuilib.console.DdmConsole;
import com.android.ddmuilib.console.IDdmConsole;
import com.android.ide.eclipse.adt.AndroidConstants;
import com.android.ide.eclipse.adt.Messages;
import com.android.ide.eclipse.adt.internal.VersionCheck;
import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.editors.xml.XmlEditor;
import com.android.ide.eclipse.adt.internal.launch.AndroidLaunchController;
import com.android.ide.eclipse.adt.internal.preferences.BuildPreferencePage;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.project.ExportHelper;
import com.android.ide.eclipse.adt.internal.project.ProjectHelper;
import com.android.ide.eclipse.adt.internal.resources.manager.ProjectResources;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceFolder;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceFolderType;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceManager;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceMonitor;
import com.android.ide.eclipse.adt.internal.sdk.LoadStatus;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.ide.eclipse.adt.internal.ui.EclipseUiHelper;
import com.android.ide.eclipse.adt.internal.wizards.export.ExportWizard;
import com.android.ide.eclipse.ddms.DdmsPlugin;
import com.android.ide.eclipse.ddms.ImageLoader;
import com.android.sdklib.SdkConstants;
import com.android.sdkstats.SdkStatsService;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class AdtPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.android.ide.eclipse.adt";
    public static final String PREFS_SDK_DIR = "com.android.ide.eclipse.adt.sdk";
    public static final String PREFS_RES_AUTO_REFRESH = "com.android.ide.eclipse.adt.resAutoRefresh";
    public static final String PREFS_BUILD_VERBOSITY = "com.android.ide.eclipse.adt.buildVerbosity";
    public static final String PREFS_DEFAULT_DEBUG_KEYSTORE = "com.android.ide.eclipse.adt.defaultDebugKeyStore";
    public static final String PREFS_CUSTOM_DEBUG_KEYSTORE = "com.android.ide.eclipse.adt.customDebugKeyStore";
    public static final String PREFS_HOME_PACKAGE = "com.android.ide.eclipse.adt.homePackage";
    public static final String PREFS_EMU_OPTIONS = "com.android.ide.eclipse.adt.emuOptions";
    private static AdtPlugin sPlugin;
    private static Image sAndroidLogo;
    private static ImageDescriptor sAndroidLogoDesc;
    private IPreferenceStore mStore;
    private String mOsSdkLocation;
    private MessageConsole mAndroidConsole;
    private MessageConsoleStream mAndroidConsoleStream;
    private MessageConsoleStream mAndroidConsoleErrorStream;
    private ImageLoader mLoader;
    private int mBuildVerbosity = 1;
    private Color mRed;
    private LoadStatus mSdkIsLoaded = LoadStatus.LOADING;
    private final ArrayList<IJavaProject> mPostLoadProjectsToResolve = new ArrayList();
    private final ArrayList<IJavaProject> mPostLoadProjectsToCheck = new ArrayList();
    private ResourceMonitor mResourceMonitor;
    private ArrayList<Sdk.ITargetChangeListener> mTargetChangeListeners = new ArrayList();
    protected boolean mSdkIsLoading;

    public AdtPlugin() {
        sPlugin = this;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        Display display = AdtPlugin.getDisplay();
        this.mAndroidConsole = new MessageConsole("Android", null);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.mAndroidConsole});
        this.mAndroidConsoleStream = this.mAndroidConsole.newMessageStream();
        this.mAndroidConsoleErrorStream = this.mAndroidConsole.newMessageStream();
        this.mRed = new Color((Device)display, 255, 0, 0);
        display.asyncExec(new Runnable(){

            public void run() {
                AdtPlugin.this.mAndroidConsoleErrorStream.setColor(AdtPlugin.this.mRed);
            }
        });
        DdmConsole.setConsole((IDdmConsole)new IDdmConsole(){

            public void printErrorToConsole(String string) {
                AdtPlugin.printErrorToConsole(null, new Object[]{string});
            }

            public void printErrorToConsole(String[] stringArray) {
                AdtPlugin.printErrorToConsole(null, (Object[])stringArray);
            }

            public void printToConsole(String string) {
                AdtPlugin.printToConsole(null, new Object[]{string});
            }

            public void printToConsole(String[] stringArray) {
                AdtPlugin.printToConsole(null, (Object[])stringArray);
            }
        });
        this.mStore = this.getPreferenceStore();
        Preferences preferences = this.getPluginPreferences();
        preferences.addPropertyChangeListener(new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getProperty();
                if (AdtPlugin.PREFS_SDK_DIR.equals(string)) {
                    AdtPlugin.this.mOsSdkLocation = (String)propertyChangeEvent.getNewValue();
                    if (!AdtPlugin.this.mOsSdkLocation.endsWith(File.separator)) {
                        AdtPlugin adtPlugin = AdtPlugin.this;
                        adtPlugin.mOsSdkLocation = String.valueOf(adtPlugin.mOsSdkLocation) + File.separator;
                    }
                    DdmsPlugin.setAdb((String)AdtPlugin.getOsAbsoluteAdb(), (boolean)true);
                    if (AdtPlugin.this.checkSdkLocationAndId()) {
                        AdtPlugin.this.reparseSdk();
                    }
                } else if (AdtPlugin.PREFS_BUILD_VERBOSITY.equals(string)) {
                    AdtPlugin.this.mBuildVerbosity = BuildPreferencePage.getBuildLevel(AdtPlugin.this.mStore.getString(AdtPlugin.PREFS_BUILD_VERBOSITY));
                }
            }
        });
        this.mOsSdkLocation = this.mStore.getString(PREFS_SDK_DIR);
        if (this.mOsSdkLocation.length() > 0 && !this.mOsSdkLocation.endsWith(File.separator)) {
            this.mOsSdkLocation = String.valueOf(this.mOsSdkLocation) + File.separator;
        }
        final boolean bl = this.checkSdkLocationAndId();
        this.mBuildVerbosity = BuildPreferencePage.getBuildLevel(this.mStore.getString(PREFS_BUILD_VERBOSITY));
        this.mLoader = new ImageLoader((Plugin)this);
        if (this.mOsSdkLocation.length() > 0) {
            DdmsPlugin.setAdb((String)AdtPlugin.getOsAbsoluteAdb(), (boolean)true);
        }
        DdmsPlugin.setRunningAppDebugLauncher((DdmsPlugin.IDebugLauncher)new DdmsPlugin.IDebugLauncher(){

            public boolean debug(String string, int n) {
                IProject iProject = ProjectHelper.findAndroidProjectByAppName(string);
                if (iProject != null) {
                    AndroidLaunchController.debugRunningApp(iProject, n);
                    return true;
                }
                return false;
            }
        });
        StackTracePanel.setSourceRevealer((StackTracePanel.ISourceRevealer)new StackTracePanel.ISourceRevealer(){

            public void reveal(String string, String string2, int n) {
                IProject iProject = ProjectHelper.findAndroidProjectByAppName(string);
                if (iProject != null) {
                    BaseProjectHelper.revealSource(iProject, string2, n);
                }
            }
        });
        ExportHelper.setCallback(new ExportHelper.IExportCallback(){

            public void startExportWizard(IProject iProject) {
                StructuredSelection structuredSelection = new StructuredSelection((Object)iProject);
                ExportWizard exportWizard = new ExportWizard();
                exportWizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)structuredSelection);
                WizardDialog wizardDialog = new WizardDialog(AdtPlugin.getDisplay().getActiveShell(), (IWizard)exportWizard);
                wizardDialog.open();
            }
        });
        this.startEditors();
        Job job = this.createPingUsageServerJob();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent iJobChangeEvent) {
                super.done(iJobChangeEvent);
                if (bl) {
                    AdtPlugin.this.parseSdkContent();
                }
            }
        });
        job.setPriority(40);
        job.schedule(2000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        this.stopEditors();
        this.mRed.dispose();
        Class<AdtPlugin> clazz = AdtPlugin.class;
        synchronized (AdtPlugin.class) {
            sPlugin = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static synchronized ImageLoader getImageLoader() {
        if (sPlugin != null) {
            return AdtPlugin.sPlugin.mLoader;
        }
        return null;
    }

    public static synchronized AdtPlugin getDefault() {
        return sPlugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display getDisplay() {
        IWorkbench iWorkbench = null;
        Class<AdtPlugin> clazz = AdtPlugin.class;
        synchronized (AdtPlugin.class) {
            iWorkbench = sPlugin.getWorkbench();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (iWorkbench != null) {
                return iWorkbench.getDisplay();
            }
            return null;
        }
    }

    public static String getOsRelativeAdb() {
        return String.valueOf(SdkConstants.OS_SDK_TOOLS_FOLDER) + SdkConstants.FN_ADB;
    }

    public static String getOsRelativeZipAlign() {
        return String.valueOf(SdkConstants.OS_SDK_TOOLS_FOLDER) + SdkConstants.FN_ZIPALIGN;
    }

    public static String getOsRelativeEmulator() {
        return String.valueOf(SdkConstants.OS_SDK_TOOLS_FOLDER) + SdkConstants.FN_EMULATOR;
    }

    public static String getOsAbsoluteAdb() {
        return String.valueOf(AdtPlugin.getOsSdkFolder()) + AdtPlugin.getOsRelativeAdb();
    }

    public static String getOsAbsoluteZipAlign() {
        return String.valueOf(AdtPlugin.getOsSdkFolder()) + AdtPlugin.getOsRelativeZipAlign();
    }

    public static String getOsAbsoluteTraceview() {
        return String.valueOf(AdtPlugin.getOsSdkFolder()) + SdkConstants.OS_SDK_TOOLS_FOLDER + AndroidConstants.FN_TRACEVIEW;
    }

    public static String getOsAbsoluteEmulator() {
        return String.valueOf(AdtPlugin.getOsSdkFolder()) + AdtPlugin.getOsRelativeEmulator();
    }

    public static String getUrlDoc() {
        return ProjectHelper.getJavaDocPath(String.valueOf(AdtPlugin.getOsSdkFolder()) + "docs/reference");
    }

    public static synchronized String getOsSdkFolder() {
        if (sPlugin == null) {
            return null;
        }
        if (AdtPlugin.sPlugin.mOsSdkLocation == null) {
            AdtPlugin.sPlugin.mOsSdkLocation = AdtPlugin.sPlugin.mStore.getString(PREFS_SDK_DIR);
        }
        return AdtPlugin.sPlugin.mOsSdkLocation;
    }

    public static String getOsSdkToolsFolder() {
        return String.valueOf(AdtPlugin.getOsSdkFolder()) + SdkConstants.OS_SDK_TOOLS_FOLDER;
    }

    public static synchronized boolean getAutoResRefresh() {
        if (sPlugin == null) {
            return false;
        }
        return AdtPlugin.sPlugin.mStore.getBoolean(PREFS_RES_AUTO_REFRESH);
    }

    public static synchronized int getBuildVerbosity() {
        if (sPlugin != null) {
            return AdtPlugin.sPlugin.mBuildVerbosity;
        }
        return 0;
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        return AdtPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readEmbeddedTextFile(String string) {
        Bundle bundle = null;
        Object object = AdtPlugin.class;
        synchronized (AdtPlugin.class) {
            block10: {
                if (sPlugin != null) {
                    bundle = sPlugin.getBundle();
                    break block10;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                object = bundle.getEntry("/" + string);
                if (object != null) {
                    String string2;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((URL)object).openStream()));
                    StringBuilder stringBuilder = new StringBuilder(bufferedReader.readLine());
                    while ((string2 = bufferedReader.readLine()) != null) {
                        stringBuilder.append('\n');
                        stringBuilder.append(string2);
                    }
                    return stringBuilder.toString();
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {}
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readEmbeddedFile(String string) {
        Bundle bundle = null;
        Object object = AdtPlugin.class;
        synchronized (AdtPlugin.class) {
            if (sPlugin == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            bundle = sPlugin.getBundle();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                object = bundle.getEntry("/" + string);
                if (object != null) {
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(((URL)object).openStream());
                    int n = bufferedInputStream.available();
                    byte[] byArray = new byte[n];
                    bufferedInputStream.read(byArray);
                    return byArray;
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {}
            return null;
        }
    }

    public static final void displayError(final String string, final String string2) {
        final Display display = AdtPlugin.getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                Shell shell = display.getActiveShell();
                MessageDialog.openError((Shell)shell, (String)string, (String)string2);
            }
        });
    }

    public static final void displayWarning(final String string, final String string2) {
        final Display display = AdtPlugin.getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                Shell shell = display.getActiveShell();
                MessageDialog.openWarning((Shell)shell, (String)string, (String)string2);
            }
        });
    }

    public static final boolean displayPrompt(final String string, final String string2) {
        final Display display = AdtPlugin.getDisplay();
        final boolean[] blArray = new boolean[1];
        display.syncExec(new Runnable(){

            public void run() {
                Shell shell = display.getActiveShell();
                blArray[0] = MessageDialog.openQuestion((Shell)shell, (String)string, (String)string2);
            }
        });
        return blArray[0];
    }

    public static void log(int n, String string, Object ... objectArray) {
        String string2 = String.format(string, objectArray);
        Status status = new Status(n, PLUGIN_ID, string2);
        AdtPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void log(Throwable throwable, String string, Object ... objectArray) {
        String string2 = String.format(string, objectArray);
        Status status = new Status(4, PLUGIN_ID, string2, throwable);
        AdtPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static synchronized void logAndPrintError(Throwable throwable, String string, String string2, Object ... objectArray) {
        if (sPlugin != null) {
            String string3 = String.format(string2, objectArray);
            Status status = new Status(4, PLUGIN_ID, string3, throwable);
            AdtPlugin.getDefault().getLog().log((IStatus)status);
            AdtPlugin.printToStream(AdtPlugin.sPlugin.mAndroidConsoleErrorStream, string, string3);
            AdtPlugin.showAndroidConsole();
        }
    }

    public static synchronized void printErrorToConsole(String string, Object ... objectArray) {
        if (sPlugin != null) {
            AdtPlugin.printToStream(AdtPlugin.sPlugin.mAndroidConsoleErrorStream, string, objectArray);
            AdtPlugin.showAndroidConsole();
        }
    }

    public static void printErrorToConsole(Object ... objectArray) {
        AdtPlugin.printErrorToConsole(null, objectArray);
    }

    public static void printErrorToConsole(IProject iProject, Object ... objectArray) {
        String string = iProject != null ? iProject.getName() : null;
        AdtPlugin.printErrorToConsole(string, objectArray);
    }

    public static synchronized void printBuildToConsole(int n, IProject iProject, Object ... objectArray) {
        if (sPlugin != null && n <= AdtPlugin.sPlugin.mBuildVerbosity) {
            String string = iProject != null ? iProject.getName() : null;
            AdtPlugin.printToStream(AdtPlugin.sPlugin.mAndroidConsoleStream, string, objectArray);
        }
    }

    public static synchronized void printToConsole(String string, Object ... objectArray) {
        if (sPlugin != null) {
            AdtPlugin.printToStream(AdtPlugin.sPlugin.mAndroidConsoleStream, string, objectArray);
        }
    }

    public static void printToConsole(IProject iProject, Object ... objectArray) {
        String string = iProject != null ? iProject.getName() : null;
        AdtPlugin.printToConsole(string, objectArray);
    }

    public static void showAndroidConsole() {
        EclipseUiHelper.showView("org.eclipse.ui.console.ConsoleView", true);
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)AdtPlugin.getDefault().getAndroidConsole());
    }

    public static synchronized PrintStream getOutPrintStream(IProject iProject, String string) {
        if (sPlugin != null) {
            return new AndroidPrintStream(iProject, string, (OutputStream)AdtPlugin.sPlugin.mAndroidConsoleStream);
        }
        return null;
    }

    public static synchronized PrintStream getErrPrintStream(IProject iProject, String string) {
        if (sPlugin != null) {
            return new AndroidPrintStream(iProject, string, (OutputStream)AdtPlugin.sPlugin.mAndroidConsoleErrorStream);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LoadStatus getSdkLoadStatus() {
        Object object = this.getSdkLockObject();
        synchronized (object) {
            return this.mSdkIsLoaded;
        }
    }

    public final Object getSdkLockObject() {
        return this.mPostLoadProjectsToResolve;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setProjectToResolve(IJavaProject iJavaProject) {
        Object object = this.getSdkLockObject();
        synchronized (object) {
            this.mPostLoadProjectsToResolve.add(iJavaProject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setProjectToCheck(IJavaProject iJavaProject) {
        Object object = this.getSdkLockObject();
        synchronized (object) {
            this.mPostLoadProjectsToCheck.add(iJavaProject);
        }
    }

    private boolean checkSdkLocationAndId() {
        if (this.mOsSdkLocation == null || this.mOsSdkLocation.length() == 0) {
            AdtPlugin.displayError(Messages.Dialog_Title_SDK_Location, Messages.SDK_Not_Setup);
            return false;
        }
        return this.checkSdkLocationAndId(this.mOsSdkLocation, new CheckSdkErrorHandler(){

            public boolean handleError(String string) {
                AdtPlugin.displayError(Messages.Dialog_Title_SDK_Location, String.format(Messages.Error_Check_Prefs, string));
                return false;
            }

            public boolean handleWarning(String string) {
                AdtPlugin.displayWarning(Messages.Dialog_Title_SDK_Location, string);
                return true;
            }
        });
    }

    public boolean checkSdkLocationAndId(String string, CheckSdkErrorHandler checkSdkErrorHandler) {
        String[] stringArray;
        File file;
        if (!string.endsWith(File.separator)) {
            string = String.valueOf(string) + File.separator;
        }
        if (!(file = new File(string)).isDirectory()) {
            return checkSdkErrorHandler.handleError(String.format(Messages.Could_Not_Find_Folder, string));
        }
        String string2 = String.valueOf(string) + SdkConstants.OS_SDK_TOOLS_FOLDER;
        File file2 = new File(string2);
        if (!file2.isDirectory()) {
            return checkSdkErrorHandler.handleError(String.format(Messages.Could_Not_Find_Folder_In_SDK, "tools", string));
        }
        String[] stringArray2 = stringArray = new String[]{String.valueOf(string) + AdtPlugin.getOsRelativeAdb(), String.valueOf(string) + AdtPlugin.getOsRelativeEmulator()};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray2[n2];
            if (!this.checkFile(string3)) {
                return checkSdkErrorHandler.handleError(String.format(Messages.Could_Not_Find, string3));
            }
            ++n2;
        }
        return VersionCheck.checkVersion(string, checkSdkErrorHandler);
    }

    private boolean checkFile(String string) {
        File file = new File(string);
        return file.isFile();
    }

    private Job createPingUsageServerJob() {
        Job job = new Job("Android SDK Ping"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                try {
                    AdtPlugin.this.pingUsageServer();
                    return Status.OK_STATUS;
                }
                catch (Throwable throwable) {
                    AdtPlugin.log(throwable, "pingUsageServer failed", new Object[0]);
                    return new Status(4, AdtPlugin.PLUGIN_ID, "pingUsageServer failed", throwable);
                }
            }
        };
        return job;
    }

    private void parseSdkContent() {
        Job job = new Job(Messages.AdtPlugin_Android_SDK_Content_Loader){

            /*
             * Exception decompiling
             */
            protected IStatus run(IProgressMonitor var1_1) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[WHILELOOP]], but top level block is 4[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        job.setPriority(40);
        job.schedule();
    }

    public MessageConsole getAndroidConsole() {
        return this.mAndroidConsole;
    }

    public void startEditors() {
        sAndroidLogoDesc = AdtPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"/icons/android.png");
        sAndroidLogo = sAndroidLogoDesc.createImage();
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        this.mResourceMonitor = ResourceMonitor.startMonitoring(iWorkspace);
        if (this.mResourceMonitor != null) {
            try {
                this.setupDefaultEditor(this.mResourceMonitor);
                ResourceManager.setup(this.mResourceMonitor);
            }
            catch (Throwable throwable) {
                AdtPlugin.log(throwable, "ResourceManager.setup failed", new Object[0]);
            }
        }
    }

    public void stopEditors() {
        sAndroidLogo.dispose();
        IconFactory.getInstance().Dispose();
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        ResourceMonitor.stopMonitoring(iWorkspace);
        this.mRed.dispose();
    }

    public static Image getAndroidLogo() {
        return sAndroidLogo;
    }

    public static ImageDescriptor getAndroidLogoDesc() {
        return sAndroidLogoDesc;
    }

    public ResourceMonitor getResourceMonitor() {
        return this.mResourceMonitor;
    }

    public void setupDefaultEditor(ResourceMonitor resourceMonitor) {
        resourceMonitor.addFileListener(new ResourceMonitor.IFileListener(){
            private static final String UNKNOWN_EDITOR = "unknown-editor";

            public void fileChanged(IFile iFile, IMarkerDelta[] iMarkerDeltaArray, int n) {
                String string;
                if ("xml".equals(iFile.getFileExtension()) && iFile.getFullPath().segmentCount() == 4 && (string = iFile.getFullPath().segment(1)).equalsIgnoreCase("res")) {
                    ProjectResources projectResources = ResourceManager.getInstance().getProjectResources(iFile.getProject());
                    if (projectResources == null) {
                        AdtPlugin.log(1, "getProjectResources failed for path %1$s in project %2$s", iFile.getFullPath().toOSString(), iFile.getProject().getName());
                        return;
                    }
                    ResourceFolder resourceFolder = projectResources.getResourceFolder((IFolder)iFile.getParent());
                    if (resourceFolder != null) {
                        if (n == 1) {
                            this.resourceAdded(iFile, resourceFolder.getType());
                        } else if (n == 4) {
                            this.resourceChanged(iFile, resourceFolder.getType());
                        }
                    } else {
                        IEditorDescriptor iEditorDescriptor = IDE.getDefaultEditor((IFile)iFile);
                        String string2 = iEditorDescriptor.getId();
                        if (string2.startsWith("com.android.ide.eclipse.editors")) {
                            IDE.setDefaultEditor((IFile)iFile, null);
                        }
                    }
                }
            }

            private void resourceAdded(IFile iFile, ResourceFolderType resourceFolderType) {
                if (resourceFolderType == ResourceFolderType.LAYOUT) {
                    IDE.setDefaultEditor((IFile)iFile, (String)"com.android.ide.eclipse.editors.layout.LayoutEditor");
                } else if (resourceFolderType == ResourceFolderType.DRAWABLE || resourceFolderType == ResourceFolderType.VALUES) {
                    IDE.setDefaultEditor((IFile)iFile, (String)"com.android.ide.eclipse.editors.resources.ResourcesEditor");
                } else if (resourceFolderType == ResourceFolderType.MENU) {
                    IDE.setDefaultEditor((IFile)iFile, (String)"com.android.ide.eclipse.editors.menu.MenuEditor");
                } else if (resourceFolderType == ResourceFolderType.XML) {
                    if (XmlEditor.canHandleFile(iFile)) {
                        IDE.setDefaultEditor((IFile)iFile, (String)"com.android.ide.eclipse.editors.xml.XmlEditor");
                    } else {
                        QualifiedName qualifiedName = new QualifiedName(AdtPlugin.PLUGIN_ID, UNKNOWN_EDITOR);
                        try {
                            iFile.setPersistentProperty(qualifiedName, "1");
                        }
                        catch (CoreException coreException) {}
                    }
                }
            }

            private void resourceChanged(IFile iFile, ResourceFolderType resourceFolderType) {
                IEditorDescriptor iEditorDescriptor;
                if (resourceFolderType == ResourceFolderType.XML && ((iEditorDescriptor = IDE.getDefaultEditor((IFile)iFile)) == null || iEditorDescriptor.getId() != "com.android.ide.eclipse.editors.xml.XmlEditor")) {
                    QualifiedName qualifiedName = new QualifiedName(AdtPlugin.PLUGIN_ID, UNKNOWN_EDITOR);
                    String string = null;
                    try {
                        string = iFile.getPersistentProperty(qualifiedName);
                    }
                    catch (CoreException coreException) {}
                    if (string != null && XmlEditor.canHandleFile(iFile)) {
                        try {
                            iFile.setPersistentProperty(qualifiedName, null);
                            IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            IEditorPart iEditorPart = iWorkbenchPage.findEditor((IEditorInput)new FileEditorInput(iFile));
                            if (iEditorPart != null && AdtPlugin.displayPrompt("Android XML Editor", String.format("The file you just saved as been recognized as a file that could be better handled using the Android XML Editor. Do you want to edit '%1$s' using the Android XML editor instead?", iFile.getFullPath()))) {
                                IDE.setDefaultEditor((IFile)iFile, (String)"com.android.ide.eclipse.editors.xml.XmlEditor");
                                IEditorPart iEditorPart2 = iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), "com.android.ide.eclipse.editors.xml.XmlEditor", true, 0);
                                if (iEditorPart2 != null) {
                                    iWorkbenchPage.closeEditor(iEditorPart, true);
                                }
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                }
            }
        }, 5);
    }

    public void addTargetListener(Sdk.ITargetChangeListener iTargetChangeListener) {
        this.mTargetChangeListeners.add(iTargetChangeListener);
    }

    public void removeTargetListener(Sdk.ITargetChangeListener iTargetChangeListener) {
        this.mTargetChangeListeners.remove(iTargetChangeListener);
    }

    public void updateTargetListener(final IProject iProject) {
        final List list = (List)this.mTargetChangeListeners.clone();
        AdtPlugin.getDisplay().asyncExec(new Runnable(){

            public void run() {
                for (Sdk.ITargetChangeListener iTargetChangeListener : list) {
                    try {
                        iTargetChangeListener.onProjectTargetChange(iProject);
                    }
                    catch (Exception exception) {
                        AdtPlugin.log(exception, "Failed to update a TargetChangeListener.", new Object[0]);
                    }
                }
            }
        });
    }

    public static synchronized OutputStream getErrorStream() {
        return AdtPlugin.sPlugin.mAndroidConsoleErrorStream;
    }

    private void pingUsageServer() {
        String string = (String)this.getBundle().getHeaders().get("Bundle-Version");
        Version version = new Version(string);
        string = String.format("%1$d.%2$d.%3$d", version.getMajor(), version.getMinor(), version.getMicro());
        SdkStatsService.ping((String)"adt", (String)string, (Display)AdtPlugin.getDisplay());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reparseSdk() {
        Object object = this.getSdkLockObject();
        synchronized (object) {
            IJavaProject[] iJavaProjectArray = BaseProjectHelper.getAndroidProjects();
            this.mPostLoadProjectsToResolve.addAll((Collection<IJavaProject>)Arrays.asList(iJavaProjectArray));
        }
        this.parseSdkContent();
    }

    public static synchronized void printToStream(MessageConsoleStream messageConsoleStream, String string, Object ... objectArray) {
        String string2 = AdtPlugin.getMessageTag(string);
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            messageConsoleStream.print(string2);
            if (object instanceof String) {
                messageConsoleStream.println((String)object);
            } else {
                messageConsoleStream.println(object.toString());
            }
            ++n2;
        }
    }

    public static String getMessageTag(String string) {
        Calendar calendar = Calendar.getInstance();
        if (string == null) {
            return String.format(Messages.Console_Date_Tag, calendar);
        }
        return String.format(Messages.Console_Data_Project_Tag, calendar, string);
    }

    static /* synthetic */ void access$9(AdtPlugin adtPlugin, LoadStatus loadStatus) {
        adtPlugin.mSdkIsLoaded = loadStatus;
    }

    static /* synthetic */ ArrayList access$10(AdtPlugin adtPlugin) {
        return adtPlugin.mPostLoadProjectsToResolve;
    }

    static /* synthetic */ ArrayList access$11(AdtPlugin adtPlugin) {
        return adtPlugin.mPostLoadProjectsToCheck;
    }

    static /* synthetic */ ArrayList access$12(AdtPlugin adtPlugin) {
        return adtPlugin.mTargetChangeListeners;
    }

    private static final class AndroidPrintStream
    extends PrintStream {
        private IProject mProject;
        private String mPrefix;

        public AndroidPrintStream(IProject iProject, String string, OutputStream outputStream) {
            super(outputStream);
            this.mProject = iProject;
        }

        public void println(String string) {
            String string2 = AdtPlugin.getMessageTag(this.mProject != null ? this.mProject.getName() : null);
            this.print(string2);
            if (this.mPrefix != null) {
                this.print(this.mPrefix);
            }
            super.println(string);
        }
    }

    public static abstract class CheckSdkErrorHandler {
        public abstract boolean handleError(String var1);

        public abstract boolean handleWarning(String var1);
    }
}

