/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ddms.views;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.ddmuilib.DevicePanel;
import com.android.ddmuilib.ScreenShotDialog;
import com.android.ide.eclipse.ddms.DdmsPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class DeviceView
extends ViewPart
implements DevicePanel.IUiSelectionListener {
    private static final boolean USE_SELECTED_DEBUG_PORT = true;
    public static final String ID = "com.android.ide.eclipse.ddms.views.DeviceView";
    private DevicePanel mDeviceList;
    private Action mResetAdbAction;
    private Action mCaptureAction;
    private Action mUpdateThreadAction;
    private Action mUpdateHeapAction;
    private Action mGcAction;
    private Action mKillAppAction;
    private Action mDebugAction;
    private DdmsPlugin.IDebugLauncher mDebugLauncher;
    private static DeviceView sThis;

    public DeviceView() {
        sThis = this;
    }

    public static DeviceView getInstance() {
        return sThis;
    }

    public void setDebugLauncher(DdmsPlugin.IDebugLauncher iDebugLauncher) {
        Client client;
        this.mDebugLauncher = iDebugLauncher;
        if (this.mDebugAction != null && this.mDeviceList != null && (client = this.mDeviceList.getSelectedClient()) != null) {
            this.mDebugAction.setEnabled(true);
        }
    }

    public void createPartControl(Composite composite) {
        this.mDeviceList = new DevicePanel(DdmsPlugin.getImageLoader(), true);
        this.mDeviceList.createPanel(composite);
        this.mDeviceList.addSelectionListener(this);
        DdmsPlugin ddmsPlugin = DdmsPlugin.getDefault();
        this.mDeviceList.addSelectionListener(ddmsPlugin);
        ddmsPlugin.setListeningState(true);
        this.mCaptureAction = new Action("Screen Capture"){

            public void run() {
                ScreenShotDialog screenShotDialog = new ScreenShotDialog(DdmsPlugin.getDisplay().getActiveShell());
                screenShotDialog.open(DeviceView.this.mDeviceList.getSelectedDevice());
            }
        };
        this.mCaptureAction.setToolTipText("Screen Capture");
        this.mCaptureAction.setImageDescriptor(DdmsPlugin.getImageLoader().loadDescriptor("capture.png"));
        this.mResetAdbAction = new Action("Reset adb"){

            public void run() {
                AndroidDebugBridge androidDebugBridge = AndroidDebugBridge.getBridge();
                if (androidDebugBridge != null && !androidDebugBridge.restart()) {
                    final Display display = DdmsPlugin.getDisplay();
                    display.asyncExec(new Runnable(){

                        public void run() {
                            Shell shell = display.getActiveShell();
                            MessageDialog.openError((Shell)shell, (String)"Adb Error", (String)"Adb failed to restart!\n\nMake sure the plugin is properly configured.");
                        }
                    });
                }
            }
        };
        this.mResetAdbAction.setToolTipText("Reset the adb host daemon");
        this.mResetAdbAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_WARN_TSK"));
        this.mKillAppAction = new Action(){

            public void run() {
                DeviceView.this.mDeviceList.killSelectedClient();
            }
        };
        this.mKillAppAction.setText("Stop Process");
        this.mKillAppAction.setToolTipText("Stop Process");
        this.mKillAppAction.setImageDescriptor(DdmsPlugin.getImageLoader().loadDescriptor("halt.png"));
        this.mGcAction = new Action(){

            public void run() {
                DeviceView.this.mDeviceList.forceGcOnSelectedClient();
            }
        };
        this.mGcAction.setText("Cause GC");
        this.mGcAction.setToolTipText("Cause GC");
        this.mGcAction.setImageDescriptor(DdmsPlugin.getImageLoader().loadDescriptor("gc.png"));
        this.mUpdateHeapAction = new Action("Update Heap", 2){

            public void run() {
                boolean bl = DeviceView.this.mUpdateHeapAction.isChecked();
                DeviceView.this.mDeviceList.setEnabledHeapOnSelectedClient(bl);
            }
        };
        this.mUpdateHeapAction.setToolTipText("Update Heap");
        this.mUpdateHeapAction.setImageDescriptor(DdmsPlugin.getImageLoader().loadDescriptor("heap.png"));
        this.mUpdateThreadAction = new Action("Update Threads", 2){

            public void run() {
                boolean bl = DeviceView.this.mUpdateThreadAction.isChecked();
                DeviceView.this.mDeviceList.setEnabledThreadOnSelectedClient(bl);
            }
        };
        this.mUpdateThreadAction.setToolTipText("Update Threads");
        this.mUpdateThreadAction.setImageDescriptor(DdmsPlugin.getImageLoader().loadDescriptor("thread.png"));
        this.mDebugLauncher = DdmsPlugin.getRunningAppDebugLauncher();
        this.mDebugAction = new Action("Debug Process"){

            public void run() {
                Client client;
                if (DeviceView.this.mDebugLauncher != null && (client = DeviceView.this.mDeviceList.getSelectedClient()) != null) {
                    ClientData clientData = client.getClientData();
                    switch (clientData.getDebuggerConnectionStatus()) {
                        case 4: {
                            Display display = DdmsPlugin.getDisplay();
                            Shell shell = display.getActiveShell();
                            MessageDialog.openError((Shell)shell, (String)"Process Debug", (String)"The process debug port is already in use!");
                            return;
                        }
                        case 3: {
                            Display display = DdmsPlugin.getDisplay();
                            Shell shell = display.getActiveShell();
                            MessageDialog.openError((Shell)shell, (String)"Process Debug", (String)"The process is already being debugged!");
                            return;
                        }
                    }
                    String string = clientData.getClientDescription();
                    if (string != null && !DeviceView.this.mDebugLauncher.debug(string, client.getDebuggerListenPort())) {
                        Display display = DdmsPlugin.getDisplay();
                        Shell shell = display.getActiveShell();
                        MessageDialog.openError((Shell)shell, (String)"Process Debug", (String)String.format("No opened project found for %1$s. Debug session failed!", string));
                    }
                }
            }
        };
        this.mDebugAction.setToolTipText("Debug the selected process, provided its source project is present and opened in the workspace.");
        this.mDebugAction.setImageDescriptor(DdmsPlugin.getImageLoader().loadDescriptor("debug-attach.png"));
        if (this.mDebugLauncher == null) {
            this.mDebugAction.setEnabled(false);
        }
        this.placeActions();
    }

    public void setFocus() {
        this.mDeviceList.setFocus();
    }

    public void selectionChanged(IDevice iDevice, Client client) {
        this.doSelectionChanged(client);
        this.doSelectionChanged(iDevice);
    }

    private void doSelectionChanged(Client client) {
        if (client != null) {
            client.setAsSelectedClient();
            this.mDebugAction.setEnabled(this.mDebugLauncher != null);
            this.mKillAppAction.setEnabled(true);
            this.mGcAction.setEnabled(true);
            this.mUpdateHeapAction.setEnabled(true);
            this.mUpdateHeapAction.setChecked(client.isHeapUpdateEnabled());
            this.mUpdateThreadAction.setEnabled(true);
            this.mUpdateThreadAction.setChecked(client.isThreadUpdateEnabled());
        } else {
            AndroidDebugBridge androidDebugBridge = AndroidDebugBridge.getBridge();
            if (androidDebugBridge != null) {
                androidDebugBridge.setSelectedClient(null);
            }
            this.mDebugAction.setEnabled(false);
            this.mKillAppAction.setEnabled(false);
            this.mGcAction.setEnabled(false);
            this.mUpdateHeapAction.setChecked(false);
            this.mUpdateHeapAction.setEnabled(false);
            this.mUpdateThreadAction.setEnabled(false);
            this.mUpdateThreadAction.setChecked(false);
        }
    }

    private void doSelectionChanged(IDevice iDevice) {
        this.mCaptureAction.setEnabled(iDevice != null);
    }

    private final void placeActions() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        IMenuManager iMenuManager = iActionBars.getMenuManager();
        iMenuManager.add((IAction)this.mDebugAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.mUpdateThreadAction);
        iMenuManager.add((IAction)this.mUpdateHeapAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.mGcAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.mKillAppAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.mCaptureAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.mResetAdbAction);
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        iToolBarManager.add((IAction)this.mDebugAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.mUpdateThreadAction);
        iToolBarManager.add((IAction)this.mUpdateHeapAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.mKillAppAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.mCaptureAction);
    }
}

