/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ddms.preferences;

import com.android.ddmlib.DdmPreferences;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ide.eclipse.ddms.DdmsPlugin;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.FontData;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    public static final String ATTR_LOG_LEVEL = "com.android.ide.eclipse.ddms.logLevel";
    public static final String ATTR_DEBUG_PORT_BASE = "com.android.ide.eclipse.ddms.adbDebugBasePort";
    public static final String ATTR_SELECTED_DEBUG_PORT = "com.android.ide.eclipse.ddms.debugSelectedPort";
    public static final String ATTR_DEFAULT_THREAD_UPDATE = "com.android.ide.eclipse.ddms.defaultThreadUpdateEnabled";
    public static final String ATTR_DEFAULT_HEAP_UPDATE = "com.android.ide.eclipse.ddms.defaultHeapUpdateEnabled";
    public static final String ATTR_THREAD_INTERVAL = "com.android.ide.eclipse.ddms.threadStatusInterval";
    public static final String ATTR_IMAGE_SAVE_DIR = "com.android.ide.eclipse.ddms.imageSaveDir";
    public static final String ATTR_LAST_IMAGE_SAVE_DIR = "com.android.ide.eclipse.ddms.lastImageSaveDir";
    public static final String ATTR_LOGCAT_FONT = "com.android.ide.eclipse.ddms.logcatFont";

    public void initializeDefaultPreferences() {
        IPreferenceStore iPreferenceStore = DdmsPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.setDefault(ATTR_DEBUG_PORT_BASE, 8600);
        iPreferenceStore.setDefault(ATTR_SELECTED_DEBUG_PORT, 8700);
        iPreferenceStore.setDefault(ATTR_DEFAULT_THREAD_UPDATE, false);
        iPreferenceStore.setDefault(ATTR_DEFAULT_HEAP_UPDATE, false);
        iPreferenceStore.setDefault(ATTR_THREAD_INTERVAL, 4);
        String string = System.getProperty("user.home");
        iPreferenceStore.setDefault(ATTR_IMAGE_SAVE_DIR, string);
        iPreferenceStore.setDefault(ATTR_LOG_LEVEL, DdmPreferences.DEFAULT_LOG_LEVEL.getStringValue());
        iPreferenceStore.setDefault(ATTR_LOGCAT_FONT, new FontData("Courier", 10, 0).toString());
    }

    public static synchronized void setupPreferences() {
        IPreferenceStore iPreferenceStore = DdmsPlugin.getDefault().getPreferenceStore();
        DdmPreferences.setDebugPortBase(iPreferenceStore.getInt(ATTR_DEBUG_PORT_BASE));
        DdmPreferences.setSelectedDebugPort(iPreferenceStore.getInt(ATTR_SELECTED_DEBUG_PORT));
        DdmPreferences.setLogLevel(iPreferenceStore.getString(ATTR_LOG_LEVEL));
        DdmPreferences.setInitialThreadUpdate(iPreferenceStore.getBoolean(ATTR_DEFAULT_THREAD_UPDATE));
        DdmPreferences.setInitialHeapUpdate(iPreferenceStore.getBoolean(ATTR_DEFAULT_HEAP_UPDATE));
        DdmUiPreferences.setThreadRefreshInterval(iPreferenceStore.getInt(ATTR_THREAD_INTERVAL));
    }
}

