/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.log.event;

import com.android.ddmlib.log.EventContainer;
import com.android.ddmlib.log.EventLogParser;
import com.android.ddmlib.log.InvalidTypeException;
import com.android.ddmuilib.log.event.EventDisplay;
import com.android.ddmuilib.log.event.SyncCommon;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jfree.chart.labels.CustomXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimePeriodValues;
import org.jfree.data.time.TimePeriodValuesCollection;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.ShapeUtilities;

public class DisplaySync
extends SyncCommon {
    private TimePeriodValues[] mDatasetsSync;
    private List<String>[] mTooltipsSync;
    private CustomXYToolTipGenerator[] mTooltipGenerators;
    private TimeSeries[] mDatasetsSyncTickle;
    private TimeSeries mDatasetError;

    public DisplaySync(String string) {
        super(string);
    }

    public Control createComposite(Composite composite, EventLogParser eventLogParser, EventDisplay.ILogColumnListener iLogColumnListener) {
        Control control = this.createCompositeChart(composite, eventLogParser, "Sync Status");
        this.resetUI();
        return control;
    }

    void resetUI() {
        super.resetUI();
        XYPlot xYPlot = this.mChart.getXYPlot();
        XYBarRenderer xYBarRenderer = new XYBarRenderer();
        this.mDatasetsSync = new TimePeriodValues[4];
        this.mTooltipsSync = new List[4];
        this.mTooltipGenerators = new CustomXYToolTipGenerator[4];
        TimePeriodValuesCollection timePeriodValuesCollection = new TimePeriodValuesCollection();
        xYPlot.setDataset((XYDataset)timePeriodValuesCollection);
        xYPlot.setRenderer(0, (XYItemRenderer)xYBarRenderer);
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer();
        xYLineAndShapeRenderer.setBaseLinesVisible(false);
        this.mDatasetsSyncTickle = new TimeSeries[4];
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        xYPlot.setDataset(1, (XYDataset)timeSeriesCollection);
        xYPlot.setRenderer(1, (XYItemRenderer)xYLineAndShapeRenderer);
        this.mDatasetError = new TimeSeries((Comparable)((Object)"Errors"), FixedMillisecond.class);
        xYPlot.setDataset(2, (XYDataset)new TimeSeriesCollection(this.mDatasetError));
        XYLineAndShapeRenderer xYLineAndShapeRenderer2 = new XYLineAndShapeRenderer();
        xYLineAndShapeRenderer2.setBaseLinesVisible(false);
        xYLineAndShapeRenderer2.setSeriesPaint(0, (Paint)Color.RED);
        xYPlot.setRenderer(2, (XYItemRenderer)xYLineAndShapeRenderer2);
        int n = 0;
        while (n < 4) {
            xYBarRenderer.setSeriesPaint(n, (Paint)AUTH_COLORS[n]);
            xYLineAndShapeRenderer.setSeriesPaint(n, (Paint)AUTH_COLORS[n]);
            this.mDatasetsSync[n] = new TimePeriodValues(AUTH_NAMES[n]);
            timePeriodValuesCollection.addSeries(this.mDatasetsSync[n]);
            this.mTooltipsSync[n] = new ArrayList<String>();
            this.mTooltipGenerators[n] = new CustomXYToolTipGenerator();
            xYBarRenderer.setSeriesToolTipGenerator(n, (XYToolTipGenerator)this.mTooltipGenerators[n]);
            this.mTooltipGenerators[n].addToolTipSeries(this.mTooltipsSync[n]);
            this.mDatasetsSyncTickle[n] = new TimeSeries((Comparable)((Object)(String.valueOf(AUTH_NAMES[n]) + " tickle")), FixedMillisecond.class);
            timeSeriesCollection.addSeries(this.mDatasetsSyncTickle[n]);
            xYLineAndShapeRenderer.setSeriesShape(n, ShapeUtilities.createUpTriangle((float)2.5f));
            ++n;
        }
    }

    void newEvent(EventContainer eventContainer, EventLogParser eventLogParser) {
        super.newEvent(eventContainer, eventLogParser);
        try {
            int n;
            if (eventContainer.mTag == 2742 && (n = this.getAuth(eventContainer.getValueAsString(0))) >= 0) {
                long l = (long)eventContainer.sec * 1000L + (long)eventContainer.nsec / 1000000L;
                this.mDatasetsSyncTickle[n].addOrUpdate((RegularTimePeriod)new FixedMillisecond(l), -1.0);
            }
        }
        catch (InvalidTypeException invalidTypeException) {}
    }

    private int getHeightFromDetails(String string) {
        String[] stringArray;
        if (string == null) {
            return 1;
        }
        int n = 0;
        String[] stringArray2 = stringArray = string.split("[a-zA-Z]");
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray2[n3];
            if (!"".equals(string2)) {
                n += Integer.parseInt(string2);
            }
            ++n3;
        }
        if (n == 0) {
            n = 1;
        }
        return n;
    }

    private String getTextFromDetails(int n, String string, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AUTH_NAMES[n]).append(": \n");
        Scanner scanner = new Scanner(string);
        Pattern pattern = Pattern.compile("[a-zA-Z]");
        Pattern pattern2 = Pattern.compile("[0-9]+");
        while (scanner.hasNext()) {
            String string2 = scanner.findInLine(pattern);
            int n3 = Integer.parseInt(scanner.findInLine(pattern2));
            if (n == 1 && "M".equals(string2)) {
                stringBuffer.append("messages from server: ").append(n3).append("\n");
                continue;
            }
            if (n == 1 && "L".equals(string2)) {
                stringBuffer.append("labels from server: ").append(n3).append("\n");
                continue;
            }
            if (n == 1 && "C".equals(string2)) {
                stringBuffer.append("check conversation requests from server: ").append(n3).append("\n");
                continue;
            }
            if (n == 1 && "A".equals(string2)) {
                stringBuffer.append("attachments from server: ").append(n3).append("\n");
                continue;
            }
            if (n == 1 && "U".equals(string2)) {
                stringBuffer.append("op updates from server: ").append(n3).append("\n");
                continue;
            }
            if (n == 1 && "u".equals(string2)) {
                stringBuffer.append("op updates to server: ").append(n3).append("\n");
                continue;
            }
            if (n == 1 && "S".equals(string2)) {
                stringBuffer.append("send/receive cycles: ").append(n3).append("\n");
                continue;
            }
            if ("Q".equals(string2)) {
                stringBuffer.append("queries to server: ").append(n3).append("\n");
                continue;
            }
            if ("E".equals(string2)) {
                stringBuffer.append("entries from server: ").append(n3).append("\n");
                continue;
            }
            if ("u".equals(string2)) {
                stringBuffer.append("updates from client: ").append(n3).append("\n");
                continue;
            }
            if ("i".equals(string2)) {
                stringBuffer.append("inserts from client: ").append(n3).append("\n");
                continue;
            }
            if ("d".equals(string2)) {
                stringBuffer.append("deletes from client: ").append(n3).append("\n");
                continue;
            }
            if ("f".equals(string2)) {
                stringBuffer.append("full sync requested\n");
                continue;
            }
            if ("r".equals(string2)) {
                stringBuffer.append("partial sync unavailable\n");
                continue;
            }
            if ("X".equals(string2)) {
                stringBuffer.append("hard error\n");
                continue;
            }
            if ("e".equals(string2)) {
                stringBuffer.append("number of parse exceptions: ").append(n3).append("\n");
                continue;
            }
            if ("c".equals(string2)) {
                stringBuffer.append("number of conflicts: ").append(n3).append("\n");
                continue;
            }
            if ("a".equals(string2)) {
                stringBuffer.append("number of auth exceptions: ").append(n3).append("\n");
                continue;
            }
            if ("D".equals(string2)) {
                stringBuffer.append("too many deletions\n");
                continue;
            }
            if ("R".equals(string2)) {
                stringBuffer.append("too many retries: ").append(n3).append("\n");
                continue;
            }
            if ("b".equals(string2)) {
                stringBuffer.append("database error\n");
                continue;
            }
            if ("x".equals(string2)) {
                stringBuffer.append("soft error\n");
                continue;
            }
            if ("l".equals(string2)) {
                stringBuffer.append("sync already in progress\n");
                continue;
            }
            if ("I".equals(string2)) {
                stringBuffer.append("io exception\n");
                continue;
            }
            if (n == 3 && "p".equals(string2)) {
                stringBuffer.append("photos uploaded from client: ").append(n3).append("\n");
                continue;
            }
            if (n == 3 && "P".equals(string2)) {
                stringBuffer.append("photos downloaded from server: ").append(n3).append("\n");
                continue;
            }
            if (n == 0 && "F".equals(string2)) {
                stringBuffer.append("server refresh\n");
                continue;
            }
            if (n == 0 && "s".equals(string2)) {
                stringBuffer.append("server diffs fetched\n");
                continue;
            }
            stringBuffer.append(string2).append("=").append(n3);
        }
        if (n2 == 0) {
            stringBuffer.append("(server)");
        } else if (n2 == 1) {
            stringBuffer.append("(local)");
        } else if (n2 == 2) {
            stringBuffer.append("(poll)");
        } else if (n2 == 3) {
            stringBuffer.append("(user)");
        }
        return stringBuffer.toString();
    }

    void processSyncEvent(EventContainer eventContainer, int n, long l, long l2, String string, boolean bl, int n2) {
        if (!bl) {
            int n3 = this.mDatasetsSync[n].getItemCount();
            this.mDatasetsSync[n].delete(n3 - 1, n3 - 1);
            this.mTooltipsSync[n].remove(n3 - 1);
        }
        double d = this.getHeightFromDetails(string);
        if ((d = d / (double)(l2 - l + 1L) * 10000.0) > 30.0) {
            d = 30.0;
        }
        this.mDatasetsSync[n].add((TimePeriod)new SimpleTimePeriod(l, l2), d);
        this.mTooltipsSync[n].add(this.getTextFromDetails(n, string, n2));
        this.mTooltipGenerators[n].addToolTipSeries(this.mTooltipsSync[n]);
        if (string.indexOf(120) >= 0 || string.indexOf(88) >= 0) {
            long l3 = (long)eventContainer.sec * 1000L + (long)eventContainer.nsec / 1000000L;
            this.mDatasetError.addOrUpdate((RegularTimePeriod)new FixedMillisecond(l3), -1.0);
        }
    }

    int getDisplayType() {
        return 3;
    }
}

