/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.location;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public final class CoordinateControls {
    private double mValue;
    private boolean mValueValidity = false;
    private Text mDecimalText;
    private Text mSexagesimalDegreeText;
    private Text mSexagesimalMinuteText;
    private Text mSexagesimalSecondText;
    private int mManualTextChange = 0;
    private ModifyListener mSexagesimalListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            if (CoordinateControls.this.mManualTextChange > 0) {
                return;
            }
            try {
                CoordinateControls.this.mValue = CoordinateControls.this.getValueFromSexagesimalControls();
                CoordinateControls.this.setValueIntoDecimalControl(CoordinateControls.this.mValue);
                CoordinateControls.this.mValueValidity = true;
            }
            catch (NumberFormatException numberFormatException) {
                CoordinateControls.this.mValueValidity = false;
                CoordinateControls.this.resetDecimalControls();
            }
        }
    };

    public void createDecimalText(Composite composite) {
        this.mDecimalText = this.createTextControl(composite, "-199.999999", new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (CoordinateControls.this.mManualTextChange > 0) {
                    return;
                }
                try {
                    CoordinateControls.this.mValue = Double.parseDouble(CoordinateControls.this.mDecimalText.getText());
                    CoordinateControls.this.setValueIntoSexagesimalControl(CoordinateControls.this.mValue);
                    CoordinateControls.this.mValueValidity = true;
                }
                catch (NumberFormatException numberFormatException) {
                    CoordinateControls.this.mValueValidity = false;
                    CoordinateControls.this.resetSexagesimalControls();
                }
            }
        });
    }

    public void createSexagesimalDegreeText(Composite composite) {
        this.mSexagesimalDegreeText = this.createTextControl(composite, "-199", this.mSexagesimalListener);
    }

    public void createSexagesimalMinuteText(Composite composite) {
        this.mSexagesimalMinuteText = this.createTextControl(composite, "99", this.mSexagesimalListener);
    }

    public void createSexagesimalSecondText(Composite composite) {
        this.mSexagesimalSecondText = this.createTextControl(composite, "99.999", this.mSexagesimalListener);
    }

    public void setValue(double d) {
        this.mValue = d;
        this.mValueValidity = true;
        this.setValueIntoDecimalControl(d);
        this.setValueIntoSexagesimalControl(d);
    }

    public boolean isValueValid() {
        return this.mValueValidity;
    }

    public double getValue() {
        return this.mValue;
    }

    public void setEnabled(boolean bl) {
        this.mDecimalText.setEnabled(bl);
        this.mSexagesimalDegreeText.setEnabled(bl);
        this.mSexagesimalMinuteText.setEnabled(bl);
        this.mSexagesimalSecondText.setEnabled(bl);
    }

    private void resetDecimalControls() {
        ++this.mManualTextChange;
        this.mDecimalText.setText("");
        --this.mManualTextChange;
    }

    private void resetSexagesimalControls() {
        ++this.mManualTextChange;
        this.mSexagesimalDegreeText.setText("");
        this.mSexagesimalMinuteText.setText("");
        this.mSexagesimalSecondText.setText("");
        --this.mManualTextChange;
    }

    private Text createTextControl(Composite composite, String string, ModifyListener modifyListener) {
        Text text = new Text(composite, 18436);
        text.addModifyListener(modifyListener);
        ++this.mManualTextChange;
        text.setText(string);
        text.pack();
        Point point = text.computeSize(-1, -1);
        text.setText("");
        --this.mManualTextChange;
        GridData gridData = new GridData();
        gridData.widthHint = point.x;
        text.setLayoutData((Object)gridData);
        return text;
    }

    private double getValueFromSexagesimalControls() throws NumberFormatException {
        double d = Double.parseDouble(this.mSexagesimalDegreeText.getText());
        double d2 = Double.parseDouble(this.mSexagesimalMinuteText.getText());
        double d3 = Double.parseDouble(this.mSexagesimalSecondText.getText());
        boolean bl = d >= 0.0;
        d = Math.abs(d);
        double d4 = d + d2 / 60.0 + d3 / 3600.0;
        return bl ? d4 : -d4;
    }

    private void setValueIntoDecimalControl(double d) {
        ++this.mManualTextChange;
        this.mDecimalText.setText(String.format("%.6f", d));
        --this.mManualTextChange;
    }

    private void setValueIntoSexagesimalControl(double d) {
        boolean bl = d >= 0.0;
        d = Math.abs(d);
        double d2 = Math.floor(d);
        double d3 = Math.floor((d - d2) * 60.0);
        double d4 = (d - d2) * 3600.0 - d3 * 60.0;
        ++this.mManualTextChange;
        this.mSexagesimalDegreeText.setText(Integer.toString(bl ? (int)d2 : (int)(-d2)));
        this.mSexagesimalMinuteText.setText(Integer.toString((int)d3));
        this.mSexagesimalSecondText.setText(String.format("%.3f", d4));
        --this.mManualTextChange;
    }
}

