/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.Log;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.eclipse.swt.graphics.ImageData;

public class WritePng {
    private static final byte[] PNG_MAGIC = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};

    private WritePng() {
    }

    public static void savePng(String string, ImageData imageData) throws IOException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            Log.d("ddms", "Saving to PNG, width=" + imageData.width + ", height=" + imageData.height + ", depth=" + imageData.depth + ", bpl=" + imageData.bytesPerLine);
            WritePng.savePng(fileOutputStream, imageData);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            Log.e("writepng", exception);
        }
    }

    private static void savePng(OutputStream outputStream, ImageData imageData) throws IOException {
        int n;
        byte[] byArray;
        int n2 = imageData.width;
        int n3 = imageData.height;
        Log.i("ddms-png", "Convert to 24bit from " + imageData.depth);
        if (imageData.depth == 24 || imageData.depth == 32) {
            byArray = WritePng.convertTo24ForPng(imageData.data, n2, n3, imageData.depth, imageData.bytesPerLine);
        } else if (imageData.depth == 16) {
            byArray = WritePng.convert16to24(imageData);
        } else {
            return;
        }
        byte[] byArray2 = new byte[byArray.length + 16384];
        Deflater deflater = new Deflater();
        deflater.setLevel(9);
        deflater.setInput(byArray);
        deflater.finish();
        do {
            n = deflater.deflate(byArray2);
            assert (n != 0 || !deflater.needsInput());
        } while (n == 0);
        Log.d("ddms", "Compressed image data from " + byArray.length + " to " + n);
        outputStream.write(PNG_MAGIC);
        byte[] byArray3 = new byte[25];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray3);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        WritePng.putChunkHeader(byteBuffer, 13, "IHDR");
        byteBuffer.putInt(n2);
        byteBuffer.putInt(n3);
        byteBuffer.put((byte)8);
        byteBuffer.put((byte)2);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)0);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray3, 4, 17);
        byteBuffer.putInt((int)cRC32.getValue());
        outputStream.write(byArray3);
        byte[] byArray4 = new byte[12];
        byteBuffer = ByteBuffer.wrap(byArray4);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        WritePng.putChunkHeader(byteBuffer, n, "IDAT");
        cRC32 = new CRC32();
        cRC32.update(byArray4, 4, 4);
        cRC32.update(byArray2, 0, n);
        byteBuffer.putInt((int)cRC32.getValue());
        outputStream.write(byArray4, 0, 8);
        outputStream.write(byArray2, 0, n);
        outputStream.write(byArray4, 8, 4);
        byte[] byArray5 = new byte[12];
        byteBuffer = ByteBuffer.wrap(byArray5);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        WritePng.putChunkHeader(byteBuffer, 0, "IEND");
        cRC32 = new CRC32();
        cRC32.update(byArray5, 4, 4);
        byteBuffer.putInt((int)cRC32.getValue());
        outputStream.write(byArray5);
    }

    private static void putChunkHeader(ByteBuffer byteBuffer, int n, String string) {
        int n2 = 0;
        if (string.length() != 4) {
            throw new RuntimeException();
        }
        int n3 = 0;
        while (n3 < 4) {
            n2 <<= 8;
            n2 |= (byte)string.charAt(n3);
            ++n3;
        }
        byteBuffer.putInt(n);
        byteBuffer.putInt(n2);
    }

    private static byte[] convertTo24ForPng(byte[] byArray, int n, int n2, int n3, int n4) {
        assert (n3 == 24 || n3 == 32);
        assert (n4 == n * (n3 / 8));
        byte[] byArray2 = new byte[n * n2 * 3 + n2];
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n2) {
            byArray2[n6++] = 0;
            if (n3 == 24) {
                System.arraycopy(byArray, n5, byArray2, n6, n * 3);
                n6 += n * 3;
            } else if (n3 == 32) {
                int n8 = n5;
                int n9 = 0;
                while (n9 < n) {
                    int n10 = n6++;
                    int n11 = ++n8;
                    byArray2[n10] = byArray[n11];
                    int n12 = n6++;
                    int n13 = ++n8;
                    byArray2[n12] = byArray[n13];
                    int n14 = n6++;
                    int n15 = ++n8;
                    ++n8;
                    byArray2[n14] = byArray[n15];
                    ++n9;
                }
            }
            n5 += n4;
            ++n7;
        }
        assert (n6 == byArray2.length);
        return byArray2;
    }

    private static byte[] convert16to24(ImageData imageData) {
        int n = imageData.width;
        int n2 = imageData.height;
        int n3 = imageData.palette.redShift;
        int n4 = imageData.palette.greenShift;
        int n5 = imageData.palette.blueShift;
        int n6 = imageData.palette.redMask;
        int n7 = imageData.palette.greenMask;
        int n8 = imageData.palette.blueMask;
        byte[] byArray = new byte[n * n2 * 3 + n2];
        int n9 = 0;
        int[] nArray = new int[n];
        int n10 = 0;
        while (n10 < n2) {
            imageData.getPixels(0, n10, n, nArray, 0);
            byArray[n9++] = 0;
            int n11 = 0;
            while (n11 < n) {
                int n12 = nArray[n11];
                byArray[n9++] = WritePng.byteChannelValue(n12, n6, n3);
                byArray[n9++] = WritePng.byteChannelValue(n12, n7, n4);
                byArray[n9++] = WritePng.byteChannelValue(n12, n8, n5);
                ++n11;
            }
            ++n10;
        }
        return byArray;
    }

    private static byte byteChannelValue(int n, int n2, int n3) {
        int n4 = n & n2;
        n4 = n3 < 0 ? (n4 >>>= -n3) : (n4 <<= n3);
        return (byte)n4;
    }
}

