/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.IImageLoader;
import com.android.ddmuilib.ImageHelper;
import com.android.ddmuilib.Panel;
import com.android.ddmuilib.TableHelper;
import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public final class DevicePanel
extends Panel
implements AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IDeviceChangeListener,
AndroidDebugBridge.IClientChangeListener {
    private static final String PREFS_COL_NAME_SERIAL = "devicePanel.Col0";
    private static final String PREFS_COL_PID_STATE = "devicePanel.Col1";
    private static final String PREFS_COL_PORT_BUILD = "devicePanel.Col4";
    private static final int DEVICE_COL_SERIAL = 0;
    private static final int DEVICE_COL_STATE = 1;
    private static final int DEVICE_COL_BUILD = 4;
    private static final int CLIENT_COL_NAME = 0;
    private static final int CLIENT_COL_PID = 1;
    private static final int CLIENT_COL_THREAD = 2;
    private static final int CLIENT_COL_HEAP = 3;
    private static final int CLIENT_COL_PORT = 4;
    public static final int ICON_WIDTH = 16;
    public static final String ICON_THREAD = "thread.png";
    public static final String ICON_HEAP = "heap.png";
    public static final String ICON_HALT = "halt.png";
    public static final String ICON_GC = "gc.png";
    private IDevice mCurrentDevice;
    private Client mCurrentClient;
    private Tree mTree;
    private TreeViewer mTreeViewer;
    private Image mDeviceImage;
    private Image mEmulatorImage;
    private Image mThreadImage;
    private Image mHeapImage;
    private Image mWaitingImage;
    private Image mDebuggerImage;
    private Image mDebugErrorImage;
    private final ArrayList<IUiSelectionListener> mListeners = new ArrayList();
    private final ArrayList<IDevice> mDevicesToExpand = new ArrayList();
    private IImageLoader mLoader;
    private boolean mAdvancedPortSupport;

    public DevicePanel(IImageLoader iImageLoader, boolean bl) {
        this.mLoader = iImageLoader;
        this.mAdvancedPortSupport = bl;
    }

    public void addSelectionListener(IUiSelectionListener iUiSelectionListener) {
        this.mListeners.add(iUiSelectionListener);
    }

    public void removeSelectionListener(IUiSelectionListener iUiSelectionListener) {
        this.mListeners.remove(iUiSelectionListener);
    }

    protected Control createControl(Composite composite) {
        this.loadImages(composite.getDisplay(), this.mLoader);
        composite.setLayout((Layout)new FillLayout());
        this.mTree = new Tree(composite, 65540);
        this.mTree.setHeaderVisible(true);
        this.mTree.setLinesVisible(true);
        IPreferenceStore iPreferenceStore = DdmUiPreferences.getStore();
        TableHelper.createTreeColumn(this.mTree, "Name", 16384, "com.android.home", PREFS_COL_NAME_SERIAL, iPreferenceStore);
        TableHelper.createTreeColumn(this.mTree, "", 16384, "Offline", PREFS_COL_PID_STATE, iPreferenceStore);
        TreeColumn treeColumn = new TreeColumn(this.mTree, 0);
        treeColumn.setWidth(24);
        treeColumn.setResizable(false);
        treeColumn = new TreeColumn(this.mTree, 0);
        treeColumn.setWidth(24);
        treeColumn.setResizable(false);
        TableHelper.createTreeColumn(this.mTree, "", 16384, "9999-9999", PREFS_COL_PORT_BUILD, iPreferenceStore);
        this.mTreeViewer = new TreeViewer(this.mTree);
        this.mTreeViewer.setAutoExpandLevel(-1);
        this.mTreeViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.mTreeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.mTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DevicePanel.this.notifyListeners();
            }
        });
        return this.mTree;
    }

    public void setFocus() {
        this.mTree.setFocus();
    }

    protected void postCreation() {
        AndroidDebugBridge.addDebugBridgeChangeListener(this);
        AndroidDebugBridge.addDeviceChangeListener(this);
        AndroidDebugBridge.addClientChangeListener(this);
    }

    public void dispose() {
        AndroidDebugBridge.removeDebugBridgeChangeListener(this);
        AndroidDebugBridge.removeDeviceChangeListener(this);
        AndroidDebugBridge.removeClientChangeListener(this);
    }

    public Client getSelectedClient() {
        return this.mCurrentClient;
    }

    public IDevice getSelectedDevice() {
        return this.mCurrentDevice;
    }

    public void killSelectedClient() {
        if (this.mCurrentClient != null) {
            Client client = this.mCurrentClient;
            TreePath treePath = new TreePath(new Object[]{this.mCurrentDevice});
            TreeSelection treeSelection = new TreeSelection(treePath);
            this.mTreeViewer.setSelection((ISelection)treeSelection);
            client.kill();
        }
    }

    public void forceGcOnSelectedClient() {
        if (this.mCurrentClient != null) {
            this.mCurrentClient.executeGarbageCollector();
        }
    }

    public void setEnabledHeapOnSelectedClient(boolean bl) {
        if (this.mCurrentClient != null) {
            this.mCurrentClient.setHeapUpdateEnabled(bl);
        }
    }

    public void setEnabledThreadOnSelectedClient(boolean bl) {
        if (this.mCurrentClient != null) {
            this.mCurrentClient.setThreadUpdateEnabled(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bridgeChanged(final AndroidDebugBridge androidDebugBridge) {
        if (!this.mTree.isDisposed()) {
            this.exec(new Runnable(){

                public void run() {
                    if (!DevicePanel.this.mTree.isDisposed()) {
                        DevicePanel.this.mTreeViewer.setInput((Object)androidDebugBridge);
                        DevicePanel.this.notifyListeners();
                    } else {
                        AndroidDebugBridge.removeDebugBridgeChangeListener(DevicePanel.this);
                        AndroidDebugBridge.removeDeviceChangeListener(DevicePanel.this);
                        AndroidDebugBridge.removeClientChangeListener(DevicePanel.this);
                    }
                }
            });
        }
        ArrayList<IDevice> arrayList = this.mDevicesToExpand;
        synchronized (arrayList) {
            this.mDevicesToExpand.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceConnected(IDevice iDevice) {
        this.exec(new Runnable(){

            public void run() {
                if (!DevicePanel.this.mTree.isDisposed()) {
                    DevicePanel.this.mTreeViewer.refresh();
                    DevicePanel.this.notifyListeners();
                } else {
                    AndroidDebugBridge.removeDebugBridgeChangeListener(DevicePanel.this);
                    AndroidDebugBridge.removeDeviceChangeListener(DevicePanel.this);
                    AndroidDebugBridge.removeClientChangeListener(DevicePanel.this);
                }
            }
        });
        if (!iDevice.hasClients()) {
            ArrayList<IDevice> arrayList = this.mDevicesToExpand;
            synchronized (arrayList) {
                this.mDevicesToExpand.add(iDevice);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceDisconnected(IDevice iDevice) {
        this.deviceConnected(iDevice);
        ArrayList<IDevice> arrayList = this.mDevicesToExpand;
        synchronized (arrayList) {
            this.mDevicesToExpand.remove(iDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceChanged(final IDevice iDevice, int n) {
        boolean bl = false;
        ArrayList<IDevice> arrayList = this.mDevicesToExpand;
        synchronized (arrayList) {
            int n2 = this.mDevicesToExpand.indexOf(iDevice);
            if (iDevice.hasClients() && n2 != -1) {
                this.mDevicesToExpand.remove(n2);
                bl = true;
            }
        }
        final boolean bl2 = bl;
        this.exec(new Runnable(){

            public void run() {
                if (!DevicePanel.this.mTree.isDisposed()) {
                    IDevice iDevice2 = DevicePanel.this.getSelectedDevice();
                    DevicePanel.this.mTreeViewer.refresh((Object)iDevice);
                    if (iDevice2 == iDevice && DevicePanel.this.mTreeViewer.getSelection().isEmpty()) {
                        DevicePanel.this.mTreeViewer.setSelection((ISelection)new TreeSelection(new TreePath(new Object[]{iDevice})));
                    }
                    DevicePanel.this.notifyListeners();
                    if (bl2) {
                        DevicePanel.this.mTreeViewer.setExpandedState((Object)iDevice, true);
                    }
                } else {
                    AndroidDebugBridge.removeDebugBridgeChangeListener(DevicePanel.this);
                    AndroidDebugBridge.removeDeviceChangeListener(DevicePanel.this);
                    AndroidDebugBridge.removeClientChangeListener(DevicePanel.this);
                }
            }
        });
    }

    public void clientChanged(final Client client, final int n) {
        this.exec(new Runnable(){

            public void run() {
                if (!DevicePanel.this.mTree.isDisposed()) {
                    DevicePanel.this.mTreeViewer.refresh((Object)client);
                    if ((n & 2) == 2 && client.getClientData().getDebuggerConnectionStatus() == 2) {
                        IDevice iDevice = client.getDevice();
                        if (!DevicePanel.this.mTreeViewer.getExpandedState((Object)iDevice)) {
                            DevicePanel.this.mTreeViewer.setExpandedState((Object)iDevice, true);
                        }
                        TreePath treePath = new TreePath(new Object[]{iDevice, client});
                        TreeSelection treeSelection = new TreeSelection(treePath);
                        DevicePanel.this.mTreeViewer.setSelection((ISelection)treeSelection);
                        if (DevicePanel.this.mAdvancedPortSupport) {
                            client.setAsSelectedClient();
                        }
                        DevicePanel.this.notifyListeners(iDevice, client);
                    }
                } else {
                    AndroidDebugBridge.removeDebugBridgeChangeListener(DevicePanel.this);
                    AndroidDebugBridge.removeDeviceChangeListener(DevicePanel.this);
                    AndroidDebugBridge.removeClientChangeListener(DevicePanel.this);
                }
            }
        });
    }

    private void loadImages(Display display, IImageLoader iImageLoader) {
        if (this.mDeviceImage == null) {
            this.mDeviceImage = ImageHelper.loadImage(iImageLoader, display, "device.png", 16, 16, display.getSystemColor(3));
        }
        if (this.mEmulatorImage == null) {
            this.mEmulatorImage = ImageHelper.loadImage(iImageLoader, display, "emulator.png", 16, 16, display.getSystemColor(9));
        }
        if (this.mThreadImage == null) {
            this.mThreadImage = ImageHelper.loadImage(iImageLoader, display, ICON_THREAD, 16, 16, display.getSystemColor(7));
        }
        if (this.mHeapImage == null) {
            this.mHeapImage = ImageHelper.loadImage(iImageLoader, display, ICON_HEAP, 16, 16, display.getSystemColor(9));
        }
        if (this.mWaitingImage == null) {
            this.mWaitingImage = ImageHelper.loadImage(iImageLoader, display, "debug-wait.png", 16, 16, display.getSystemColor(3));
        }
        if (this.mDebuggerImage == null) {
            this.mDebuggerImage = ImageHelper.loadImage(iImageLoader, display, "debug-attach.png", 16, 16, display.getSystemColor(5));
        }
        if (this.mDebugErrorImage == null) {
            this.mDebugErrorImage = ImageHelper.loadImage(iImageLoader, display, "debug-error.png", 16, 16, display.getSystemColor(3));
        }
    }

    private static String getStateString(IDevice iDevice) {
        IDevice.DeviceState deviceState = iDevice.getState();
        if (deviceState == IDevice.DeviceState.ONLINE) {
            return "Online";
        }
        if (deviceState == IDevice.DeviceState.OFFLINE) {
            return "Offline";
        }
        if (deviceState == IDevice.DeviceState.BOOTLOADER) {
            return "Bootloader";
        }
        return "??";
    }

    private void exec(Runnable runnable) {
        try {
            Display display = this.mTree.getDisplay();
            display.asyncExec(runnable);
        }
        catch (SWTException sWTException) {
            AndroidDebugBridge.removeDebugBridgeChangeListener(this);
            AndroidDebugBridge.removeDeviceChangeListener(this);
            AndroidDebugBridge.removeClientChangeListener(this);
        }
    }

    private void notifyListeners() {
        TreeItem[] treeItemArray = this.mTree.getSelection();
        Client client = null;
        IDevice iDevice = null;
        if (treeItemArray.length == 1) {
            Object object = treeItemArray[0].getData();
            if (object instanceof Client) {
                client = (Client)object;
                iDevice = client.getDevice();
            } else if (object instanceof IDevice) {
                iDevice = (IDevice)object;
            }
        }
        this.notifyListeners(iDevice, client);
    }

    private void notifyListeners(IDevice iDevice, Client client) {
        if (iDevice != this.mCurrentDevice || client != this.mCurrentClient) {
            this.mCurrentDevice = iDevice;
            this.mCurrentClient = client;
            for (IUiSelectionListener iUiSelectionListener : this.mListeners) {
                try {
                    iUiSelectionListener.selectionChanged(iDevice, client);
                }
                catch (Exception exception) {}
            }
        }
    }

    private class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public Object[] getChildren(Object object) {
            if (object instanceof IDevice) {
                return ((IDevice)object).getClients();
            }
            return new Object[0];
        }

        public Object getParent(Object object) {
            if (object instanceof Client) {
                return ((Client)object).getDevice();
            }
            return null;
        }

        public boolean hasChildren(Object object) {
            if (object instanceof IDevice) {
                return ((IDevice)object).hasClients();
            }
            return false;
        }

        public Object[] getElements(Object object) {
            if (object instanceof AndroidDebugBridge) {
                return ((AndroidDebugBridge)object).getDevices();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    public static interface IUiSelectionListener {
        public void selectionChanged(IDevice var1, Client var2);
    }

    private class LabelProvider
    implements ITableLabelProvider {
        private LabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            if (n == 0 && object instanceof IDevice) {
                IDevice iDevice = (IDevice)object;
                if (iDevice.isEmulator()) {
                    return DevicePanel.this.mEmulatorImage;
                }
                return DevicePanel.this.mDeviceImage;
            }
            if (object instanceof Client) {
                Client client = (Client)object;
                ClientData clientData = client.getClientData();
                switch (n) {
                    case 0: {
                        switch (clientData.getDebuggerConnectionStatus()) {
                            case 1: {
                                return null;
                            }
                            case 2: {
                                return DevicePanel.this.mWaitingImage;
                            }
                            case 3: {
                                return DevicePanel.this.mDebuggerImage;
                            }
                            case 4: {
                                return DevicePanel.this.mDebugErrorImage;
                            }
                        }
                        return null;
                    }
                    case 2: {
                        if (client.isThreadUpdateEnabled()) {
                            return DevicePanel.this.mThreadImage;
                        }
                        return null;
                    }
                    case 3: {
                        if (client.isHeapUpdateEnabled()) {
                            return DevicePanel.this.mHeapImage;
                        }
                        return null;
                    }
                }
            }
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof IDevice) {
                IDevice iDevice = (IDevice)object;
                switch (n) {
                    case 0: {
                        return iDevice.getSerialNumber();
                    }
                    case 1: {
                        return DevicePanel.getStateString(iDevice);
                    }
                    case 4: {
                        String string = iDevice.getProperty("ro.build.version.release");
                        if (string != null) {
                            String string2 = iDevice.getProperty("ro.debuggable");
                            if (iDevice.isEmulator()) {
                                String string3 = iDevice.getAvdName();
                                if (string3 == null) {
                                    string3 = "?";
                                }
                                if (string2 != null && string2.equals("1")) {
                                    return String.format("%1$s [%2$s, debug]", string3, string);
                                }
                                return String.format("%1$s [%2$s]", string3, string);
                            }
                            if (string2 != null && string2.equals("1")) {
                                return String.format("%1$s, debug", string);
                            }
                            return String.format("%1$s", string);
                        }
                        return "unknown";
                    }
                }
            } else if (object instanceof Client) {
                Client client = (Client)object;
                ClientData clientData = client.getClientData();
                switch (n) {
                    case 0: {
                        String string = clientData.getClientDescription();
                        if (string != null) {
                            return string;
                        }
                        return "?";
                    }
                    case 1: {
                        return Integer.toString(clientData.getPid());
                    }
                    case 4: {
                        if (!DevicePanel.this.mAdvancedPortSupport) break;
                        int n2 = client.getDebuggerListenPort();
                        String string = "?";
                        if (n2 != 0) {
                            string = Integer.toString(n2);
                        }
                        if (client.isSelectedClient()) {
                            return String.format("%1$s / %2$d", string, DdmPreferences.getSelectedDebugPort());
                        }
                        return string;
                    }
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }
    }
}

