/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.Log;
import com.android.ddmlib.NativeStackCallInfo;
import com.android.ddmuilib.DdmUiPreferences;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;

public class Addr2Line {
    private static final HashMap<String, Addr2Line> sProcessCache = new HashMap();
    private static final byte[] sCrLf = new byte[]{10};
    private String mLibrary;
    private Process mProcess;
    private BufferedReader mResultReader;
    private BufferedOutputStream mAddressWriter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Addr2Line getProcess(String string) {
        if (string != null) {
            HashMap<String, Addr2Line> hashMap = sProcessCache;
            synchronized (hashMap) {
                Addr2Line addr2Line = sProcessCache.get(string);
                if (addr2Line == null) {
                    addr2Line = new Addr2Line(string);
                    boolean bl = addr2Line.start();
                    if (bl) {
                        sProcessCache.put(string, addr2Line);
                    } else {
                        addr2Line = null;
                    }
                }
                return addr2Line;
            }
        }
        return null;
    }

    private Addr2Line(String string) {
        this.mLibrary = string;
    }

    private boolean start() {
        block5: {
            String string = System.getenv("ANDROID_SYMBOLS");
            if (string == null) {
                string = DdmUiPreferences.getSymbolDirectory();
            }
            String[] stringArray = new String[]{DdmUiPreferences.getAddr2Line(), "-C", "-f", "-e", String.valueOf(string) + this.mLibrary.replaceAll("libc\\.so", "libc_debug\\.so")};
            try {
                this.mProcess = Runtime.getRuntime().exec(stringArray);
                if (this.mProcess != null) {
                    InputStreamReader inputStreamReader = new InputStreamReader(this.mProcess.getInputStream());
                    this.mResultReader = new BufferedReader(inputStreamReader);
                    this.mAddressWriter = new BufferedOutputStream(this.mProcess.getOutputStream());
                    if (this.mResultReader == null || this.mAddressWriter == null) {
                        this.mProcess.destroy();
                        this.mProcess = null;
                        return false;
                    }
                    return true;
                }
            }
            catch (IOException iOException) {
                String string2 = String.format("Error while trying to start %1$s process for library %2$s", DdmUiPreferences.getAddr2Line(), this.mLibrary);
                Log.e("ddm-Addr2Line", string2);
                if (this.mProcess == null) break block5;
                this.mProcess.destroy();
                this.mProcess = null;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        HashMap<String, Addr2Line> hashMap = sProcessCache;
        synchronized (hashMap) {
            if (this.mProcess != null) {
                sProcessCache.remove(this.mLibrary);
                this.mProcess.destroy();
                this.mProcess = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopAll() {
        HashMap<String, Addr2Line> hashMap = sProcessCache;
        synchronized (hashMap) {
            Collection<Addr2Line> collection = sProcessCache.values();
            for (Addr2Line addr2Line : collection) {
                addr2Line.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativeStackCallInfo getAddress(long l) {
        HashMap<String, Addr2Line> hashMap = sProcessCache;
        synchronized (hashMap) {
            if (this.mProcess != null) {
                String string = Long.toString(l, 16);
                try {
                    this.mAddressWriter.write(string.getBytes());
                    this.mAddressWriter.write(sCrLf);
                    this.mAddressWriter.flush();
                    String string2 = this.mResultReader.readLine();
                    String string3 = this.mResultReader.readLine();
                    if (string2 != null && string3 != null) {
                        return new NativeStackCallInfo(this.mLibrary, string2, string3);
                    }
                }
                catch (IOException iOException) {
                    Log.e("ddms", "Error while trying to get information for addr: " + string + " in library: " + this.mLibrary);
                }
            }
        }
        return null;
    }
}

