/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.log;

import com.android.ddmlib.utils.ArrayHelper;
import java.security.InvalidParameterException;

public final class LogReceiver {
    private static final int ENTRY_HEADER_SIZE = 20;
    private LogEntry mCurrentEntry;
    private byte[] mEntryHeaderBuffer = new byte[20];
    private int mEntryHeaderOffset = 0;
    private int mEntryDataOffset = 0;
    private ILogListener mListener;
    private boolean mIsCancelled = false;

    public LogReceiver(ILogListener iLogListener) {
        this.mListener = iLogListener;
    }

    public void parseNewData(byte[] byArray, int n, int n2) {
        if (this.mListener != null) {
            this.mListener.newData(byArray, n, n2);
        }
        while (n2 > 0 && !this.mIsCancelled) {
            int n3;
            if (this.mCurrentEntry == null) {
                if (this.mEntryHeaderOffset + n2 < 20) {
                    System.arraycopy(byArray, n, this.mEntryHeaderBuffer, this.mEntryHeaderOffset, n2);
                    this.mEntryHeaderOffset += n2;
                    return;
                }
                if (this.mEntryHeaderOffset != 0) {
                    n3 = 20 - this.mEntryHeaderOffset;
                    System.arraycopy(byArray, n, this.mEntryHeaderBuffer, this.mEntryHeaderOffset, n3);
                    this.mCurrentEntry = this.createEntry(this.mEntryHeaderBuffer, 0);
                    this.mEntryHeaderOffset = 0;
                    n += n3;
                    n2 -= n3;
                } else {
                    this.mCurrentEntry = this.createEntry(byArray, n);
                    n += 20;
                    n2 -= 20;
                }
            }
            if (n2 >= this.mCurrentEntry.len - this.mEntryDataOffset) {
                n3 = this.mCurrentEntry.len - this.mEntryDataOffset;
                System.arraycopy(byArray, n, this.mCurrentEntry.data, this.mEntryDataOffset, n3);
                if (this.mListener != null) {
                    this.mListener.newEntry(this.mCurrentEntry);
                }
                this.mEntryDataOffset = 0;
                this.mCurrentEntry = null;
                n += n3;
                n2 -= n3;
                continue;
            }
            System.arraycopy(byArray, n, this.mCurrentEntry.data, this.mEntryDataOffset, n2);
            this.mEntryDataOffset += n2;
            return;
        }
    }

    public boolean isCancelled() {
        return this.mIsCancelled;
    }

    public void cancel() {
        this.mIsCancelled = true;
    }

    private LogEntry createEntry(byte[] byArray, int n) {
        if (byArray.length < n + 20) {
            throw new InvalidParameterException("Buffer not big enough to hold full LoggerEntry header");
        }
        LogEntry logEntry = new LogEntry();
        logEntry.len = ArrayHelper.swapU16bitFromArray(byArray, n);
        logEntry.pid = ArrayHelper.swap32bitFromArray(byArray, n += 4);
        logEntry.tid = ArrayHelper.swap32bitFromArray(byArray, n += 4);
        logEntry.sec = ArrayHelper.swap32bitFromArray(byArray, n += 4);
        logEntry.nsec = ArrayHelper.swap32bitFromArray(byArray, n += 4);
        n += 4;
        logEntry.data = new byte[logEntry.len];
        return logEntry;
    }

    public static interface ILogListener {
        public void newEntry(LogEntry var1);

        public void newData(byte[] var1, int var2, int var3);
    }

    public static final class LogEntry {
        public int len;
        public int pid;
        public int tid;
        public int sec;
        public int nsec;
        public byte[] data;
    }
}

