/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.Device;
import com.android.ddmlib.FileListingService;
import com.android.ddmlib.Log;
import com.android.ddmlib.utils.ArrayHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;

public final class SyncService {
    private static final byte[] ID_OKAY = new byte[]{79, 75, 65, 89};
    private static final byte[] ID_FAIL = new byte[]{70, 65, 73, 76};
    private static final byte[] ID_STAT = new byte[]{83, 84, 65, 84};
    private static final byte[] ID_RECV = new byte[]{82, 69, 67, 86};
    private static final byte[] ID_DATA = new byte[]{68, 65, 84, 65};
    private static final byte[] ID_DONE = new byte[]{68, 79, 78, 69};
    private static final byte[] ID_SEND = new byte[]{83, 69, 78, 68};
    private static final NullSyncProgresMonitor sNullSyncProgressMonitor = new NullSyncProgresMonitor();
    private static final int S_ISOCK = 49152;
    private static final int S_IFLNK = 40960;
    private static final int S_IFREG = 32768;
    private static final int S_IFBLK = 24576;
    private static final int S_IFDIR = 16384;
    private static final int S_IFCHR = 8192;
    private static final int S_IFIFO = 4096;
    private static final int SYNC_DATA_MAX = 65536;
    private static final int REMOTE_PATH_MAX_LENGTH = 1024;
    public static final int RESULT_OK = 0;
    public static final int RESULT_CANCELED = 1;
    public static final int RESULT_UNKNOWN_ERROR = 2;
    public static final int RESULT_CONNECTION_ERROR = 3;
    public static final int RESULT_NO_REMOTE_OBJECT = 4;
    public static final int RESULT_TARGET_IS_FILE = 5;
    public static final int RESULT_NO_DIR_TARGET = 6;
    public static final int RESULT_REMOTE_PATH_ENCODING = 7;
    public static final int RESULT_REMOTE_PATH_LENGTH = 8;
    public static final int RESULT_FILE_WRITE_ERROR = 9;
    public static final int RESULT_FILE_READ_ERROR = 10;
    public static final int RESULT_NO_LOCAL_FILE = 11;
    public static final int RESULT_LOCAL_IS_DIRECTORY = 12;
    public static final int RESULT_REMOTE_IS_FILE = 13;
    public static final int RESULT_BUFFER_OVERRUN = 14;
    private InetSocketAddress mAddress;
    private Device mDevice;
    private SocketChannel mChannel;
    private byte[] mBuffer;

    SyncService(InetSocketAddress inetSocketAddress, Device device) {
        this.mAddress = inetSocketAddress;
        this.mDevice = device;
    }

    boolean openSync() throws IOException {
        try {
            this.mChannel = SocketChannel.open(this.mAddress);
            this.mChannel.configureBlocking(false);
            AdbHelper.setDevice(this.mChannel, this.mDevice);
            byte[] byArray = AdbHelper.formAdbRequest("sync:");
            AdbHelper.write(this.mChannel, byArray, -1, 5000);
            AdbHelper.AdbResponse adbResponse = AdbHelper.readAdbResponse(this.mChannel, false);
            if (!adbResponse.ioSuccess || !adbResponse.okay) {
                Log.w("ddms", "Got timeout or unhappy response from ADB sync req: " + adbResponse.message);
                this.mChannel.close();
                this.mChannel = null;
                return false;
            }
        }
        catch (IOException iOException) {
            if (this.mChannel != null) {
                try {
                    this.mChannel.close();
                }
                catch (IOException iOException2) {}
                this.mChannel = null;
            }
            throw iOException;
        }
        return true;
    }

    public void close() {
        if (this.mChannel != null) {
            try {
                this.mChannel.close();
            }
            catch (IOException iOException) {}
            this.mChannel = null;
        }
    }

    public static ISyncProgressMonitor getNullProgressMonitor() {
        return sNullSyncProgressMonitor;
    }

    private static String errorCodeToString(int n) {
        switch (n) {
            case 0: {
                return "Success.";
            }
            case 1: {
                return "Tranfert canceled by the user.";
            }
            case 2: {
                return "Unknown Error.";
            }
            case 3: {
                return "Adb Connection Error.";
            }
            case 4: {
                return "Remote object doesn't exist!";
            }
            case 5: {
                return "Target object is a file.";
            }
            case 6: {
                return "Target directory doesn't exist.";
            }
            case 7: {
                return "Remote Path encoding is not supported.";
            }
            case 8: {
                return "Remove path is too long.";
            }
            case 9: {
                return "Writing local file failed!";
            }
            case 10: {
                return "Reading local file failed!";
            }
            case 11: {
                return "Local file doesn't exist.";
            }
            case 12: {
                return "Local path is a directory.";
            }
            case 13: {
                return "Remote path is a file.";
            }
            case 14: {
                return "Receiving too much data.";
            }
        }
        throw new RuntimeException();
    }

    public SyncResult pull(FileListingService.FileEntry[] fileEntryArray, String string, ISyncProgressMonitor iSyncProgressMonitor) {
        File file = new File(string);
        if (!file.exists()) {
            return new SyncResult(6);
        }
        if (!file.isDirectory()) {
            return new SyncResult(5);
        }
        FileListingService fileListingService = new FileListingService(this.mDevice);
        int n = this.getTotalRemoteFileSize(fileEntryArray, fileListingService);
        iSyncProgressMonitor.start(n);
        SyncResult syncResult = this.doPull(fileEntryArray, string, fileListingService, iSyncProgressMonitor);
        iSyncProgressMonitor.stop();
        return syncResult;
    }

    public SyncResult pullFile(FileListingService.FileEntry fileEntry, String string, ISyncProgressMonitor iSyncProgressMonitor) {
        int n = fileEntry.getSizeValue();
        iSyncProgressMonitor.start(n);
        SyncResult syncResult = this.doPullFile(fileEntry.getFullPath(), string, iSyncProgressMonitor);
        iSyncProgressMonitor.stop();
        return syncResult;
    }

    public SyncResult push(String[] stringArray, FileListingService.FileEntry fileEntry, ISyncProgressMonitor iSyncProgressMonitor) {
        File[] fileArray;
        if (!fileEntry.isDirectory()) {
            return new SyncResult(13);
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            fileArray = stringArray2[n2];
            arrayList.add(new File((String)fileArray));
            ++n2;
        }
        fileArray = arrayList.toArray(new File[arrayList.size()]);
        n2 = this.getTotalLocalFileSize(fileArray);
        iSyncProgressMonitor.start(n2);
        SyncResult syncResult = this.doPush(fileArray, fileEntry.getFullPath(), iSyncProgressMonitor);
        iSyncProgressMonitor.stop();
        return syncResult;
    }

    public SyncResult pushFile(String string, String string2, ISyncProgressMonitor iSyncProgressMonitor) {
        File file = new File(string);
        if (!file.exists()) {
            return new SyncResult(11);
        }
        if (file.isDirectory()) {
            return new SyncResult(12);
        }
        iSyncProgressMonitor.start((int)file.length());
        SyncResult syncResult = this.doPushFile(string, string2, iSyncProgressMonitor);
        iSyncProgressMonitor.stop();
        return syncResult;
    }

    private int getTotalRemoteFileSize(FileListingService.FileEntry[] fileEntryArray, FileListingService fileListingService) {
        int n = 0;
        FileListingService.FileEntry[] fileEntryArray2 = fileEntryArray;
        int n2 = fileEntryArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FileListingService.FileEntry fileEntry = fileEntryArray2[n3];
            int n4 = fileEntry.getType();
            if (n4 == 1) {
                FileListingService.FileEntry[] fileEntryArray3 = fileListingService.getChildren(fileEntry, false, null);
                n += this.getTotalRemoteFileSize(fileEntryArray3, fileListingService) + 1;
            } else if (n4 == 0) {
                n += fileEntry.getSizeValue();
            }
            ++n3;
        }
        return n;
    }

    private int getTotalLocalFileSize(File[] fileArray) {
        int n = 0;
        File[] fileArray2 = fileArray;
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            File file = fileArray2[n3];
            if (file.exists()) {
                if (file.isDirectory()) {
                    return this.getTotalLocalFileSize(file.listFiles()) + 1;
                }
                if (file.isFile()) {
                    n = (int)((long)n + file.length());
                }
            }
            ++n3;
        }
        return n;
    }

    private SyncResult doPull(FileListingService.FileEntry[] fileEntryArray, String string, FileListingService fileListingService, ISyncProgressMonitor iSyncProgressMonitor) {
        FileListingService.FileEntry[] fileEntryArray2 = fileEntryArray;
        int n = fileEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object;
            String string2;
            FileListingService.FileEntry fileEntry = fileEntryArray2[n2];
            if (iSyncProgressMonitor.isCanceled()) {
                return new SyncResult(1);
            }
            int n3 = fileEntry.getType();
            if (n3 == 1) {
                iSyncProgressMonitor.startSubTask(fileEntry.getFullPath());
                string2 = String.valueOf(string) + File.separator + fileEntry.getName();
                object = new File(string2);
                ((File)object).mkdir();
                FileListingService.FileEntry[] fileEntryArray3 = fileListingService.getChildren(fileEntry, true, null);
                SyncResult syncResult = this.doPull(fileEntryArray3, string2, fileListingService, iSyncProgressMonitor);
                if (syncResult.mCode != 0) {
                    return syncResult;
                }
                iSyncProgressMonitor.advance(1);
            } else if (n3 == 0) {
                iSyncProgressMonitor.startSubTask(fileEntry.getFullPath());
                string2 = String.valueOf(string) + File.separator + fileEntry.getName();
                object = this.doPullFile(fileEntry.getFullPath(), string2, iSyncProgressMonitor);
                if (((SyncResult)object).mCode != 0) {
                    return object;
                }
            }
            ++n2;
        }
        return new SyncResult(0);
    }

    private SyncResult doPullFile(String string, String string2, ISyncProgressMonitor iSyncProgressMonitor) {
        Object object;
        byte[] byArray = null;
        byte[] byArray2 = new byte[8];
        try {
            object = string.getBytes("ISO-8859-1");
            if (((byte[])object).length > 1024) {
                return new SyncResult(8);
            }
            byArray = SyncService.createFileReq(ID_RECV, object);
            AdbHelper.write(this.mChannel, byArray, -1, 5000);
            AdbHelper.read(this.mChannel, byArray2, -1, 5000);
            if (!SyncService.checkResult(byArray2, ID_DATA) && !SyncService.checkResult(byArray2, ID_DONE)) {
                return new SyncResult(3);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new SyncResult(7, unsupportedEncodingException);
        }
        catch (IOException iOException) {
            return new SyncResult(3, iOException);
        }
        object = new File(string2);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream((File)object);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return new SyncResult(9, fileNotFoundException);
        }
        byte[] byArray3 = new byte[65536];
        while (true) {
            if (iSyncProgressMonitor.isCanceled()) {
                return new SyncResult(1);
            }
            if (SyncService.checkResult(byArray2, ID_DONE)) break;
            if (!SyncService.checkResult(byArray2, ID_DATA)) {
                return new SyncResult(3);
            }
            int n = ArrayHelper.swap32bitFromArray(byArray2, 4);
            if (n > 65536) {
                return new SyncResult(14);
            }
            try {
                AdbHelper.read(this.mChannel, byArray3, n, 5000);
                AdbHelper.read(this.mChannel, byArray2, -1, 5000);
            }
            catch (IOException iOException) {
                return new SyncResult(3, iOException);
            }
            try {
                fileOutputStream.write(byArray3, 0, n);
            }
            catch (IOException iOException) {
                return new SyncResult(9, iOException);
            }
            iSyncProgressMonitor.advance(n);
        }
        try {
            fileOutputStream.flush();
        }
        catch (IOException iOException) {
            return new SyncResult(9, iOException);
        }
        return new SyncResult(0);
    }

    private SyncResult doPush(File[] fileArray, String string, ISyncProgressMonitor iSyncProgressMonitor) {
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray2[n2];
            if (iSyncProgressMonitor.isCanceled()) {
                return new SyncResult(1);
            }
            if (file.exists()) {
                SyncResult syncResult;
                String string2;
                if (file.isDirectory()) {
                    string2 = String.valueOf(string) + "/" + file.getName();
                    iSyncProgressMonitor.startSubTask(string2);
                    syncResult = this.doPush(file.listFiles(), string2, iSyncProgressMonitor);
                    if (syncResult.mCode != 0) {
                        return syncResult;
                    }
                    iSyncProgressMonitor.advance(1);
                } else if (file.isFile()) {
                    string2 = String.valueOf(string) + "/" + file.getName();
                    iSyncProgressMonitor.startSubTask(string2);
                    syncResult = this.doPushFile(file.getAbsolutePath(), string2, iSyncProgressMonitor);
                    if (syncResult.mCode != 0) {
                        return syncResult;
                    }
                }
            }
            ++n2;
        }
        return new SyncResult(0);
    }

    private SyncResult doPushFile(String string, String string2, ISyncProgressMonitor iSyncProgressMonitor) {
        byte[] byArray;
        FileInputStream fileInputStream = null;
        try {
            byte[] byArray2 = string2.getBytes("ISO-8859-1");
            if (byArray2.length > 1024) {
                return new SyncResult(8);
            }
            File file = new File(string);
            if (!file.exists()) {
                return new SyncResult(11);
            }
            fileInputStream = new FileInputStream(file);
            byArray = SyncService.createSendFileReq(ID_SEND, byArray2, 420);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new SyncResult(7, unsupportedEncodingException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return new SyncResult(10, fileNotFoundException);
        }
        try {
            AdbHelper.write(this.mChannel, byArray, -1, 5000);
        }
        catch (IOException iOException) {
            return new SyncResult(3, iOException);
        }
        if (this.mBuffer == null) {
            this.mBuffer = new byte[65544];
        }
        System.arraycopy(ID_DATA, 0, this.mBuffer, 0, ID_DATA.length);
        while (true) {
            if (iSyncProgressMonitor.isCanceled()) {
                return new SyncResult(1);
            }
            int n = 0;
            try {
                n = fileInputStream.read(this.mBuffer, 8, 65536);
            }
            catch (IOException iOException) {
                return new SyncResult(10, iOException);
            }
            if (n == -1) break;
            ArrayHelper.swap32bitsToArray(n, this.mBuffer, 4);
            try {
                AdbHelper.write(this.mChannel, this.mBuffer, n + 8, 5000);
            }
            catch (IOException iOException) {
                return new SyncResult(3, iOException);
            }
            iSyncProgressMonitor.advance(n);
        }
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {
            return new SyncResult(10, iOException);
        }
        try {
            long l = System.currentTimeMillis() / 1000L;
            byArray = SyncService.createReq(ID_DONE, (int)l);
            AdbHelper.write(this.mChannel, byArray, -1, 5000);
            byte[] byArray3 = new byte[8];
            AdbHelper.read(this.mChannel, byArray3, -1, 5000);
            if (!SyncService.checkResult(byArray3, ID_OKAY)) {
                if (SyncService.checkResult(byArray3, ID_FAIL)) {
                    int n = ArrayHelper.swap32bitFromArray(byArray3, 4);
                    AdbHelper.read(this.mChannel, this.mBuffer, n, 5000);
                    String string3 = new String(this.mBuffer, 0, n);
                    Log.e("ddms", "transfer error: " + string3);
                    return new SyncResult(2, string3);
                }
                return new SyncResult(2);
            }
        }
        catch (IOException iOException) {
            return new SyncResult(3, iOException);
        }
        return new SyncResult(0);
    }

    private Integer readMode(String string) {
        byte[] byArray;
        block3: {
            try {
                byte[] byArray2 = SyncService.createFileReq(ID_STAT, string);
                AdbHelper.write(this.mChannel, byArray2, -1, 5000);
                byArray = new byte[16];
                AdbHelper.read(this.mChannel, byArray, -1, 5000);
                if (SyncService.checkResult(byArray, ID_STAT)) break block3;
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return ArrayHelper.swap32bitFromArray(byArray, 4);
    }

    private static byte[] createReq(byte[] byArray, int n) {
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, 0, byArray2, 0, 4);
        ArrayHelper.swap32bitsToArray(n, byArray2, 4);
        return byArray2;
    }

    private static byte[] createFileReq(byte[] byArray, String string) {
        byte[] byArray2 = null;
        try {
            byArray2 = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        return SyncService.createFileReq(byArray, byArray2);
    }

    private static byte[] createFileReq(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[8 + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, 4);
        ArrayHelper.swap32bitsToArray(byArray2.length, byArray3, 4);
        System.arraycopy(byArray2, 0, byArray3, 8, byArray2.length);
        return byArray3;
    }

    private static byte[] createSendFileReq(byte[] byArray, byte[] byArray2, int n) {
        String string = "," + (n & 0x1FF);
        byte[] byArray3 = null;
        try {
            byArray3 = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        byte[] byArray4 = new byte[8 + byArray2.length + byArray3.length];
        System.arraycopy(byArray, 0, byArray4, 0, 4);
        ArrayHelper.swap32bitsToArray(byArray2.length + byArray3.length, byArray4, 4);
        System.arraycopy(byArray2, 0, byArray4, 8, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, 8 + byArray2.length, byArray3.length);
        return byArray4;
    }

    private static boolean checkResult(byte[] byArray, byte[] byArray2) {
        return byArray[0] == byArray2[0] && byArray[1] == byArray2[1] && byArray[2] == byArray2[2] && byArray[3] == byArray2[3];
    }

    private static int getFileType(int n) {
        if ((n & 0xC000) == 49152) {
            return 6;
        }
        if ((n & 0xA000) == 40960) {
            return 5;
        }
        if ((n & 0x8000) == 32768) {
            return 0;
        }
        if ((n & 0x6000) == 24576) {
            return 3;
        }
        if ((n & 0x4000) == 16384) {
            return 1;
        }
        if ((n & 0x2000) == 8192) {
            return 4;
        }
        if ((n & 0x1000) == 4096) {
            return 7;
        }
        return 8;
    }

    public static interface ISyncProgressMonitor {
        public void start(int var1);

        public void stop();

        public boolean isCanceled();

        public void startSubTask(String var1);

        public void advance(int var1);
    }

    private static class NullSyncProgresMonitor
    implements ISyncProgressMonitor {
        private NullSyncProgresMonitor() {
        }

        public void advance(int n) {
        }

        public boolean isCanceled() {
            return false;
        }

        public void start(int n) {
        }

        public void startSubTask(String string) {
        }

        public void stop() {
        }
    }

    public static class SyncResult {
        private int mCode;
        private String mMessage;

        SyncResult(int n, String string) {
            this.mCode = n;
            this.mMessage = string;
        }

        SyncResult(int n, Exception exception) {
            this(n, exception.getMessage());
        }

        SyncResult(int n) {
            this(n, SyncService.errorCodeToString(n));
        }

        public int getCode() {
            return this.mCode;
        }

        public String getMessage() {
            return this.mMessage;
        }
    }
}

