/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.ChunkHandler;
import com.android.ddmlib.Client;
import com.android.ddmlib.JdwpPacket;
import com.android.ddmlib.Log;
import com.android.ddmlib.MonitorThread;
import java.io.IOException;
import java.nio.ByteBuffer;

final class HandleProfiling
extends ChunkHandler {
    public static final int CHUNK_MPRS = HandleProfiling.type("MPRS");
    public static final int CHUNK_MPRE = HandleProfiling.type("MPRE");
    public static final int CHUNK_MPRQ = HandleProfiling.type("MPRQ");
    private static final HandleProfiling mInst = new HandleProfiling();

    private HandleProfiling() {
    }

    public static void register(MonitorThread monitorThread) {
        monitorThread.registerChunkHandler(CHUNK_MPRE, mInst);
        monitorThread.registerChunkHandler(CHUNK_MPRQ, mInst);
    }

    public void clientReady(Client client) throws IOException {
    }

    public void clientDisconnected(Client client) {
    }

    public void handleChunk(Client client, int n, ByteBuffer byteBuffer, boolean bl, int n2) {
        Log.d("ddm-prof", "handling " + ChunkHandler.name(n));
        if (n == CHUNK_MPRE) {
            this.handleMPRE(client, byteBuffer);
        } else if (n == CHUNK_MPRQ) {
            this.handleMPRQ(client, byteBuffer);
        } else {
            this.handleUnknownChunk(client, n, byteBuffer, bl, n2);
        }
    }

    public static void sendMPRS(Client client, String string, int n, int n2) throws IOException {
        ByteBuffer byteBuffer = HandleProfiling.allocBuffer(12 + string.length() * 2);
        JdwpPacket jdwpPacket = new JdwpPacket(byteBuffer);
        ByteBuffer byteBuffer2 = HandleProfiling.getChunkDataBuf(byteBuffer);
        byteBuffer2.putInt(n);
        byteBuffer2.putInt(n2);
        byteBuffer2.putInt(string.length());
        HandleProfiling.putString(byteBuffer2, string);
        HandleProfiling.finishChunkPacket(jdwpPacket, CHUNK_MPRS, byteBuffer2.position());
        Log.d("ddm-prof", "Sending " + HandleProfiling.name(CHUNK_MPRS) + " '" + string + "', size=" + n + ", flags=" + n2);
        client.sendAndConsume(jdwpPacket, mInst);
    }

    public static void sendMPRE(Client client) throws IOException {
        ByteBuffer byteBuffer = HandleProfiling.allocBuffer(0);
        JdwpPacket jdwpPacket = new JdwpPacket(byteBuffer);
        ByteBuffer byteBuffer2 = HandleProfiling.getChunkDataBuf(byteBuffer);
        HandleProfiling.finishChunkPacket(jdwpPacket, CHUNK_MPRE, byteBuffer2.position());
        Log.d("ddm-prof", "Sending " + HandleProfiling.name(CHUNK_MPRE));
        client.sendAndConsume(jdwpPacket, mInst);
    }

    private void handleMPRE(Client client, ByteBuffer byteBuffer) {
        byte by = byteBuffer.get();
        if (by == 0) {
            Log.i("ddm-prof", "Method profiling has finished");
        } else {
            Log.w("ddm-prof", "Method profiling has failed (check device log)");
        }
    }

    public static void sendMPRQ(Client client) throws IOException {
        ByteBuffer byteBuffer = HandleProfiling.allocBuffer(0);
        JdwpPacket jdwpPacket = new JdwpPacket(byteBuffer);
        ByteBuffer byteBuffer2 = HandleProfiling.getChunkDataBuf(byteBuffer);
        HandleProfiling.finishChunkPacket(jdwpPacket, CHUNK_MPRQ, byteBuffer2.position());
        Log.d("ddm-prof", "Sending " + HandleProfiling.name(CHUNK_MPRQ));
        client.sendAndConsume(jdwpPacket, mInst);
    }

    private void handleMPRQ(Client client, ByteBuffer byteBuffer) {
        byte by = byteBuffer.get();
        if (by == 0) {
            Log.i("ddm-prof", "Method profiling is not running");
        } else {
            Log.i("ddm-prof", "Method profiling is running");
        }
    }
}

