/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AllocationInfo;
import com.android.ddmlib.ChunkHandler;
import com.android.ddmlib.Client;
import com.android.ddmlib.JdwpPacket;
import com.android.ddmlib.Log;
import com.android.ddmlib.MonitorThread;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;

final class HandleHeap
extends ChunkHandler {
    public static final int CHUNK_HPIF = HandleHeap.type("HPIF");
    public static final int CHUNK_HPST = HandleHeap.type("HPST");
    public static final int CHUNK_HPEN = HandleHeap.type("HPEN");
    public static final int CHUNK_HPSG = HandleHeap.type("HPSG");
    public static final int CHUNK_HPGC = HandleHeap.type("HPGC");
    public static final int CHUNK_HPDU = HandleHeap.type("HPDU");
    public static final int CHUNK_REAE = HandleHeap.type("REAE");
    public static final int CHUNK_REAQ = HandleHeap.type("REAQ");
    public static final int CHUNK_REAL = HandleHeap.type("REAL");
    public static final int WHEN_DISABLE = 0;
    public static final int WHEN_GC = 1;
    public static final int WHAT_MERGE = 0;
    public static final int WHAT_OBJ = 1;
    public static final int HPIF_WHEN_NEVER = 0;
    public static final int HPIF_WHEN_NOW = 1;
    public static final int HPIF_WHEN_NEXT_GC = 2;
    public static final int HPIF_WHEN_EVERY_GC = 3;
    private static final HandleHeap mInst = new HandleHeap();

    private HandleHeap() {
    }

    public static void register(MonitorThread monitorThread) {
        monitorThread.registerChunkHandler(CHUNK_HPIF, mInst);
        monitorThread.registerChunkHandler(CHUNK_HPST, mInst);
        monitorThread.registerChunkHandler(CHUNK_HPEN, mInst);
        monitorThread.registerChunkHandler(CHUNK_HPSG, mInst);
        monitorThread.registerChunkHandler(CHUNK_REAQ, mInst);
        monitorThread.registerChunkHandler(CHUNK_REAL, mInst);
    }

    public void clientReady(Client client) throws IOException {
        if (client.isHeapUpdateEnabled()) {
            HandleHeap.sendHPIF(client, 3);
        }
    }

    public void clientDisconnected(Client client) {
    }

    public void handleChunk(Client client, int n, ByteBuffer byteBuffer, boolean bl, int n2) {
        Log.d("ddm-heap", "handling " + ChunkHandler.name(n));
        if (n == CHUNK_HPIF) {
            this.handleHPIF(client, byteBuffer);
            client.update(64);
        } else if (n == CHUNK_HPST) {
            this.handleHPST(client, byteBuffer);
        } else if (n == CHUNK_HPEN) {
            this.handleHPEN(client, byteBuffer);
            client.update(64);
        } else if (n == CHUNK_HPSG) {
            this.handleHPSG(client, byteBuffer);
        } else if (n == CHUNK_HPDU) {
            this.handleHPDU(client, byteBuffer);
        } else if (n == CHUNK_REAQ) {
            this.handleREAQ(client, byteBuffer);
            client.update(1024);
        } else if (n == CHUNK_REAL) {
            this.handleREAL(client, byteBuffer);
            client.update(512);
        } else {
            this.handleUnknownChunk(client, n, byteBuffer, bl, n2);
        }
    }

    private void handleHPIF(Client client, ByteBuffer byteBuffer) {
        Log.d("ddm-heap", "HPIF!");
        try {
            int n = byteBuffer.getInt();
            int n2 = 0;
            while (n2 < n) {
                int n3 = byteBuffer.getInt();
                byteBuffer.getLong();
                byteBuffer.get();
                long l = (long)byteBuffer.getInt() & 0xFFFFFFFFFFFFFFFFL;
                long l2 = (long)byteBuffer.getInt() & 0xFFFFFFFFFFFFFFFFL;
                long l3 = (long)byteBuffer.getInt() & 0xFFFFFFFFFFFFFFFFL;
                long l4 = (long)byteBuffer.getInt() & 0xFFFFFFFFFFFFFFFFL;
                client.getClientData().setHeapInfo(n3, l, l2, l3, l4);
                ++n2;
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            Log.w("ddm-heap", "malformed HPIF chunk from client");
        }
    }

    public static void sendHPIF(Client client, int n) throws IOException {
        ByteBuffer byteBuffer = HandleHeap.allocBuffer(1);
        JdwpPacket jdwpPacket = new JdwpPacket(byteBuffer);
        ByteBuffer byteBuffer2 = HandleHeap.getChunkDataBuf(byteBuffer);
        byteBuffer2.put((byte)n);
        HandleHeap.finishChunkPacket(jdwpPacket, CHUNK_HPIF, byteBuffer2.position());
        Log.d("ddm-heap", "Sending " + HandleHeap.name(CHUNK_HPIF) + ": when=" + n);
        client.sendAndConsume(jdwpPacket, mInst);
    }

    private void handleHPST(Client client, ByteBuffer byteBuffer) {
        client.getClientData().getVmHeapData().clearHeapData();
    }

    private void handleHPEN(Client client, ByteBuffer byteBuffer) {
        client.getClientData().getVmHeapData().sealHeapData();
    }

    private void handleHPSG(Client client, ByteBuffer byteBuffer) {
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.rewind();
        byteBuffer.get(byArray);
        byteBuffer = ByteBuffer.wrap(byArray);
        client.getClientData().getVmHeapData().addHeapData(byteBuffer);
    }

    public static void sendHPSG(Client client, int n, int n2) throws IOException {
        ByteBuffer byteBuffer = HandleHeap.allocBuffer(2);
        JdwpPacket jdwpPacket = new JdwpPacket(byteBuffer);
        ByteBuffer byteBuffer2 = HandleHeap.getChunkDataBuf(byteBuffer);
        byteBuffer2.put((byte)n);
        byteBuffer2.put((byte)n2);
        HandleHeap.finishChunkPacket(jdwpPacket, CHUNK_HPSG, byteBuffer2.position());
        Log.d("ddm-heap", "Sending " + HandleHeap.name(CHUNK_HPSG) + ": when=" + n + ", what=" + n2);
        client.sendAndConsume(jdwpPacket, mInst);
    }

    public static void sendHPGC(Client client) throws IOException {
        ByteBuffer byteBuffer = HandleHeap.allocBuffer(0);
        JdwpPacket jdwpPacket = new JdwpPacket(byteBuffer);
        ByteBuffer byteBuffer2 = HandleHeap.getChunkDataBuf(byteBuffer);
        HandleHeap.finishChunkPacket(jdwpPacket, CHUNK_HPGC, byteBuffer2.position());
        Log.d("ddm-heap", "Sending " + HandleHeap.name(CHUNK_HPGC));
        client.sendAndConsume(jdwpPacket, mInst);
    }

    public static void sendHPDU(Client client, String string) throws IOException {
        ByteBuffer byteBuffer = HandleHeap.allocBuffer(4 + string.length() * 2);
        JdwpPacket jdwpPacket = new JdwpPacket(byteBuffer);
        ByteBuffer byteBuffer2 = HandleHeap.getChunkDataBuf(byteBuffer);
        byteBuffer2.putInt(string.length());
        HandleHeap.putString(byteBuffer2, string);
        HandleHeap.finishChunkPacket(jdwpPacket, CHUNK_HPDU, byteBuffer2.position());
        Log.d("ddm-heap", "Sending " + HandleHeap.name(CHUNK_HPDU) + " '" + string + "'");
        client.sendAndConsume(jdwpPacket, mInst);
    }

    private void handleHPDU(Client client, ByteBuffer byteBuffer) {
        byte by = byteBuffer.get();
        if (by == 0) {
            Log.i("ddm-heap", "Heap dump request has finished");
        } else {
            Log.w("ddm-heap", "Heap dump request failed (check device log)");
        }
    }

    public static void sendREAE(Client client, boolean bl) throws IOException {
        ByteBuffer byteBuffer = HandleHeap.allocBuffer(1);
        JdwpPacket jdwpPacket = new JdwpPacket(byteBuffer);
        ByteBuffer byteBuffer2 = HandleHeap.getChunkDataBuf(byteBuffer);
        byteBuffer2.put((byte)(bl ? 1 : 0));
        HandleHeap.finishChunkPacket(jdwpPacket, CHUNK_REAE, byteBuffer2.position());
        Log.d("ddm-heap", "Sending " + HandleHeap.name(CHUNK_REAE) + ": " + bl);
        client.sendAndConsume(jdwpPacket, mInst);
    }

    public static void sendREAQ(Client client) throws IOException {
        ByteBuffer byteBuffer = HandleHeap.allocBuffer(0);
        JdwpPacket jdwpPacket = new JdwpPacket(byteBuffer);
        ByteBuffer byteBuffer2 = HandleHeap.getChunkDataBuf(byteBuffer);
        HandleHeap.finishChunkPacket(jdwpPacket, CHUNK_REAQ, byteBuffer2.position());
        Log.d("ddm-heap", "Sending " + HandleHeap.name(CHUNK_REAQ));
        client.sendAndConsume(jdwpPacket, mInst);
    }

    public static void sendREAL(Client client) throws IOException {
        ByteBuffer byteBuffer = HandleHeap.allocBuffer(0);
        JdwpPacket jdwpPacket = new JdwpPacket(byteBuffer);
        ByteBuffer byteBuffer2 = HandleHeap.getChunkDataBuf(byteBuffer);
        HandleHeap.finishChunkPacket(jdwpPacket, CHUNK_REAL, byteBuffer2.position());
        Log.d("ddm-heap", "Sending " + HandleHeap.name(CHUNK_REAL));
        client.sendAndConsume(jdwpPacket, mInst);
    }

    private void handleREAQ(Client client, ByteBuffer byteBuffer) {
        boolean bl = byteBuffer.get() != 0;
        Log.d("ddm-heap", "REAQ says: enabled=" + bl);
        client.getClientData().setAllocationStatus(bl);
    }

    private String descriptorToDot(String string) {
        int n = 0;
        while (string.startsWith("[")) {
            string = string.substring(1);
            ++n;
        }
        int n2 = string.length();
        if (n2 >= 2 && string.charAt(0) == 'L' && string.charAt(n2 - 1) == ';') {
            string = string.substring(1, n2 - 1);
            string = string.replace('/', '.');
        } else if ("C".equals(string)) {
            string = "char";
        } else if ("B".equals(string)) {
            string = "byte";
        } else if ("Z".equals(string)) {
            string = "boolean";
        } else if ("S".equals(string)) {
            string = "short";
        } else if ("I".equals(string)) {
            string = "int";
        } else if ("J".equals(string)) {
            string = "long";
        } else if ("F".equals(string)) {
            string = "float";
        } else if ("D".equals(string)) {
            string = "double";
        }
        int n3 = 0;
        while (n3 < n) {
            string = String.valueOf(string) + "[]";
            ++n3;
        }
        return string;
    }

    private void readStringTable(ByteBuffer byteBuffer, String[] stringArray) {
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = byteBuffer.getInt();
            String string = HandleHeap.getString(byteBuffer, n3);
            stringArray[n2] = this.descriptorToDot(string);
            ++n2;
        }
    }

    private void handleREAL(Client client, ByteBuffer byteBuffer) {
        Log.e("ddm-heap", "*** Received " + HandleHeap.name(CHUNK_REAL));
        int n = byteBuffer.get() & 0xFF;
        int n2 = byteBuffer.get() & 0xFF;
        int n3 = byteBuffer.get() & 0xFF;
        int n4 = byteBuffer.getShort() & 0xFFFF;
        int n5 = byteBuffer.getInt();
        int n6 = byteBuffer.getShort() & 0xFFFF;
        int n7 = byteBuffer.getShort() & 0xFFFF;
        int n8 = byteBuffer.getShort() & 0xFFFF;
        byteBuffer.position(n5);
        String[] stringArray = new String[n6];
        String[] stringArray2 = new String[n7];
        String[] stringArray3 = new String[n8];
        this.readStringTable(byteBuffer, stringArray);
        this.readStringTable(byteBuffer, stringArray2);
        this.readStringTable(byteBuffer, stringArray3);
        byteBuffer.position(n);
        ArrayList<AllocationInfo> arrayList = new ArrayList<AllocationInfo>(n4);
        int n9 = 0;
        while (n9 < n4) {
            int n10 = byteBuffer.getInt();
            int n11 = byteBuffer.getShort() & 0xFFFF;
            int n12 = byteBuffer.getShort() & 0xFFFF;
            int n13 = byteBuffer.get() & 0xFF;
            int n14 = 9;
            while (n14 < n2) {
                byteBuffer.get();
                ++n14;
            }
            StackTraceElement[] stackTraceElementArray = new StackTraceElement[n13];
            int n15 = 0;
            while (n15 < n13) {
                int n16 = byteBuffer.getShort() & 0xFFFF;
                int n17 = byteBuffer.getShort() & 0xFFFF;
                int n18 = byteBuffer.getShort() & 0xFFFF;
                short s = byteBuffer.getShort();
                String string = stringArray[n16];
                String string2 = stringArray2[n17];
                String string3 = stringArray3[n18];
                stackTraceElementArray[n15] = new StackTraceElement(string, string2, string3, s);
                int n19 = 9;
                while (n19 < n3) {
                    byteBuffer.get();
                    ++n19;
                }
                ++n15;
            }
            arrayList.add(new AllocationInfo(stringArray[n12], n10, (short)n11, stackTraceElementArray));
            ++n9;
        }
        Collections.sort(arrayList);
        client.getClientData().setAllocations(arrayList.toArray(new AllocationInfo[n4]));
    }

    private static void dumpRecords(AllocationInfo[] allocationInfoArray) {
        System.out.println("Found " + allocationInfoArray.length + " records:");
        AllocationInfo[] allocationInfoArray2 = allocationInfoArray;
        int n = allocationInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            AllocationInfo allocationInfo = allocationInfoArray2[n2];
            System.out.println("tid=" + allocationInfo.getThreadId() + " " + allocationInfo.getAllocatedClass() + " (" + allocationInfo.getSize() + " bytes)");
            StackTraceElement[] stackTraceElementArray = allocationInfo.getStackTrace();
            int n3 = stackTraceElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                StackTraceElement stackTraceElement = stackTraceElementArray[n4];
                if (stackTraceElement.isNativeMethod()) {
                    System.out.println("    " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + " (Native method)");
                } else {
                    System.out.println("    " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + " (" + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ")");
                }
                ++n4;
            }
            ++n2;
        }
    }
}

