/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.DebugPortManager;
import com.android.ddmlib.Device;
import com.android.ddmlib.DeviceMonitor;
import com.android.ddmlib.JdwpPacket;
import com.android.ddmlib.Log;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

abstract class ChunkHandler {
    public static final int CHUNK_HEADER_LEN = 8;
    public static final ByteOrder CHUNK_ORDER = ByteOrder.BIG_ENDIAN;
    public static final int CHUNK_FAIL = ChunkHandler.type("FAIL");

    ChunkHandler() {
    }

    abstract void clientReady(Client var1) throws IOException;

    abstract void clientDisconnected(Client var1);

    abstract void handleChunk(Client var1, int var2, ByteBuffer var3, boolean var4, int var5);

    protected void handleUnknownChunk(Client client, int n, ByteBuffer byteBuffer, boolean bl, int n2) {
        if (n == CHUNK_FAIL) {
            int n3 = byteBuffer.getInt();
            int n4 = byteBuffer.getInt();
            String string = ChunkHandler.getString(byteBuffer, n4);
            Log.w("ddms", "WARNING: failure code=" + n3 + " msg=" + string);
        } else {
            Log.w("ddms", "WARNING: received unknown chunk " + ChunkHandler.name(n) + ": len=" + byteBuffer.limit() + ", reply=" + bl + ", msgId=0x" + Integer.toHexString(n2));
        }
        Log.w("ddms", "         client " + client + ", handler " + this);
    }

    static String getString(ByteBuffer byteBuffer, int n) {
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = byteBuffer.getChar();
            ++n2;
        }
        return new String(cArray);
    }

    static void putString(ByteBuffer byteBuffer, String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            byteBuffer.putChar(string.charAt(n2));
            ++n2;
        }
    }

    static int type(String string) {
        int n = 0;
        if (string.length() != 4) {
            Log.e("ddms", "Type name must be 4 letter long");
            throw new RuntimeException("Type name must be 4 letter long");
        }
        int n2 = 0;
        while (n2 < 4) {
            n <<= 8;
            n |= (byte)string.charAt(n2);
            ++n2;
        }
        return n;
    }

    static String name(int n) {
        char[] cArray = new char[]{(char)(n >> 24 & 0xFF), (char)(n >> 16 & 0xFF), (char)(n >> 8 & 0xFF), (char)(n & 0xFF)};
        return new String(cArray);
    }

    static ByteBuffer allocBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(19 + n);
        byteBuffer.order(CHUNK_ORDER);
        return byteBuffer;
    }

    static ByteBuffer getChunkDataBuf(ByteBuffer byteBuffer) {
        assert (byteBuffer.position() == 0);
        byteBuffer.position(19);
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer2.order(CHUNK_ORDER);
        byteBuffer.position(0);
        return byteBuffer2;
    }

    static void finishChunkPacket(JdwpPacket jdwpPacket, int n, int n2) {
        ByteBuffer byteBuffer = jdwpPacket.getPayload();
        byteBuffer.putInt(0, n);
        byteBuffer.putInt(4, n2);
        jdwpPacket.finishPacket(8 + n2);
    }

    protected static Client checkDebuggerPortForAppName(Client client, String string) {
        DeviceMonitor deviceMonitor;
        AndroidDebugBridge androidDebugBridge;
        Device device;
        int n;
        DebugPortManager.IDebugPortProvider iDebugPortProvider = DebugPortManager.getProvider();
        if (iDebugPortProvider != null && (n = iDebugPortProvider.getPort(device = client.getDeviceImpl(), string)) != -1 && n != client.getDebuggerListenPort() && (androidDebugBridge = AndroidDebugBridge.getBridge()) != null && (deviceMonitor = androidDebugBridge.getDeviceMonitor()) != null) {
            deviceMonitor.addClientToDropAndReopen(client, n);
            client = null;
        }
        return client;
    }
}

