/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.Client;
import com.android.ddmlib.DeviceMonitor;
import com.android.ddmlib.HandleAppName;
import com.android.ddmlib.HandleHeap;
import com.android.ddmlib.HandleHello;
import com.android.ddmlib.HandleProfiling;
import com.android.ddmlib.HandleTest;
import com.android.ddmlib.HandleThread;
import com.android.ddmlib.HandleWait;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.MonitorThread;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AndroidDebugBridge {
    private static final int ADB_VERSION_MICRO_MIN = 20;
    private static final int ADB_VERSION_MICRO_MAX = -1;
    private static final Pattern sAdbVersion = Pattern.compile("^.*(\\d+)\\.(\\d+)\\.(\\d+)$");
    private static final String ADB = "adb";
    private static final String DDMS = "ddms";
    static final String ADB_HOST = "127.0.0.1";
    static final int ADB_PORT = 5037;
    static InetAddress sHostAddr;
    static InetSocketAddress sSocketAddr;
    private static AndroidDebugBridge sThis;
    private static boolean sClientSupport;
    private String mAdbOsLocation = null;
    private boolean mVersionCheck;
    private boolean mStarted = false;
    private DeviceMonitor mDeviceMonitor;
    private static final ArrayList<IDebugBridgeChangeListener> sBridgeListeners;
    private static final ArrayList<IDeviceChangeListener> sDeviceListeners;
    private static final ArrayList<IClientChangeListener> sClientListeners;
    private static final Object sLock;

    static {
        try {
            sHostAddr = InetAddress.getByName(ADB_HOST);
            sSocketAddr = new InetSocketAddress(sHostAddr, 5037);
        }
        catch (UnknownHostException unknownHostException) {}
        sBridgeListeners = new ArrayList();
        sDeviceListeners = new ArrayList();
        sClientListeners = new ArrayList();
        sLock = sBridgeListeners;
    }

    public static void init(boolean bl) {
        sClientSupport = bl;
        MonitorThread monitorThread = MonitorThread.createInstance();
        monitorThread.start();
        HandleHello.register(monitorThread);
        HandleAppName.register(monitorThread);
        HandleTest.register(monitorThread);
        HandleThread.register(monitorThread);
        HandleHeap.register(monitorThread);
        HandleWait.register(monitorThread);
        HandleProfiling.register(monitorThread);
    }

    public static void terminate() {
        MonitorThread monitorThread;
        if (sThis != null && AndroidDebugBridge.sThis.mDeviceMonitor != null) {
            AndroidDebugBridge.sThis.mDeviceMonitor.stop();
            AndroidDebugBridge.sThis.mDeviceMonitor = null;
        }
        if ((monitorThread = MonitorThread.getInstance()) != null) {
            monitorThread.quit();
        }
    }

    static boolean getClientSupport() {
        return sClientSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AndroidDebugBridge createBridge() {
        Object object = sLock;
        synchronized (object) {
            IDebugBridgeChangeListener[] iDebugBridgeChangeListenerArray;
            if (sThis != null) {
                return sThis;
            }
            try {
                sThis = new AndroidDebugBridge();
                sThis.start();
            }
            catch (InvalidParameterException invalidParameterException) {
                sThis = null;
            }
            IDebugBridgeChangeListener[] iDebugBridgeChangeListenerArray2 = iDebugBridgeChangeListenerArray = sBridgeListeners.toArray(new IDebugBridgeChangeListener[sBridgeListeners.size()]);
            int n = iDebugBridgeChangeListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDebugBridgeChangeListener iDebugBridgeChangeListener = iDebugBridgeChangeListenerArray2[n2];
                try {
                    iDebugBridgeChangeListener.bridgeChanged(sThis);
                }
                catch (Exception exception) {
                    Log.e(DDMS, exception);
                }
                ++n2;
            }
            return sThis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AndroidDebugBridge createBridge(String string, boolean bl) {
        Object object = sLock;
        synchronized (object) {
            IDebugBridgeChangeListener[] iDebugBridgeChangeListenerArray;
            if (sThis != null) {
                if (AndroidDebugBridge.sThis.mAdbOsLocation != null && AndroidDebugBridge.sThis.mAdbOsLocation.equals(string) && !bl) {
                    return sThis;
                }
                sThis.stop();
            }
            try {
                sThis = new AndroidDebugBridge(string);
                sThis.start();
            }
            catch (InvalidParameterException invalidParameterException) {
                sThis = null;
            }
            IDebugBridgeChangeListener[] iDebugBridgeChangeListenerArray2 = iDebugBridgeChangeListenerArray = sBridgeListeners.toArray(new IDebugBridgeChangeListener[sBridgeListeners.size()]);
            int n = iDebugBridgeChangeListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDebugBridgeChangeListener iDebugBridgeChangeListener = iDebugBridgeChangeListenerArray2[n2];
                try {
                    iDebugBridgeChangeListener.bridgeChanged(sThis);
                }
                catch (Exception exception) {
                    Log.e(DDMS, exception);
                }
                ++n2;
            }
            return sThis;
        }
    }

    public static AndroidDebugBridge getBridge() {
        return sThis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disconnectBridge() {
        Object object = sLock;
        synchronized (object) {
            if (sThis != null) {
                IDebugBridgeChangeListener[] iDebugBridgeChangeListenerArray;
                sThis.stop();
                sThis = null;
                IDebugBridgeChangeListener[] iDebugBridgeChangeListenerArray2 = iDebugBridgeChangeListenerArray = sBridgeListeners.toArray(new IDebugBridgeChangeListener[sBridgeListeners.size()]);
                int n = iDebugBridgeChangeListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IDebugBridgeChangeListener iDebugBridgeChangeListener = iDebugBridgeChangeListenerArray2[n2];
                    try {
                        iDebugBridgeChangeListener.bridgeChanged(sThis);
                    }
                    catch (Exception exception) {
                        Log.e(DDMS, exception);
                    }
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDebugBridgeChangeListener(IDebugBridgeChangeListener iDebugBridgeChangeListener) {
        Object object = sLock;
        synchronized (object) {
            if (!sBridgeListeners.contains(iDebugBridgeChangeListener)) {
                sBridgeListeners.add(iDebugBridgeChangeListener);
                if (sThis != null) {
                    try {
                        iDebugBridgeChangeListener.bridgeChanged(sThis);
                    }
                    catch (Exception exception) {
                        Log.e(DDMS, exception);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDebugBridgeChangeListener(IDebugBridgeChangeListener iDebugBridgeChangeListener) {
        Object object = sLock;
        synchronized (object) {
            sBridgeListeners.remove(iDebugBridgeChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDeviceChangeListener(IDeviceChangeListener iDeviceChangeListener) {
        Object object = sLock;
        synchronized (object) {
            if (!sDeviceListeners.contains(iDeviceChangeListener)) {
                sDeviceListeners.add(iDeviceChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDeviceChangeListener(IDeviceChangeListener iDeviceChangeListener) {
        Object object = sLock;
        synchronized (object) {
            sDeviceListeners.remove(iDeviceChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addClientChangeListener(IClientChangeListener iClientChangeListener) {
        Object object = sLock;
        synchronized (object) {
            if (!sClientListeners.contains(iClientChangeListener)) {
                sClientListeners.add(iClientChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeClientChangeListener(IClientChangeListener iClientChangeListener) {
        Object object = sLock;
        synchronized (object) {
            sClientListeners.remove(iClientChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDevice[] getDevices() {
        Object object = sLock;
        synchronized (object) {
            if (this.mDeviceMonitor != null) {
                return this.mDeviceMonitor.getDevices();
            }
        }
        return new IDevice[0];
    }

    public boolean hasInitialDeviceList() {
        if (this.mDeviceMonitor != null) {
            return this.mDeviceMonitor.hasInitialDeviceList();
        }
        return false;
    }

    public void setSelectedClient(Client client) {
        MonitorThread monitorThread = MonitorThread.getInstance();
        if (monitorThread != null) {
            monitorThread.setSelectedClient(client);
        }
    }

    public boolean isConnected() {
        MonitorThread monitorThread = MonitorThread.getInstance();
        if (this.mDeviceMonitor != null && monitorThread != null) {
            return this.mDeviceMonitor.isMonitoring() && monitorThread.getState() != Thread.State.TERMINATED;
        }
        return false;
    }

    public int getConnectionAttemptCount() {
        if (this.mDeviceMonitor != null) {
            return this.mDeviceMonitor.getConnectionAttemptCount();
        }
        return -1;
    }

    public int getRestartAttemptCount() {
        if (this.mDeviceMonitor != null) {
            return this.mDeviceMonitor.getRestartAttemptCount();
        }
        return -1;
    }

    private AndroidDebugBridge(String string) throws InvalidParameterException {
        if (string == null || string.length() == 0) {
            throw new InvalidParameterException();
        }
        this.mAdbOsLocation = string;
        this.checkAdbVersion();
    }

    private AndroidDebugBridge() {
    }

    private void checkAdbVersion() {
        this.mVersionCheck = false;
        if (this.mAdbOsLocation == null) {
            return;
        }
        try {
            String[] stringArray = new String[]{this.mAdbOsLocation, "version"};
            Log.d(DDMS, String.format("Checking '%1$s version'", this.mAdbOsLocation));
            Process process = Runtime.getRuntime().exec(stringArray);
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            int n = this.grabProcessOutput(process, arrayList, arrayList2, true);
            if (n != 0) {
                StringBuilder stringBuilder = new StringBuilder("'adb version' failed!");
                for (String string : arrayList) {
                    stringBuilder.append('\n');
                    stringBuilder.append(string);
                }
                Log.logAndDisplay(Log.LogLevel.ERROR, ADB, stringBuilder.toString());
            }
            boolean bl = false;
            for (String string : arrayList2) {
                bl = this.scanVersionLine(string);
                if (bl) break;
            }
            if (!bl) {
                for (String string : arrayList) {
                    bl = this.scanVersionLine(string);
                    if (bl) break;
                }
            }
            if (!bl) {
                Log.logAndDisplay(Log.LogLevel.ERROR, ADB, "Failed to parse the output of 'adb version'");
            }
        }
        catch (IOException iOException) {
            Log.logAndDisplay(Log.LogLevel.ERROR, ADB, "Failed to get the adb version: " + iOException.getMessage());
        }
        catch (InterruptedException interruptedException) {}
    }

    private boolean scanVersionLine(String string) {
        Matcher matcher;
        if (string != null && (matcher = sAdbVersion.matcher(string)).matches()) {
            int n = Integer.parseInt(matcher.group(1));
            int n2 = Integer.parseInt(matcher.group(2));
            int n3 = Integer.parseInt(matcher.group(3));
            if (n3 < 20) {
                String string2 = String.format("Required minimum version of adb: %1$d.%2$d.%3$d.Current version is %1$d.%2$d.%4$d", n, n2, 20, n3);
                Log.logAndDisplay(Log.LogLevel.ERROR, ADB, string2);
            } else {
                this.mVersionCheck = true;
            }
            return true;
        }
        return false;
    }

    boolean start() {
        if (!(this.mAdbOsLocation == null || this.mVersionCheck && this.startAdb())) {
            return false;
        }
        this.mStarted = true;
        this.mDeviceMonitor = new DeviceMonitor(this);
        this.mDeviceMonitor.start();
        return true;
    }

    boolean stop() {
        if (!this.mStarted) {
            return false;
        }
        this.mDeviceMonitor.stop();
        this.mDeviceMonitor = null;
        if (!this.stopAdb()) {
            return false;
        }
        this.mStarted = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restart() {
        if (this.mAdbOsLocation == null) {
            Log.e(ADB, "Cannot restart adb when AndroidDebugBridge is created without the location of adb.");
            return false;
        }
        if (!this.mVersionCheck) {
            Log.logAndDisplay(Log.LogLevel.ERROR, ADB, "Attempting to restart adb, but version check failed!");
            return false;
        }
        AndroidDebugBridge androidDebugBridge = this;
        synchronized (androidDebugBridge) {
            this.stopAdb();
            boolean bl = this.startAdb();
            if (bl && this.mDeviceMonitor == null) {
                this.mDeviceMonitor = new DeviceMonitor(this);
                this.mDeviceMonitor.start();
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deviceConnected(IDevice iDevice) {
        IDeviceChangeListener[] iDeviceChangeListenerArray = null;
        Object object = sLock;
        synchronized (object) {
            iDeviceChangeListenerArray = sDeviceListeners.toArray(new IDeviceChangeListener[sDeviceListeners.size()]);
        }
        IDeviceChangeListener[] iDeviceChangeListenerArray2 = iDeviceChangeListenerArray;
        int n = iDeviceChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = iDeviceChangeListenerArray2[n2];
            try {
                object.deviceConnected(iDevice);
            }
            catch (Exception exception) {
                Log.e(DDMS, exception);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deviceDisconnected(IDevice iDevice) {
        IDeviceChangeListener[] iDeviceChangeListenerArray = null;
        Object object = sLock;
        synchronized (object) {
            iDeviceChangeListenerArray = sDeviceListeners.toArray(new IDeviceChangeListener[sDeviceListeners.size()]);
        }
        IDeviceChangeListener[] iDeviceChangeListenerArray2 = iDeviceChangeListenerArray;
        int n = iDeviceChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = iDeviceChangeListenerArray2[n2];
            try {
                object.deviceDisconnected(iDevice);
            }
            catch (Exception exception) {
                Log.e(DDMS, exception);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deviceChanged(IDevice iDevice, int n) {
        IDeviceChangeListener[] iDeviceChangeListenerArray = null;
        Object object = sLock;
        synchronized (object) {
            iDeviceChangeListenerArray = sDeviceListeners.toArray(new IDeviceChangeListener[sDeviceListeners.size()]);
        }
        IDeviceChangeListener[] iDeviceChangeListenerArray2 = iDeviceChangeListenerArray;
        int n2 = iDeviceChangeListenerArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object = iDeviceChangeListenerArray2[n3];
            try {
                object.deviceChanged(iDevice, n);
            }
            catch (Exception exception) {
                Log.e(DDMS, exception);
            }
            ++n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clientChanged(Client client, int n) {
        IClientChangeListener[] iClientChangeListenerArray = null;
        Object object = sLock;
        synchronized (object) {
            iClientChangeListenerArray = sClientListeners.toArray(new IClientChangeListener[sClientListeners.size()]);
        }
        IClientChangeListener[] iClientChangeListenerArray2 = iClientChangeListenerArray;
        int n2 = iClientChangeListenerArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object = iClientChangeListenerArray2[n3];
            try {
                object.clientChanged(client, n);
            }
            catch (Exception exception) {
                Log.e(DDMS, exception);
            }
            ++n3;
        }
    }

    DeviceMonitor getDeviceMonitor() {
        return this.mDeviceMonitor;
    }

    synchronized boolean startAdb() {
        if (this.mAdbOsLocation == null) {
            Log.e(ADB, "Cannot start adb when AndroidDebugBridge is created without the location of adb.");
            return false;
        }
        int n = -1;
        try {
            String[] stringArray = new String[]{this.mAdbOsLocation, "start-server"};
            Log.d(DDMS, String.format("Launching '%1$s %2$s' to ensure ADB is running.", this.mAdbOsLocation, stringArray[1]));
            Process process = Runtime.getRuntime().exec(stringArray);
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            n = this.grabProcessOutput(process, arrayList, arrayList2, false);
        }
        catch (IOException iOException) {
            Log.d(DDMS, "Unable to run 'adb': " + iOException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            Log.d(DDMS, "Unable to run 'adb': " + interruptedException.getMessage());
        }
        if (n != 0) {
            Log.w(DDMS, "'adb start-server' failed -- run manually if necessary");
            return false;
        }
        Log.d(DDMS, "'adb start-server' succeeded");
        return true;
    }

    private synchronized boolean stopAdb() {
        if (this.mAdbOsLocation == null) {
            Log.e(ADB, "Cannot stop adb when AndroidDebugBridge is created without the location of adb.");
            return false;
        }
        int n = -1;
        try {
            String[] stringArray = new String[]{this.mAdbOsLocation, "kill-server"};
            Process process = Runtime.getRuntime().exec(stringArray);
            n = process.waitFor();
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {}
        if (n != 0) {
            Log.w(DDMS, "'adb kill-server' failed -- run manually if necessary");
            return false;
        }
        Log.d(DDMS, "'adb kill-server' succeeded");
        return true;
    }

    private int grabProcessOutput(final Process process, final ArrayList<String> arrayList, final ArrayList<String> arrayList2, boolean bl) throws InterruptedException {
        assert (arrayList != null);
        assert (arrayList2 != null);
        Thread thread = new Thread(""){

            public void run() {
                InputStreamReader inputStreamReader = new InputStreamReader(process.getErrorStream());
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                try {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        Log.e(AndroidDebugBridge.ADB, string);
                        arrayList.add(string);
                    }
                }
                catch (IOException iOException) {}
            }
        };
        Thread thread2 = new Thread(""){

            public void run() {
                InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                try {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        Log.d(AndroidDebugBridge.ADB, string);
                        arrayList2.add(string);
                    }
                }
                catch (IOException iOException) {}
            }
        };
        thread.start();
        thread2.start();
        if (bl) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
            try {
                thread2.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        return process.waitFor();
    }

    static Object getLock() {
        return sLock;
    }

    public static interface IClientChangeListener {
        public void clientChanged(Client var1, int var2);
    }

    public static interface IDebugBridgeChangeListener {
        public void bridgeChanged(AndroidDebugBridge var1);
    }

    public static interface IDeviceChangeListener {
        public void deviceConnected(IDevice var1);

        public void deviceDisconnected(IDevice var1);

        public void deviceChanged(IDevice var1, int var2);
    }
}

