/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ddms.views;

import com.android.ddmlib.Log;
import com.android.ddmuilib.logcat.LogColors;
import com.android.ddmuilib.logcat.LogFilter;
import com.android.ddmuilib.logcat.LogPanel;
import com.android.ide.eclipse.ddms.CommonAction;
import com.android.ide.eclipse.ddms.DdmsPlugin;
import com.android.ide.eclipse.ddms.ImageLoader;
import com.android.ide.eclipse.ddms.views.SelectionDependentViewPart;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;

public final class LogCatView
extends SelectionDependentViewPart {
    public static final String ID = "com.android.ide.eclipse.ddms.views.LogCatView";
    private static final String PREFS_COL_TIME = "com.android.ide.eclipse.ddms.logcat.time";
    private static final String PREFS_COL_LEVEL = "com.android.ide.eclipse.ddms.logcat.level";
    private static final String PREFS_COL_PID = "com.android.ide.eclipse.ddms.logcat.pid";
    private static final String PREFS_COL_TAG = "com.android.ide.eclipse.ddms.logcat.tag";
    private static final String PREFS_COL_MESSAGE = "com.android.ide.eclipse.ddms.logcat.message";
    private static final String PREFS_FILTERS = "com.android.ide.eclipse.ddms.logcat.filters";
    private static LogCatView sThis;
    private LogPanel mLogPanel;
    private CommonAction mCreateFilterAction;
    private CommonAction mDeleteFilterAction;
    private CommonAction mEditFilterAction;
    private CommonAction mExportAction;
    private CommonAction[] mLogLevelActions;
    private String[] mLogLevelIcons = new String[]{"v.png", "d.png", "i.png", "w.png", "e.png"};
    private Action mClearAction;
    private Clipboard mClipboard;

    public LogCatView() {
        sThis = this;
        LogPanel.PREFS_TIME = PREFS_COL_TIME;
        LogPanel.PREFS_LEVEL = PREFS_COL_LEVEL;
        LogPanel.PREFS_PID = PREFS_COL_PID;
        LogPanel.PREFS_TAG = PREFS_COL_TAG;
        LogPanel.PREFS_MESSAGE = PREFS_COL_MESSAGE;
    }

    public static LogCatView getInstance() {
        return sThis;
    }

    public static void setFont(Font font) {
        if (sThis != null && LogCatView.sThis.mLogPanel != null) {
            LogCatView.sThis.mLogPanel.setFont(font);
        }
    }

    public void createPartControl(Composite composite) {
        String string;
        Display display = composite.getDisplay();
        LogColors logColors = new LogColors();
        ImageLoader imageLoader = DdmsPlugin.getImageLoader();
        logColors.infoColor = new Color((Device)display, 0, 127, 0);
        logColors.debugColor = new Color((Device)display, 0, 0, 127);
        logColors.errorColor = new Color((Device)display, 255, 0, 0);
        logColors.warningColor = new Color((Device)display, 255, 127, 0);
        logColors.verboseColor = new Color((Device)display, 0, 0, 0);
        this.mCreateFilterAction = new CommonAction("Create Filter"){

            public void run() {
                LogCatView.this.mLogPanel.addFilter();
            }
        };
        this.mCreateFilterAction.setToolTipText("Create Filter");
        this.mCreateFilterAction.setImageDescriptor(imageLoader.loadDescriptor("add.png"));
        this.mEditFilterAction = new CommonAction("Edit Filter"){

            public void run() {
                LogCatView.this.mLogPanel.editFilter();
            }
        };
        this.mEditFilterAction.setToolTipText("Edit Filter");
        this.mEditFilterAction.setImageDescriptor(imageLoader.loadDescriptor("edit.png"));
        this.mDeleteFilterAction = new CommonAction("Delete Filter"){

            public void run() {
                LogCatView.this.mLogPanel.deleteFilter();
            }
        };
        this.mDeleteFilterAction.setToolTipText("Delete Filter");
        this.mDeleteFilterAction.setImageDescriptor(imageLoader.loadDescriptor("delete.png"));
        this.mExportAction = new CommonAction("Export Selection As Text..."){

            public void run() {
                LogCatView.this.mLogPanel.save();
            }
        };
        this.mExportAction.setToolTipText("Export Selection As Text...");
        this.mExportAction.setImageDescriptor(imageLoader.loadDescriptor("save.png"));
        Log.LogLevel[] logLevelArray = Log.LogLevel.values();
        this.mLogLevelActions = new CommonAction[this.mLogLevelIcons.length];
        int n = 0;
        while (n < this.mLogLevelActions.length) {
            string = logLevelArray[n].getStringValue();
            this.mLogLevelActions[n] = new CommonAction(string, 2){

                public void run() {
                    int n = 0;
                    while (n < LogCatView.this.mLogLevelActions.length) {
                        CommonAction commonAction = LogCatView.this.mLogLevelActions[n];
                        if (commonAction == this) {
                            commonAction.setChecked(true);
                            LogCatView.this.mLogPanel.setCurrentFilterLogLevel(n + 2);
                        } else {
                            commonAction.setChecked(false);
                        }
                        ++n;
                    }
                }
            };
            this.mLogLevelActions[n].setToolTipText(string);
            this.mLogLevelActions[n].setImageDescriptor(imageLoader.loadDescriptor(this.mLogLevelIcons[n]));
            ++n;
        }
        this.mClearAction = new Action("Clear Log"){

            public void run() {
                LogCatView.this.mLogPanel.clear();
            }
        };
        this.mClearAction.setImageDescriptor(imageLoader.loadDescriptor("clear.png"));
        this.mLogPanel = new LogPanel(imageLoader, logColors, new FilterStorage(), 1);
        this.mLogPanel.setActions(this.mDeleteFilterAction, this.mEditFilterAction, this.mLogLevelActions);
        String string2 = DdmsPlugin.getDefault().getPreferenceStore().getString("com.android.ide.eclipse.ddms.logcatFont");
        if (string2 != null) {
            string = new FontData(string2);
            if (string2 != null) {
                this.mLogPanel.setFont(new Font((Device)composite.getDisplay(), (FontData)string));
            }
        }
        this.mLogPanel.createPanel(composite);
        this.setSelectionDependentPanel(this.mLogPanel);
        this.placeActions();
        this.mClipboard = new Clipboard(display);
        string = this.getViewSite().getActionBars();
        string.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)new Action("Copy"){

            public void run() {
                LogCatView.this.mLogPanel.copy(LogCatView.this.mClipboard);
            }
        });
        string.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)new Action("Select All"){

            public void run() {
                LogCatView.this.mLogPanel.selectAll();
            }
        });
    }

    public void dispose() {
        this.mLogPanel.stopLogCat(true);
        this.mClipboard.dispose();
    }

    public void setFocus() {
        this.mLogPanel.setFocus();
    }

    private void placeActions() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        IMenuManager iMenuManager = iActionBars.getMenuManager();
        iMenuManager.add((IAction)this.mCreateFilterAction);
        iMenuManager.add((IAction)this.mEditFilterAction);
        iMenuManager.add((IAction)this.mDeleteFilterAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.mClearAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.mExportAction);
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        CommonAction[] commonActionArray = this.mLogLevelActions;
        int n = this.mLogLevelActions.length;
        int n2 = 0;
        while (n2 < n) {
            CommonAction commonAction = commonActionArray[n2];
            iToolBarManager.add((IAction)commonAction);
            ++n2;
        }
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.mCreateFilterAction);
        iToolBarManager.add((IAction)this.mEditFilterAction);
        iToolBarManager.add((IAction)this.mDeleteFilterAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.mClearAction);
    }

    private final class FilterStorage
    implements LogPanel.ILogFilterStorageManager {
        private FilterStorage() {
        }

        public LogFilter[] getFilterFromStore() {
            String string = DdmsPlugin.getDefault().getPreferenceStore().getString(LogCatView.PREFS_FILTERS);
            String[] stringArray = string.split("\\|");
            ArrayList<LogFilter> arrayList = new ArrayList<LogFilter>(stringArray.length);
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                LogFilter logFilter;
                String string2 = stringArray2[n2];
                if (string2.length() > 0 && (logFilter = new LogFilter()).loadFromString(string2)) {
                    arrayList.add(logFilter);
                }
                ++n2;
            }
            return arrayList.toArray(new LogFilter[arrayList.size()]);
        }

        public void saveFilters(LogFilter[] logFilterArray) {
            StringBuilder stringBuilder = new StringBuilder();
            LogFilter[] logFilterArray2 = logFilterArray;
            int n = logFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                LogFilter logFilter = logFilterArray2[n2];
                String string = logFilter.toString();
                stringBuilder.append(string);
                stringBuilder.append('|');
                ++n2;
            }
            DdmsPlugin.getDefault().getPreferenceStore().setValue(LogCatView.PREFS_FILTERS, stringBuilder.toString());
        }

        public boolean requiresDefaultFilter() {
            return true;
        }
    }
}

