/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.explorer;

import com.android.ddmlib.FileListingService;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.SyncService;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.Panel;
import com.android.ddmuilib.TableHelper;
import com.android.ddmuilib.actions.ICommonAction;
import com.android.ddmuilib.console.DdmConsole;
import com.android.ddmuilib.explorer.DeviceContentProvider;
import com.android.ddmuilib.explorer.FileLabelProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class DeviceExplorer
extends Panel {
    private static final String TRACE_KEY_EXT = ".key";
    private static final String TRACE_DATA_EXT = ".data";
    private static Pattern mKeyFilePattern = Pattern.compile("(.+)\\.key");
    private static Pattern mDataFilePattern = Pattern.compile("(.+)\\.data");
    public static String COLUMN_NAME = "android.explorer.name";
    public static String COLUMN_SIZE = "android.explorer.size";
    public static String COLUMN_DATE = "android.explorer.data";
    public static String COLUMN_TIME = "android.explorer.time";
    public static String COLUMN_PERMISSIONS = "android.explorer.permissions";
    public static String COLUMN_INFO = "android.explorer.info";
    private Composite mParent;
    private TreeViewer mTreeViewer;
    private Tree mTree;
    private DeviceContentProvider mContentProvider;
    private ICommonAction mPushAction;
    private ICommonAction mPullAction;
    private ICommonAction mDeleteAction;
    private Image mFileImage;
    private Image mFolderImage;
    private Image mPackageImage;
    private Image mOtherImage;
    private IDevice mCurrentDevice;
    private String mDefaultSave;

    public void setImages(Image image, Image image2, Image image3, Image image4) {
        this.mFileImage = image;
        this.mFolderImage = image2;
        this.mPackageImage = image3;
        this.mOtherImage = image4;
    }

    public void setActions(ICommonAction iCommonAction, ICommonAction iCommonAction2, ICommonAction iCommonAction3) {
        this.mPushAction = iCommonAction;
        this.mPullAction = iCommonAction2;
        this.mDeleteAction = iCommonAction3;
    }

    protected Control createControl(Composite composite) {
        this.mParent = composite;
        composite.setLayout((Layout)new FillLayout());
        this.mTree = new Tree(composite, 0x10010002);
        this.mTree.setHeaderVisible(true);
        IPreferenceStore iPreferenceStore = DdmUiPreferences.getStore();
        TableHelper.createTreeColumn(this.mTree, "Name", 16384, "0000drwxrwxrwx", COLUMN_NAME, iPreferenceStore);
        TableHelper.createTreeColumn(this.mTree, "Size", 131072, "000000", COLUMN_SIZE, iPreferenceStore);
        TableHelper.createTreeColumn(this.mTree, "Date", 16384, "2007-08-14", COLUMN_DATE, iPreferenceStore);
        TableHelper.createTreeColumn(this.mTree, "Time", 16384, "20:54", COLUMN_TIME, iPreferenceStore);
        TableHelper.createTreeColumn(this.mTree, "Permissions", 16384, "drwxrwxrwx", COLUMN_PERMISSIONS, iPreferenceStore);
        TableHelper.createTreeColumn(this.mTree, "Info", 16384, "drwxrwxrwx", COLUMN_INFO, iPreferenceStore);
        this.mTreeViewer = new TreeViewer(this.mTree);
        this.mContentProvider = new DeviceContentProvider();
        this.mTreeViewer.setContentProvider((IContentProvider)this.mContentProvider);
        this.mTreeViewer.setLabelProvider((IBaseLabelProvider)new FileLabelProvider(this.mFileImage, this.mFolderImage, this.mPackageImage, this.mOtherImage));
        this.mTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ISelection iSelection = selectionChangedEvent.getSelection();
                if (iSelection.isEmpty()) {
                    DeviceExplorer.this.mPullAction.setEnabled(false);
                    DeviceExplorer.this.mPushAction.setEnabled(false);
                    DeviceExplorer.this.mDeleteAction.setEnabled(false);
                    return;
                }
                if (iSelection instanceof IStructuredSelection) {
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                    Object object = iStructuredSelection.getFirstElement();
                    if (object == null) {
                        return;
                    }
                    if (object instanceof FileListingService.FileEntry) {
                        DeviceExplorer.this.mPullAction.setEnabled(true);
                        DeviceExplorer.this.mPushAction.setEnabled(iStructuredSelection.size() == 1);
                        if (iStructuredSelection.size() == 1) {
                            DeviceExplorer.this.setDeleteEnabledState((FileListingService.FileEntry)object);
                        } else {
                            DeviceExplorer.this.mDeleteAction.setEnabled(false);
                        }
                    }
                }
            }
        });
        this.mTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                IStructuredSelection iStructuredSelection;
                ISelection iSelection = doubleClickEvent.getSelection();
                if (iSelection instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)iSelection).size() == 1) {
                    FileListingService.FileEntry fileEntry = (FileListingService.FileEntry)iStructuredSelection.getFirstElement();
                    String string = fileEntry.getName();
                    FileListingService.FileEntry fileEntry2 = fileEntry.getParent();
                    if (fileEntry2 == null) {
                        return;
                    }
                    Matcher matcher = mKeyFilePattern.matcher(string);
                    if (matcher.matches()) {
                        String string2 = matcher.group(1);
                        String string3 = String.valueOf(string2) + DeviceExplorer.TRACE_DATA_EXT;
                        FileListingService.FileEntry fileEntry3 = fileEntry2.findChild(string3);
                        DeviceExplorer.this.handleTraceDoubleClick(string2, fileEntry, fileEntry3);
                    } else {
                        matcher = mDataFilePattern.matcher(string);
                        if (matcher.matches()) {
                            String string4 = matcher.group(1);
                            String string5 = String.valueOf(string4) + DeviceExplorer.TRACE_KEY_EXT;
                            FileListingService.FileEntry fileEntry4 = fileEntry2.findChild(string5);
                            DeviceExplorer.this.handleTraceDoubleClick(string4, fileEntry4, fileEntry);
                        }
                    }
                }
            }
        });
        this.mTreeViewer.addDropSupport(3, new Transfer[]{FileTransfer.getInstance()}, (DropTargetListener)new ViewerDropAdapter((Viewer)this.mTreeViewer){

            public boolean performDrop(Object object) {
                FileListingService.FileEntry fileEntry = (FileListingService.FileEntry)this.getCurrentTarget();
                if (fileEntry == null) {
                    return false;
                }
                if (!fileEntry.isDirectory()) {
                    fileEntry = fileEntry.getParent();
                }
                if (fileEntry == null) {
                    return false;
                }
                String[] stringArray = (String[])object;
                DeviceExplorer.this.pushFiles(stringArray, fileEntry);
                DeviceExplorer.this.refresh(fileEntry);
                return true;
            }

            public boolean validateDrop(Object object, int n, TransferData transferData) {
                if (object == null) {
                    return false;
                }
                FileListingService.FileEntry fileEntry = (FileListingService.FileEntry)object;
                if (!fileEntry.isDirectory()) {
                    object = fileEntry.getParent();
                }
                return object != null;
            }
        });
        new Thread("Device Ls refresher"){

            public void run() {
                block3: {
                    while (true) {
                        try {
                            4.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                        if (DeviceExplorer.this.mTree == null || DeviceExplorer.this.mTree.isDisposed()) break block3;
                        Display display = DeviceExplorer.this.mTree.getDisplay();
                        if (display.isDisposed()) break;
                        display.asyncExec(new Runnable(){

                            public void run() {
                                if (!DeviceExplorer.this.mTree.isDisposed()) {
                                    DeviceExplorer.this.mTreeViewer.refresh(true);
                                }
                            }
                        });
                    }
                    return;
                }
            }
        }.start();
        return this.mTree;
    }

    protected void postCreation() {
    }

    public void setFocus() {
        this.mTree.setFocus();
    }

    private void handleTraceDoubleClick(String string, FileListingService.FileEntry fileEntry, FileListingService.FileEntry fileEntry2) {
        File file;
        File file2;
        String string2;
        Object object;
        try {
            object = File.createTempFile(string, ".trace");
            ((File)object).delete();
            ((File)object).mkdir();
            string2 = ((File)object).getAbsolutePath();
            file2 = new File(String.valueOf(string2) + File.separator + fileEntry.getName());
            file = new File(String.valueOf(string2) + File.separator + fileEntry2.getName());
        }
        catch (IOException iOException) {
            return;
        }
        try {
            object = this.mCurrentDevice.getSyncService();
            if (object != null) {
                SyncService.ISyncProgressMonitor iSyncProgressMonitor = SyncService.getNullProgressMonitor();
                SyncService.SyncResult syncResult = ((SyncService)object).pullFile(fileEntry, file2.getAbsolutePath(), iSyncProgressMonitor);
                if (syncResult.getCode() != 0) {
                    DdmConsole.printErrorToConsole(String.format("Failed to pull %1$s: %2$s", fileEntry.getName(), syncResult.getMessage()));
                    return;
                }
                syncResult = ((SyncService)object).pullFile(fileEntry2, file.getAbsolutePath(), iSyncProgressMonitor);
                if (syncResult.getCode() != 0) {
                    DdmConsole.printErrorToConsole(String.format("Failed to pull %1$s: %2$s", fileEntry2.getName(), syncResult.getMessage()));
                    return;
                }
                String[] stringArray = new String[]{DdmUiPreferences.getTraceview(), String.valueOf(string2) + File.separator + string};
                try {
                    final Process process = Runtime.getRuntime().exec(stringArray);
                    new Thread("Traceview output"){

                        public void run() {
                            InputStreamReader inputStreamReader = new InputStreamReader(process.getErrorStream());
                            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                            try {
                                String string;
                                while ((string = bufferedReader.readLine()) != null) {
                                    DdmConsole.printErrorToConsole("Traceview: " + string);
                                }
                                process.waitFor();
                            }
                            catch (IOException iOException) {
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }.start();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            DdmConsole.printErrorToConsole(String.format("Failed to pull %1$s: %2$s", fileEntry.getName(), iOException.getMessage()));
            return;
        }
    }

    public void pullSelection() {
        String string;
        TreeItem[] treeItemArray = this.mTree.getSelection();
        String string2 = null;
        FileListingService.FileEntry fileEntry = null;
        if (treeItemArray.length == 1 && (fileEntry = (FileListingService.FileEntry)treeItemArray[0].getData()).getType() == 0) {
            string2 = fileEntry.getName();
        }
        if ((string = this.mDefaultSave) == null) {
            string = System.getProperty("user.home");
        }
        if (string2 != null) {
            FileDialog fileDialog = new FileDialog(this.mParent.getShell(), 8192);
            fileDialog.setText("Get Device File");
            fileDialog.setFileName(string2);
            fileDialog.setFilterPath(string);
            String string3 = fileDialog.open();
            if (string3 != null) {
                this.mDefaultSave = fileDialog.getFilterPath();
                this.pullFile(fileEntry, string3);
            }
        } else {
            DirectoryDialog directoryDialog = new DirectoryDialog(this.mParent.getShell(), 8192);
            directoryDialog.setText("Get Device Files/Folders");
            directoryDialog.setFilterPath(string);
            String string4 = directoryDialog.open();
            if (string4 != null) {
                this.pullSelection(treeItemArray, string4);
            }
        }
    }

    public void pushIntoSelection() {
        TreeItem[] treeItemArray = this.mTree.getSelection();
        if (treeItemArray.length == 0) {
            return;
        }
        FileDialog fileDialog = new FileDialog(this.mParent.getShell(), 4096);
        fileDialog.setText("Put File on Device");
        FileListingService.FileEntry fileEntry = (FileListingService.FileEntry)treeItemArray[0].getData();
        fileDialog.setFileName(fileEntry.getName());
        String string = this.mDefaultSave;
        if (string == null) {
            string = System.getProperty("user.home");
        }
        fileDialog.setFilterPath(string);
        String string2 = fileDialog.open();
        if (string2 != null) {
            String string3;
            this.mDefaultSave = fileDialog.getFilterPath();
            FileListingService.FileEntry fileEntry2 = fileEntry;
            if (fileEntry.isDirectory()) {
                string3 = fileEntry.getFullPath();
            } else {
                fileEntry2 = fileEntry.getParent();
                string3 = fileEntry2.getFullPath();
            }
            this.pushFile(string2, string3);
            this.mTreeViewer.refresh((Object)fileEntry2);
        }
    }

    public void deleteSelection() {
        TreeItem[] treeItemArray = this.mTree.getSelection();
        if (treeItemArray.length != 1) {
            return;
        }
        FileListingService.FileEntry fileEntry = (FileListingService.FileEntry)treeItemArray[0].getData();
        final FileListingService.FileEntry fileEntry2 = fileEntry.getParent();
        String string = "rm " + fileEntry.getFullEscapedPath();
        try {
            this.mCurrentDevice.executeShellCommand(string, new IShellOutputReceiver(){

                public void addOutput(byte[] byArray, int n, int n2) {
                }

                public void flush() {
                    DeviceExplorer.this.mTreeViewer.refresh((Object)fileEntry2);
                }

                public boolean isCancelled() {
                    return false;
                }
            });
        }
        catch (IOException iOException) {}
    }

    public void refresh() {
        this.mTreeViewer.refresh(true);
    }

    public void switchDevice(IDevice iDevice) {
        if (iDevice != this.mCurrentDevice) {
            this.mCurrentDevice = iDevice;
            if (!this.mTree.isDisposed()) {
                Display display = this.mTree.getDisplay();
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (!DeviceExplorer.this.mTree.isDisposed() && DeviceExplorer.this.mCurrentDevice != null) {
                            FileListingService fileListingService = DeviceExplorer.this.mCurrentDevice.getFileListingService();
                            DeviceExplorer.this.mContentProvider.setListingService(fileListingService);
                            DeviceExplorer.this.mTreeViewer.setInput((Object)fileListingService.getRoot());
                        }
                    }
                });
            }
        }
    }

    private void refresh(final FileListingService.FileEntry fileEntry) {
        Display display = this.mTreeViewer.getTree().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                DeviceExplorer.this.mTreeViewer.refresh((Object)fileEntry);
            }
        });
    }

    private void pullSelection(TreeItem[] treeItemArray, final String string) {
        try {
            final SyncService syncService = this.mCurrentDevice.getSyncService();
            if (syncService != null) {
                FileListingService.FileEntry[] fileEntryArray;
                ArrayList<FileListingService.FileEntry> arrayList = new ArrayList<FileListingService.FileEntry>();
                TreeItem[] treeItemArray2 = treeItemArray;
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    fileEntryArray = treeItemArray2[n2];
                    Object object = fileEntryArray.getData();
                    if (object instanceof FileListingService.FileEntry) {
                        arrayList.add((FileListingService.FileEntry)object);
                    }
                    ++n2;
                }
                fileEntryArray = arrayList.toArray(new FileListingService.FileEntry[arrayList.size()]);
                new ProgressMonitorDialog(this.mParent.getShell()).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                        SyncService.SyncResult syncResult = syncService.pull(fileEntryArray, string, new SyncProgressMonitor(iProgressMonitor, "Pulling file(s) from the device"));
                        if (syncResult.getCode() != 0) {
                            DdmConsole.printErrorToConsole(String.format("Failed to pull selection: %1$s", syncResult.getMessage()));
                        }
                        syncService.close();
                    }
                });
            }
        }
        catch (Exception exception) {
            DdmConsole.printErrorToConsole("Failed to pull selection");
            DdmConsole.printErrorToConsole(exception.getMessage());
        }
    }

    private void pullFile(final FileListingService.FileEntry fileEntry, final String string) {
        try {
            final SyncService syncService = this.mCurrentDevice.getSyncService();
            if (syncService != null) {
                new ProgressMonitorDialog(this.mParent.getShell()).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                        SyncService.SyncResult syncResult = syncService.pullFile(fileEntry, string, new SyncProgressMonitor(iProgressMonitor, String.format("Pulling %1$s from the device", fileEntry.getName())));
                        if (syncResult.getCode() != 0) {
                            DdmConsole.printErrorToConsole(String.format("Failed to pull %1$s: %2$s", fileEntry, syncResult.getMessage()));
                        }
                        syncService.close();
                    }
                });
            }
        }
        catch (Exception exception) {
            DdmConsole.printErrorToConsole("Failed to pull selection");
            DdmConsole.printErrorToConsole(exception.getMessage());
        }
    }

    private void pushFiles(final String[] stringArray, final FileListingService.FileEntry fileEntry) {
        try {
            final SyncService syncService = this.mCurrentDevice.getSyncService();
            if (syncService != null) {
                new ProgressMonitorDialog(this.mParent.getShell()).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                        SyncService.SyncResult syncResult = syncService.push(stringArray, fileEntry, new SyncProgressMonitor(iProgressMonitor, "Pushing file(s) to the device"));
                        if (syncResult.getCode() != 0) {
                            DdmConsole.printErrorToConsole(String.format("Failed to push the items: %1$s", syncResult.getMessage()));
                        }
                        syncService.close();
                    }
                });
            }
        }
        catch (Exception exception) {
            DdmConsole.printErrorToConsole("Failed to push the items");
            DdmConsole.printErrorToConsole(exception.getMessage());
        }
    }

    private void pushFile(final String string, final String string2) {
        try {
            final SyncService syncService = this.mCurrentDevice.getSyncService();
            if (syncService != null) {
                new ProgressMonitorDialog(this.mParent.getShell()).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                        String[] stringArray = string.split(Pattern.quote(File.separator));
                        String string3 = stringArray[stringArray.length - 1];
                        String string22 = String.valueOf(string2) + "/" + string3;
                        SyncService.SyncResult syncResult = syncService.pushFile(string, string22, new SyncProgressMonitor(iProgressMonitor, String.format("Pushing %1$s to the device.", string3)));
                        if (syncResult.getCode() != 0) {
                            DdmConsole.printErrorToConsole(String.format("Failed to push %1$s on %2$s: %3$s", string3, DeviceExplorer.this.mCurrentDevice.getSerialNumber(), syncResult.getMessage()));
                        }
                        syncService.close();
                    }
                });
            }
        }
        catch (Exception exception) {
            DdmConsole.printErrorToConsole("Failed to push the item(s).");
            DdmConsole.printErrorToConsole(exception.getMessage());
        }
    }

    protected void setDeleteEnabledState(FileListingService.FileEntry fileEntry) {
        this.mDeleteAction.setEnabled(fileEntry.getType() == 0);
    }

    private static class SyncProgressMonitor
    implements SyncService.ISyncProgressMonitor {
        private IProgressMonitor mMonitor;
        private String mName;

        SyncProgressMonitor(IProgressMonitor iProgressMonitor, String string) {
            this.mMonitor = iProgressMonitor;
            this.mName = string;
        }

        public void start(int n) {
            this.mMonitor.beginTask(this.mName, n);
        }

        public void stop() {
            this.mMonitor.done();
        }

        public void advance(int n) {
            this.mMonitor.worked(n);
        }

        public boolean isCanceled() {
            return this.mMonitor.isCanceled();
        }

        public void startSubTask(String string) {
            this.mMonitor.subTask(string);
        }
    }
}

