/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.BadPacketException;
import com.android.ddmlib.ChunkHandler;
import com.android.ddmlib.Log;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;

final class JdwpPacket {
    public static final int JDWP_HEADER_LEN = 11;
    public static final int HANDSHAKE_GOOD = 1;
    public static final int HANDSHAKE_NOTYET = 2;
    public static final int HANDSHAKE_BAD = 3;
    private static final int DDMS_CMD_SET = 199;
    private static final int DDMS_CMD = 1;
    private static final int REPLY_PACKET = 128;
    private static final byte[] mHandshake = new byte[]{74, 68, 87, 80, 45, 72, 97, 110, 100, 115, 104, 97, 107, 101};
    public static final int HANDSHAKE_LEN = mHandshake.length;
    private ByteBuffer mBuffer;
    private int mLength;
    private int mId;
    private int mFlags;
    private int mCmdSet;
    private int mCmd;
    private int mErrCode;
    private boolean mIsNew;
    private static int mSerialId = 0x40000000;

    JdwpPacket(ByteBuffer byteBuffer) {
        this.mBuffer = byteBuffer;
        this.mIsNew = true;
    }

    void finishPacket(int n) {
        assert (this.mIsNew);
        ByteOrder byteOrder = this.mBuffer.order();
        this.mBuffer.order(ChunkHandler.CHUNK_ORDER);
        this.mLength = 11 + n;
        this.mId = JdwpPacket.getNextSerial();
        this.mFlags = 0;
        this.mCmdSet = 199;
        this.mCmd = 1;
        this.mBuffer.putInt(0, this.mLength);
        this.mBuffer.putInt(4, this.mId);
        this.mBuffer.put(8, (byte)this.mFlags);
        this.mBuffer.put(9, (byte)this.mCmdSet);
        this.mBuffer.put(10, (byte)this.mCmd);
        this.mBuffer.order(byteOrder);
        this.mBuffer.position(this.mLength);
    }

    private static synchronized int getNextSerial() {
        return mSerialId++;
    }

    ByteBuffer getPayload() {
        int n = this.mBuffer.position();
        this.mBuffer.position(11);
        ByteBuffer byteBuffer = this.mBuffer.slice();
        this.mBuffer.position(n);
        if (this.mLength > 0) {
            byteBuffer.limit(this.mLength - 11);
        } else assert (this.mIsNew);
        byteBuffer.order(ChunkHandler.CHUNK_ORDER);
        return byteBuffer;
    }

    boolean isDdmPacket() {
        return (this.mFlags & 0x80) == 0 && this.mCmdSet == 199 && this.mCmd == 1;
    }

    boolean isReply() {
        return (this.mFlags & 0x80) != 0;
    }

    boolean isError() {
        return this.isReply() && this.mErrCode != 0;
    }

    boolean isEmpty() {
        return this.mLength == 11;
    }

    int getId() {
        return this.mId;
    }

    int getLength() {
        return this.mLength;
    }

    void writeAndConsume(SocketChannel socketChannel) throws IOException {
        assert (this.mLength > 0);
        this.mBuffer.flip();
        int n = this.mBuffer.limit();
        this.mBuffer.limit(this.mLength);
        while (this.mBuffer.position() != this.mBuffer.limit()) {
            socketChannel.write(this.mBuffer);
        }
        assert (this.mBuffer.position() == this.mLength);
        this.mBuffer.limit(n);
        this.mBuffer.compact();
    }

    void movePacket(ByteBuffer byteBuffer) {
        Log.v("ddms", "moving " + this.mLength + " bytes");
        int n = this.mBuffer.position();
        this.mBuffer.position(0);
        this.mBuffer.limit(this.mLength);
        byteBuffer.put(this.mBuffer);
        this.mBuffer.position(this.mLength);
        this.mBuffer.limit(n);
        this.mBuffer.compact();
    }

    void consume() {
        this.mBuffer.flip();
        this.mBuffer.position(this.mLength);
        this.mBuffer.compact();
        this.mLength = 0;
    }

    static JdwpPacket findPacket(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        if (n < 11) {
            return null;
        }
        ByteOrder byteOrder = byteBuffer.order();
        byteBuffer.order(ChunkHandler.CHUNK_ORDER);
        int n2 = byteBuffer.getInt(0);
        int n3 = byteBuffer.getInt(4);
        int n4 = byteBuffer.get(8) & 0xFF;
        int n5 = byteBuffer.get(9) & 0xFF;
        int n6 = byteBuffer.get(10) & 0xFF;
        byteBuffer.order(byteOrder);
        if (n2 < 11) {
            throw new BadPacketException();
        }
        if (n < n2) {
            return null;
        }
        JdwpPacket jdwpPacket = new JdwpPacket(byteBuffer);
        jdwpPacket.mLength = n2;
        jdwpPacket.mId = n3;
        jdwpPacket.mFlags = n4;
        if ((n4 & 0x80) == 0) {
            jdwpPacket.mCmdSet = n5;
            jdwpPacket.mCmd = n6;
            jdwpPacket.mErrCode = -1;
        } else {
            jdwpPacket.mCmdSet = -1;
            jdwpPacket.mCmd = -1;
            jdwpPacket.mErrCode = n5 | n6 << 8;
        }
        return jdwpPacket;
    }

    static int findHandshake(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        if (n < mHandshake.length) {
            return 2;
        }
        int n2 = mHandshake.length - 1;
        while (n2 >= 0) {
            if (byteBuffer.get(n2) != mHandshake[n2]) {
                return 3;
            }
            --n2;
        }
        return 1;
    }

    static void consumeHandshake(ByteBuffer byteBuffer) {
        byteBuffer.flip();
        byteBuffer.position(mHandshake.length);
        byteBuffer.compact();
    }

    static void putHandshake(ByteBuffer byteBuffer) {
        byteBuffer.put(mHandshake);
    }
}

