package yamamoto.lab.tutorial.v1.s6;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.TextView;

public class Display extends Activity {
	private static final int EDIT = Menu.FIRST;
	private static final int ACTIVITY_EDIT = 0;
	private TextView tv;
	
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.display);
        tv = (TextView) findViewById(R.id.text);
    }
    
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
    	super.onCreateOptionsMenu(menu);
    	menu.add(0, EDIT, 0, R.string.button);
    	return true;
    }
    
    @Override
    public boolean onMenuItemSelected(int featureId, MenuItem item) {
    	switch (item.getItemId()) {
    	case EDIT:
    		edit();
    		return true;
    	}
    	return super.onMenuItemSelected(featureId, item);
    }
    
    private void edit() {
    	Bundle bundle = new Bundle();
    	bundle.putString("string", tv.getText().toString());
 
    	Intent i = new Intent(this, Edit.class);
    	if (bundle != null) {
    		i.putExtras(bundle);
    	}
    	startActivityForResult(i, ACTIVITY_EDIT);
    }
    
    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
    	super.onActivityResult(requestCode, resultCode, intent);
    	Bundle extras = intent.getExtras();
    	
    	switch (requestCode) {
    	case ACTIVITY_EDIT:
    		String text = extras.getString("string");
    		if (text != null) {
    			tv.setText(text);
    		}
    		break;
    	}
    }
}