module ParseArgument
( parseArgument
) where

import Text.ParserCombinators.Parsec
import Data.Char
import Data

argSymbol = oneOf ":_/.-\"\\"

parseArgument :: Parser Argument
parseArgument = do x <- noneOf "-\"=_"
                   xs <- many1 (alphaNum <|> argSymbol)
                   spaces
                   return $ Argument (x:xs)