module JavacOptArg
( parseJavacOptArg,
) where

import Text.ParserCombinators.Parsec
import ParseArgument
import Data

parseJavacOptArg :: Parser Option
parseJavacOptArg = do xs <- javacoptarg
                      spaces 
                      ys <- parseArgument
                      spaces
                      return $ Option xs [ys] 

javacoptarg = foldl1 (<|>) $ map try [(string "-d"), 
                                     (string "-encording"),
                                     (string "sourcepath"),
                                     (string "-classpath"),
                                     (string "-target"),
                                     (string "-bootclasspath")
                                     ]
